#ifndef _EFL_UI_FOCUS_OBJECT_EO_H_
#define _EFL_UI_FOCUS_OBJECT_EO_H_

#ifndef _EFL_UI_FOCUS_OBJECT_EO_CLASS_TYPE
#define _EFL_UI_FOCUS_OBJECT_EO_CLASS_TYPE

typedef Eo Efl_Ui_Focus_Object;

#endif

#ifndef _EFL_UI_FOCUS_OBJECT_EO_TYPES
#define _EFL_UI_FOCUS_OBJECT_EO_TYPES


#endif
/** Functions of focusable objects.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
#define EFL_UI_FOCUS_OBJECT_MIXIN efl_ui_focus_object_mixin_get()

EWAPI const Efl_Class *efl_ui_focus_object_mixin_get(void);

/**
 * @brief The geometry used to calculate relationships between other objects.
 *
 * @param[in] obj The object.
 *
 * @return The geometry to use.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI Eina_Rect efl_ui_focus_object_focus_geometry_get(const Eo *obj);

#ifdef EFL_UI_FOCUS_OBJECT_PROTECTED
/**
 * @brief This is called by the manager and should never be called by anyone
 * else.
 *
 * It can be used by configuring a focus object to adapt to any changes that
 * are required.
 *
 * The function emits the focus state events, if focus is different to the
 * previous state.
 *
 * @param[in] obj The object.
 * @param[in] focus The state in which the object should be put
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI void efl_ui_focus_object_focus_set(Eo *obj, Eina_Bool focus);
#endif

/**
 * @brief This is called by the manager and should never be called by anyone
 * else.
 *
 * It can be used by configuring a focus object to adapt to any changes that
 * are required.
 *
 * The function emits the focus state events, if focus is different to the
 * previous state.
 *
 * @param[in] obj The object.
 *
 * @return The state in which the object should be put
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI Eina_Bool efl_ui_focus_object_focus_get(const Eo *obj);

/**
 * @brief Describes which manager is used to register.
 *
 * If an instance of this interface is the root of a manager, this instance
 * should not have a manager where as root of this property. The other manager
 * in this instance will be set as focused in the corresponding manager. This
 * instance should be registered with its own manager as redirect.
 *
 * @param[in] obj The object.
 *
 * @return The manager object
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI Efl_Ui_Focus_Manager *efl_ui_focus_object_focus_manager_get(const Eo *obj);

/**
 * @brief Describes which logical parent is used by this object.
 *
 * @param[in] obj The object.
 *
 * @return The focus parent.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI Efl_Ui_Focus_Object *efl_ui_focus_object_focus_parent_get(const Eo *obj);

/**
 * @brief Tells the object that its children will be queried soon by the given
 * manager. The call will be a NOP if there is already a active
 * preprare_logical call on this object
 *
 * Deleting manager items in this call will result in undefied behaviour and
 * may cause your system to crash.
 *
 * @param[in] obj The object.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI void efl_ui_focus_object_prepare_logical(Eo *obj);

#ifdef EFL_UI_FOCUS_OBJECT_PROTECTED
/** No description supplied.
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI void efl_ui_focus_object_prepare_logical_none_recursive(Eo *obj);
#endif

#ifdef EFL_UI_FOCUS_OBJECT_PROTECTED
/**
 * @brief Virtual function handling focus in/out events on the widget
 *
 * @param[in] obj The object.
 *
 * @return @c true if this widget can handle focus, @c false otherwise
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
EOAPI Eina_Bool efl_ui_focus_object_on_focus_update(Eo *obj);
#endif

EWAPI extern const Efl_Event_Description _EFL_UI_FOCUS_OBJECT_EVENT_FOCUS_CHANGED;

/** Emitted if the focus state has changed
 * @return Eina_Bool
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
#define EFL_UI_FOCUS_OBJECT_EVENT_FOCUS_CHANGED (&(_EFL_UI_FOCUS_OBJECT_EVENT_FOCUS_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_FOCUS_OBJECT_EVENT_MANAGER_CHANGED;

/** Emitted when a new manager is the parent for this object.
 * @return Efl_Ui_Focus_Manager *
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
#define EFL_UI_FOCUS_OBJECT_EVENT_MANAGER_CHANGED (&(_EFL_UI_FOCUS_OBJECT_EVENT_MANAGER_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_FOCUS_OBJECT_EVENT_LOGICAL_CHANGED;

/** Emitted when a new logical parent should be used.
 * @return Efl_Ui_Focus_Object *
 *
 * @since 1.20
 *
 * @ingroup Efl_Ui_Focus_Object
 */
#define EFL_UI_FOCUS_OBJECT_EVENT_LOGICAL_CHANGED (&(_EFL_UI_FOCUS_OBJECT_EVENT_LOGICAL_CHANGED))

#endif
