#ifndef _EFL_UI_PAGER_EO_H_
#define _EFL_UI_PAGER_EO_H_

#ifndef _EFL_UI_PAGER_EO_CLASS_TYPE
#define _EFL_UI_PAGER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Pager;

#endif

#ifndef _EFL_UI_PAGER_EO_TYPES
#define _EFL_UI_PAGER_EO_TYPES

/** Efl ui pager loop mode
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_PAGER_LOOP_DISABLED = 0,
  EFL_UI_PAGER_LOOP_ENABLED
} Efl_Ui_Pager_Loop;


#endif
/**
 * @brief Pager widget
 *
 * A pager contains many pages in a linear fashion and allows users to scroll
 * through pages. Each page is numbered according to linear order and one of
 * the pages is marked as 'current page' and displayed in the middle. The way
 * each page is displayed is defined by @ref Efl_Page_Transition object,
 * allowing users to adopt different types of transition. The most common use
 * case of this widget is the home screen of mobile devices.
 *
 * @ingroup Efl_Ui_Pager
 */
#define EFL_UI_PAGER_CLASS efl_ui_pager_class_get()

EWAPI const Efl_Class *efl_ui_pager_class_get(void);

/**
 * @brief Page transition effect
 *
 * Page transition is in charge of displaying pages in a specific way and
 * invoked every time page layout needs to be updated.
 *
 * Set a page transition effect
 *
 * @param[in] obj The object.
 * @param[in] transition transition effect
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_transition_set(Eo *obj, Efl_Page_Transition *transition);

/**
 * @brief Page indicator
 *
 * Page indicator, located on the top layer of pager widget, helps users to
 * know the number of pages and the current page's index without scrolling.
 *
 * Set a page indicator
 *
 * @param[in] obj The object.
 * @param[in] indicator indicator class
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_indicator_set(Eo *obj, Efl_Page_Indicator *indicator);

/**
 * @brief One page is selected as the current page and mainly displayed.
 *
 * Set one page as current page
 *
 * @param[in] obj The object.
 * @param[in] index
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_current_page_set(Eo *obj, int index);

/**
 * @brief One page is selected as the current page and mainly displayed.
 *
 * Get the current page
 * @param[in] obj The object.
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI int efl_ui_pager_current_page_get(const Eo *obj);

/**
 * @brief Pages can be scrolled back and forth by default. This property allows
 * limiting the direction of scrolling, or blocking scroll gesture at all.
 *
 * @param[in] obj The object.
 * @param[in] prev
 * @param[in] next
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_scroll_block_set(Eo *obj, Eina_Bool prev, Eina_Bool next);

/**
 * @brief Pages can be scrolled back and forth by default. This property allows
 * limiting the direction of scrolling, or blocking scroll gesture at all.
 *
 * @param[in] obj The object.
 * @param[out] prev
 * @param[out] next
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_scroll_block_get(const Eo *obj, Eina_Bool *prev, Eina_Bool *next);

/**
 * @brief Pager is not scrolled after it's scrolled to the end by default. This
 * property gives the option to make a loop through pages.
 *
 * @param[in] obj The object.
 * @param[in] loop
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI void efl_ui_pager_loop_mode_set(Eo *obj, Efl_Ui_Pager_Loop loop);

/** Pager is not scrolled after it's scrolled to the end by default. This
 * property gives the option to make a loop through pages.
 *
 * @ingroup Efl_Ui_Pager
 */
EOAPI Efl_Ui_Pager_Loop efl_ui_pager_loop_mode_get(const Eo *obj);

EOAPI void efl_ui_pager_page_size_set(Eo *obj, Eina_Size2D size);

EOAPI Eina_Size2D efl_ui_pager_page_size_get(const Eo *obj);

EOAPI void efl_ui_pager_padding_set(Eo *obj, int padding);

EOAPI int efl_ui_pager_padding_get(const Eo *obj);

#endif
