#ifndef EFL_INTERFACE_EO_HH
#define EFL_INTERFACE_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_interface.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#ifndef EFL_INTERFACE_FWD_GUARD
#define EFL_INTERFACE_FWD_GUARD
namespace efl { 
struct Interface;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Interface> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Interface&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Interface const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Interface const&> : ::std::true_type {}; } }
#endif

namespace eo_cxx {
namespace efl { 
struct Interface {
   static Efl_Class const* _eo_class()
   {
      return EFL_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(reinterpret_cast<Eo **>(const_cast<Interface *>(this))); }
   operator ::efl::Interface() const;
   operator ::efl::Interface&();
   operator ::efl::Interface const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Interface : private ::efl::eo::concrete
{
   explicit Interface( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   Interface(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   explicit Interface() = default;
   Interface(Interface const&) = default;
   Interface(Interface&&) = default;
   Interface& operator=(Interface const&) = default;
   Interface& operator=(Interface&&) = default;
   template <typename Derived>
   Interface(Derived&& derived
      , typename std::enable_if<
         ::efl::eo::is_eolian_object<Derived>::value
          && std::is_base_of< Interface, Derived>::value>::type* = 0)
         : ::efl::eo::concrete(derived._eo_ptr()) {}

   static Efl_Class const* _eo_class()
   {
      return EFL_INTERFACE_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(reinterpret_cast<Eo **>(const_cast<Interface *>(this))); }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Interface> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Interface const > operator&() const { return {this}; }
   /// @endcond
   ::efl::eo::wref<Interface> _get_wref() const { return ::efl::eo::wref<Interface>(*this); }
   ::efl::eo::concrete const& _get_concrete() const { return *this; }
   ::efl::eo::concrete& _get_concrete() { return *this; }
   using ::efl::eo::concrete::_eo_ptr;
   using ::efl::eo::concrete::_release;
   using ::efl::eo::concrete::_reset;
   using ::efl::eo::concrete::_delete;
   using ::efl::eo::concrete::operator bool;
#ifdef EFL_CXXPERIMENTAL
   const Interface* operator->() const { return this; }
   Interface* operator->() { return this; }
   operator Eo*() const { return _eo_ptr(); }
#endif 
   friend bool operator==(Interface const& lhs, Interface const& rhs)
   { return lhs._get_concrete() == rhs._get_concrete(); }
   friend bool operator!=(Interface const& lhs, Interface const& rhs)
   { return !(lhs == rhs); }
};
static_assert(sizeof(Interface) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Interface>::value, "");
} 
#endif
