#ifndef _EFL_INPUT_HOLD_EO_H_
#define _EFL_INPUT_HOLD_EO_H_

#ifndef _EFL_INPUT_HOLD_EO_CLASS_TYPE
#define _EFL_INPUT_HOLD_EO_CLASS_TYPE

typedef Eo Efl_Input_Hold;

#endif

#ifndef _EFL_INPUT_HOLD_EO_TYPES
#define _EFL_INPUT_HOLD_EO_TYPES


#endif
/** Event data sent when inputs are put on hold or resumed.
 *
 * @ingroup Efl_Input_Hold
 */
#define EFL_INPUT_HOLD_CLASS efl_input_hold_class_get()

EWAPI const Efl_Class *efl_input_hold_class_get(void);

/**
 * @brief Property to show if inputs are now on hold.
 *
 * @param[in] obj The object.
 * @param[in] val @c true if inputs are on hold, @c false otherwise
 *
 * @ingroup Efl_Input_Hold
 */
EOAPI void efl_input_hold_set(Eo *obj, Eina_Bool val);

/**
 * @brief Property to show if inputs are now on hold.
 *
 * @param[in] obj The object.
 *
 * @return @c true if inputs are on hold, @c false otherwise
 *
 * @ingroup Efl_Input_Hold
 */
EOAPI Eina_Bool efl_input_hold_get(const Eo *obj);

#endif
