/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLName {
    protected String fullURL;
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private String ref;
    private String username;
    private String password;
    private InetAddress hostAddress;
    private boolean gotHostAddress = false;
    private int hashCode;

    public URLName(String protocol, String host, int port, String file, String username, String password) {
        int hashIndex;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.file = file;
        if (file != null && (hashIndex = file.indexOf(35)) != -1) {
            this.file = file.substring(0, hashIndex);
            this.ref = file.substring(hashIndex + 1);
        }
        this.username = username;
        this.password = password;
    }

    public URLName(URL url) {
        this(url.toString());
    }

    public URLName(String url) {
        this.parseString(url);
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getProtocol(), this.getHost(), this.getPort(), this.getFile());
    }

    public String toString() {
        if (this.fullURL == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.protocol != null) {
                buffer.append(this.protocol);
                buffer.append(":");
            }
            if (this.username != null || this.host != null) {
                buffer.append("//");
                if (this.username != null) {
                    buffer.append(this.username);
                    if (this.password != null) {
                        buffer.append(":");
                        buffer.append(this.password);
                    }
                    buffer.append("@");
                }
                if (this.host != null) {
                    buffer.append(this.host);
                }
                if (this.port != -1) {
                    buffer.append(":");
                    buffer.append(Integer.toString(this.port));
                }
                if (this.file != null) {
                    buffer.append("/");
                }
            }
            if (this.file != null) {
                buffer.append(this.file);
            }
            if (this.ref != null) {
                buffer.append("#");
                buffer.append(this.ref);
            }
            this.fullURL = buffer.toString();
        }
        return this.fullURL;
    }

    public boolean equals(Object other) {
        String otherFile;
        if (other == this) {
            return true;
        }
        if (!(other instanceof URLName)) {
            return false;
        }
        URLName url = (URLName)other;
        if (url.protocol == null || !url.protocol.equals(this.protocol)) {
            return false;
        }
        InetAddress address = this.getHostAddress();
        InetAddress otherAddress = url.getHostAddress();
        if (address != null && otherAddress != null ? !address.equals(otherAddress) : this.host != null && !this.host.equalsIgnoreCase(url.host)) {
            return false;
        }
        if (!(this.username == url.username || this.username != null && this.username.equals(url.username))) {
            return false;
        }
        String fileNormalized = this.file != null ? this.file : "";
        String string = otherFile = url.file != null ? url.file : "";
        if (!fileNormalized.equals(otherFile)) {
            return false;
        }
        return this.port == url.port;
    }

    public int hashCode() {
        InetAddress address;
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.protocol != null) {
            this.hashCode += this.protocol.hashCode();
        }
        if ((address = this.getHostAddress()) != null) {
            this.hashCode += address.hashCode();
        } else if (this.host != null) {
            this.hashCode += this.host.toLowerCase().hashCode();
        }
        if (this.username != null) {
            this.hashCode += this.username.hashCode();
        }
        if (this.file != null) {
            this.hashCode += this.file.hashCode();
        }
        this.hashCode += this.port;
        return this.hashCode;
    }

    private synchronized InetAddress getHostAddress() {
        if (this.gotHostAddress) {
            return this.hostAddress;
        }
        if (this.host == null) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            this.hostAddress = null;
        }
        this.gotHostAddress = true;
        return this.hostAddress;
    }

    protected void parseString(String url) {
        int hashIndex;
        this.password = null;
        this.username = null;
        this.host = null;
        this.ref = null;
        this.file = null;
        this.protocol = null;
        this.port = -1;
        int len = url.length();
        int colonIndex = url.indexOf(58);
        if (colonIndex != -1) {
            this.protocol = url.substring(0, colonIndex);
        }
        if (url.regionMatches(colonIndex + 1, "//", 0, 2)) {
            String hostPart;
            int slashIndex = url.indexOf(47, colonIndex + 3);
            if (slashIndex != -1) {
                hostPart = url.substring(colonIndex + 3, slashIndex);
                this.file = slashIndex + 1 < len ? url.substring(slashIndex + 1) : "";
            } else {
                hostPart = url.substring(colonIndex + 3);
            }
            int atIndex = hostPart.lastIndexOf(64);
            if (atIndex != -1) {
                String userPart = hostPart.substring(0, atIndex);
                hostPart = hostPart.substring(atIndex + 1);
                colonIndex = userPart.indexOf(58);
                if (colonIndex != -1) {
                    this.username = userPart.substring(0, colonIndex);
                    this.password = userPart.substring(colonIndex + 1);
                } else {
                    this.username = userPart;
                }
            }
            if ((colonIndex = hostPart.length() > 0 && hostPart.charAt(0) == '[' ? hostPart.indexOf(58, hostPart.indexOf(93)) : hostPart.indexOf(58)) != -1) {
                String portPart = hostPart.substring(colonIndex + 1);
                if (portPart.length() > 0) {
                    try {
                        this.port = Integer.parseInt(portPart);
                    }
                    catch (NumberFormatException e) {
                        this.port = -1;
                    }
                }
                this.host = hostPart.substring(0, colonIndex);
            } else {
                this.host = hostPart;
            }
        } else if (colonIndex + 1 < len) {
            this.file = url.substring(colonIndex + 1);
        }
        int n = hashIndex = this.file != null ? this.file.indexOf(35) : -1;
        if (hashIndex != -1) {
            this.ref = this.file.substring(hashIndex + 1);
            this.file = this.file.substring(0, hashIndex);
        }
    }
}

