/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;

public class NameStateRenderer
extends LabelRenderer {
    private static final int THREAD_ICON_SIZE = 9;
    private static final Map<Byte, Icon> STATE_ICONS_CACHE = new HashMap<Byte, Icon>();

    public NameStateRenderer() {
        this.setOpaque(true);
        this.setMargin(3, 4, 3, 4);
    }

    @Override
    public void setValue(Object object, int n) {
        if (object == null) {
            this.setText("");
            this.setIcon(null);
        } else {
            ThreadData threadData = (ThreadData)object;
            this.setText(threadData.getName());
            this.setIcon(NameStateRenderer.getIcon(threadData.getLastState()));
        }
    }

    private static Icon getIcon(byte by) {
        Icon icon = STATE_ICONS_CACHE.get(by);
        if (icon == null) {
            icon = new ThreadStateIcon(by, 9, 9);
            STATE_ICONS_CACHE.put(by, icon);
        }
        return icon;
    }
}

