/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    Registry registry;
    String type;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();
    static Hashtable<String, String> specialMethods = new Hashtable();
    private static String[] strArray;
    private static ObjectName[] objNameArray;
    private static Class<?>[] supportedTypes;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    @Deprecated
    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.registry.addManagedBean(managed);
        }
        catch (Exception ex) {
            log.error((Object)"Error reading descriptors ", (Throwable)ex);
        }
    }

    private boolean supportedType(Class<?> ret) {
        for (int i = 0; i < supportedTypes.length; ++i) {
            if (ret != supportedTypes[i]) continue;
            return true;
        }
        return this.isBeanCompatible(ret);
    }

    protected boolean isBeanCompatible(Class<?> javaType) {
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        try {
            javaType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        Class<?> superClass = javaType.getSuperclass();
        return superClass == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || this.isBeanCompatible(superClass);
    }

    private void initMethods(Class<?> realClass, Method[] methods, Hashtable<String, Method> attMap, Hashtable<String, Method> getAttMap, Hashtable<String, Method> setAttMap, Hashtable<String, Method> invokeAttMap) {
        for (int j = 0; j < methods.length; ++j) {
            String name = methods[j].getName();
            if (Modifier.isStatic(methods[j].getModifiers())) continue;
            if (!Modifier.isPublic(methods[j].getModifiers())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Not public " + methods[j]));
                continue;
            }
            if (methods[j].getDeclaringClass() == Object.class) continue;
            Class<?>[] params = methods[j].getParameterTypes();
            if (name.startsWith("get") && params.length == 0) {
                Class<?> ret = methods[j].getReturnType();
                if (!this.supportedType(ret)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + methods[j]));
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                getAttMap.put(name, methods[j]);
                attMap.put(name, methods[j]);
                continue;
            }
            if (name.startsWith("is") && params.length == 0) {
                Class<?> ret = methods[j].getReturnType();
                if (Boolean.TYPE != ret) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + methods[j] + " " + ret));
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(2));
                getAttMap.put(name, methods[j]);
                attMap.put(name, methods[j]);
                continue;
            }
            if (name.startsWith("set") && params.length == 1) {
                if (!this.supportedType(params[0])) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unsupported type " + methods[j] + " " + params[0]));
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                setAttMap.put(name, methods[j]);
                attMap.put(name, methods[j]);
                continue;
            }
            if (params.length == 0) {
                if (specialMethods.get(methods[j].getName()) != null) continue;
                invokeAttMap.put(name, methods[j]);
                continue;
            }
            boolean supported = true;
            for (int i = 0; i < params.length; ++i) {
                if (this.supportedType(params[i])) continue;
                supported = false;
                break;
            }
            if (!supported) continue;
            invokeAttMap.put(name, methods[j]);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Class<?> realClass, String type) {
        ManagedBean mbean = new ManagedBean();
        Method[] methods = null;
        Hashtable<String, Method> attMap = new Hashtable<String, Method>();
        Hashtable<String, Method> getAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> setAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> invokeAttMap = new Hashtable<String, Method>();
        methods = realClass.getMethods();
        this.initMethods(realClass, methods, attMap, getAttMap, setAttMap, invokeAttMap);
        try {
            Enumeration<String> en = attMap.keys();
            while (en.hasMoreElements()) {
                Method sm;
                String name = en.nextElement();
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name);
                Method gm = getAttMap.get(name);
                if (gm != null) {
                    ai.setGetMethod(gm.getName());
                    Class<?> t = gm.getReturnType();
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                }
                if ((sm = setAttMap.get(name)) != null) {
                    Class<?> t = sm.getParameterTypes()[0];
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                    ai.setSetMethod(sm.getName());
                }
                ai.setDescription("Introspected attribute " + name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Introspected attribute " + name + " " + gm + " " + sm));
                }
                if (gm == null) {
                    ai.setReadable(false);
                }
                if (sm == null) {
                    ai.setWriteable(false);
                }
                if (sm == null && gm == null) continue;
                mbean.addAttribute(ai);
            }
            for (Map.Entry<String, Method> entry : invokeAttMap.entrySet()) {
                String name = entry.getKey();
                Method m = entry.getValue();
                if (m != null) {
                    OperationInfo op = new OperationInfo();
                    op.setName(name);
                    op.setReturnType(m.getReturnType().getName());
                    op.setDescription("Introspected operation " + name);
                    Class<?>[] parms = m.getParameterTypes();
                    for (int i = 0; i < parms.length; ++i) {
                        ParameterInfo pi = new ParameterInfo();
                        pi.setType(parms[i].getName());
                        pi.setName("param" + i);
                        pi.setDescription("Introspected parameter param" + i);
                        op.addParameter(pi);
                    }
                    mbean.addOperation(op);
                    continue;
                }
                log.error((Object)("Null arg method for [" + name + "]"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting name: " + type));
            }
            mbean.setName(type);
            return mbean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        strArray = new String[0];
        objNameArray = new ObjectName[0];
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, strArray.getClass(), BigDecimal.class, BigInteger.class, ObjectName.class, objNameArray.getClass(), File.class};
    }
}

