#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.13
id: tasty-rerun-1.1.13-FDsm7HucVZaCVq1sljT6sz
key: tasty-rerun-1.1.13-FDsm7HucVZaCVq1sljT6sz
license: BSD-3-Clause
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
author: Oliver Charles
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
abi: 803145c1333983456899f042400e8e53
exposed: True
exposed-modules:
    Test.Tasty.Ingredients.Rerun
import-dirs: /usr/lib/ghc-8.4.3/site-local/tasty-rerun-1.1.13
library-dirs: /usr/lib/ghc-8.4.3/site-local/tasty-rerun-1.1.13
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/tasty-rerun-1.1.13
hs-libraries: HStasty-rerun-1.1.13-FDsm7HucVZaCVq1sljT6sz
depends:
    base-4.11.1.0 containers-0.5.11.0 mtl-2.2.2
    optparse-applicative-0.14.3.0-Lw3h8UUntos8R8YmnmFjNJ
    reducers-3.12.3-2TQpEGS48SCDUuk4xwGt8z
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG stm-2.4.5.0
    tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO
    tasty-1.1.0.3-EmcP1HhMWQ9KeVLNEdZ3F0 transformers-0.5.5.0
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             optparse-applicative-0.14.3.0-Lw3h8UUntos8R8YmnmFjNJ=82119580edadf24a95003dd94479a99c
             reducers-3.12.3-2TQpEGS48SCDUuk4xwGt8z=bd4bc45199d7b16c0ae924267050dd5f
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             stm-2.4.5.0=4e743cb5a370ac3fbade528432951c3f
             tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO=92d44612a64675b8cba7ce44e507a395
             tasty-1.1.0.3-EmcP1HhMWQ9KeVLNEdZ3F0=fd9925387e2f192ef24ff80b88978f04
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

