#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-binary-instances
version: 0.2.5
id: vector-binary-instances-0.2.5-4WROCM1RYq53hip5v4A4DR
key: vector-binary-instances-0.2.5-4WROCM1RYq53hip5v4A4DR
license: BSD-3-Clause
maintainer: dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>
author: Don Stewart
stability: Experimental
homepage: https://github.com/bos/vector-binary-instances
synopsis: Instances of Data.Binary for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
    .
    Try the cereal-vector package if you are looking for Data.Serialize
    instances.
category: Data
abi: ab879ffb9dd0c0c049f94c9caaa0680d
exposed: True
exposed-modules:
    Data.Vector.Binary
import-dirs: /usr/lib/ghc-8.4.3/site-local/vector-binary-instances-0.2.5
library-dirs: /usr/lib/ghc-8.4.3/site-local/vector-binary-instances-0.2.5
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/vector-binary-instances-0.2.5
hs-libraries: HSvector-binary-instances-0.2.5-4WROCM1RYq53hip5v4A4DR
depends:
    base-4.11.1.0 vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq binary-0.8.5.1
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
haddock-interfaces: /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock
haddock-html: /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

