/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.util.MultikeyActionsHandler;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public class FilterDialog
extends ToggleDialog
implements DataSetListener,
MapFrame.MapModeChangeListener {
    private JTable userTable;
    private final FilterTableModel filterModel = new FilterTableModel();
    private final EnableFilterAction enableFilterAction;
    private final HidingFilterAction hidingFilterAction;
    private static final Shortcut ENABLE_FILTER_SHORTCUT = Shortcut.registerShortcut("core_multikey:enableFilter", I18n.tr("Multikey: {0}", I18n.tr("Enable filter", new Object[0])), 69, 5008);
    private static final Shortcut HIDING_FILTER_SHORTCUT = Shortcut.registerShortcut("core_multikey:hidingFilter", I18n.tr("Multikey: {0}", I18n.tr("Hide filter", new Object[0])), 72, 5008);
    private static final String[] COLUMN_TOOLTIPS = new String[]{PlatformManager.getPlatform().makeTooltip(I18n.tr("Enable filter", new Object[0]), ENABLE_FILTER_SHORTCUT), PlatformManager.getPlatform().makeTooltip(I18n.tr("Hiding filter", new Object[0]), HIDING_FILTER_SHORTCUT), null, I18n.tr("Inverse filter", new Object[0]), I18n.tr("Filter mode", new Object[0])};

    public FilterDialog() {
        super(I18n.tr("Filter", new Object[0]), "filter", I18n.tr("Filter objects and hide/disable them.", new Object[0]), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter", new Object[0])), 70, 5007), 162);
        this.build();
        this.enableFilterAction = new EnableFilterAction();
        this.hidingFilterAction = new HidingFilterAction();
        MultikeyActionsHandler.getInstance().addAction(this.enableFilterAction);
        MultikeyActionsHandler.getInstance().addAction(this.hidingFilterAction);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapFrame.addMapModeChangeListener(this);
        this.filterModel.executeFilters(true);
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this);
        MapFrame.removeMapModeChangeListener(this);
        this.filterModel.model.clearFilterFlags();
        MainApplication.getLayerManager().invalidateEditLayer();
    }

    protected void build() {
        this.userTable = new UserTable(this.filterModel);
        this.userTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        this.userTable.setDefaultEditor(String.class, new DefaultCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        SideButton addButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Add", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Add filter.", new Object[0]));
                new ImageProvider("dialogs", "add").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filterModel.addFilter(filter);
                }
            }
        });
        SideButton editButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Edit", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Edit filter.", new Object[0]));
                new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                Filter f = FilterDialog.this.filterModel.getFilter(index);
                Filter filter = (Filter)SearchAction.showSearchDialog(f);
                if (filter != null) {
                    FilterDialog.this.filterModel.setFilter(index, filter);
                }
            }
        });
        SideButton deleteButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Delete", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Delete filter.", new Object[0]));
                new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index >= 0) {
                    FilterDialog.this.filterModel.removeFilter(index);
                }
            }
        });
        SideButton upButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Up", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Move filter up.", new Object[0]));
                new ImageProvider("dialogs", "up").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index >= 0) {
                    FilterDialog.this.filterModel.moveUpFilter(index);
                    FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
                }
            }
        });
        SideButton downButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Down", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Move filter down.", new Object[0]));
                new ImageProvider("dialogs", "down").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index >= 0) {
                    FilterDialog.this.filterModel.moveDownFilter(index);
                    FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
                }
            }
        });
        InputMapUtils.addEnterAction(this.userTable, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectedRow();
                if (index >= 0) {
                    Filter filter = FilterDialog.this.filterModel.getFilter(index);
                    FilterDialog.this.filterModel.setValueAt(!filter.enable, index, 0);
                }
            }
        });
        InputMapUtils.addSpacebarAction(this.userTable, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = FilterDialog.this.userTable.getSelectedRow();
                if (index >= 0) {
                    Filter filter = FilterDialog.this.filterModel.getFilter(index);
                    FilterDialog.this.filterModel.setValueAt(!filter.hiding, index, 1);
                }
            }
        });
        this.createLayout(this.userTable, true, Arrays.asList(addButton, editButton, deleteButton, upButton, downButton));
    }

    @Override
    public void destroy() {
        MultikeyActionsHandler.getInstance().removeAction(this.enableFilterAction);
        MultikeyActionsHandler.getInstance().removeAction(this.hidingFilterAction);
        super.destroy();
    }

    public void updateDialogHeader() {
        SwingUtilities.invokeLater(() -> this.setTitle(I18n.tr("Filter Hidden:{0} Disabled:{1}", this.filterModel.model.getDisabledAndHiddenCount(), this.filterModel.model.getDisabledCount())));
    }

    public void drawOSDText(Graphics2D g) {
        this.filterModel.drawOSDText(g);
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        if (AbstractDatasetChangedEvent.DatasetEventType.FILTERS_CHANGED != event.getType()) {
            this.filterModel.executeFilters();
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.filterModel.executeFilters(event.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.filterModel.executeFilters(FilterModel.getAffectedPrimitives(event.getPrimitives()));
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.filterModel.executeFilters(FilterModel.getAffectedPrimitives(event.getPrimitives()));
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.filterModel.executeFilters(FilterModel.getAffectedPrimitives(event.getPrimitives()));
    }

    @Override
    public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
        this.filterModel.executeFilters();
    }

    public FilterTableModel getFilterModel() {
        return this.filterModel;
    }

    private class HidingFilterAction
    extends AbstractFilterAction {
        HidingFilterAction() {
            this.putValue("ShortDescription", I18n.tr("Hiding filter", new Object[0]));
            HIDING_FILTER_SHORTCUT.setAccelerator(this);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return HIDING_FILTER_SHORTCUT;
        }

        @Override
        public void executeMultikeyAction(int index, boolean repeatLastAction) {
            if (index >= 0 && index < FilterDialog.this.filterModel.getRowCount()) {
                Filter filter = FilterDialog.this.filterModel.getFilter(index);
                FilterDialog.this.filterModel.setValueAt(!filter.hiding, index, 1);
                this.lastFilter = filter;
            } else if (repeatLastAction && this.isLastFilterValid()) {
                FilterDialog.this.filterModel.setValueAt(!this.lastFilter.hiding, FilterDialog.this.filterModel.getFilters().indexOf(this.lastFilter), 1);
            }
        }
    }

    private class EnableFilterAction
    extends AbstractFilterAction {
        EnableFilterAction() {
            this.putValue("ShortDescription", I18n.tr("Enable filter", new Object[0]));
            ENABLE_FILTER_SHORTCUT.setAccelerator(this);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return ENABLE_FILTER_SHORTCUT;
        }

        @Override
        public void executeMultikeyAction(int index, boolean repeatLastAction) {
            if (index >= 0 && index < FilterDialog.this.filterModel.getRowCount()) {
                Filter filter = FilterDialog.this.filterModel.getFilter(index);
                FilterDialog.this.filterModel.setValueAt(!filter.enable, index, 0);
                this.lastFilter = filter;
            } else if (repeatLastAction && this.isLastFilterValid()) {
                FilterDialog.this.filterModel.setValueAt(!this.lastFilter.enable, FilterDialog.this.filterModel.getFilters().indexOf(this.lastFilter), 0);
            }
        }
    }

    abstract class AbstractFilterAction
    extends AbstractAction
    implements MultikeyShortcutAction {
        protected transient Filter lastFilter;

        AbstractFilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            ArrayList<MultikeyShortcutAction.MultikeyInfo> result = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
            for (int i = 0; i < FilterDialog.this.filterModel.getRowCount(); ++i) {
                Filter filter = FilterDialog.this.filterModel.getFilter(i);
                MultikeyShortcutAction.MultikeyInfo info = new MultikeyShortcutAction.MultikeyInfo(i, filter.text);
                result.add(info);
            }
            return result;
        }

        protected final boolean isLastFilterValid() {
            return this.lastFilter != null && FilterDialog.this.filterModel.getFilters().contains(this.lastFilter);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.isLastFilterValid()) {
                return new MultikeyShortcutAction.MultikeyInfo(-1, this.lastFilter.text);
            }
            return null;
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FilterTableModel model = (FilterTableModel)table.getModel();
            this.setSelected(value != null && (Boolean)value != false);
            this.setEnabled(model.isCellEnabled(row, column));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            if (model instanceof FilterTableModel) {
                cell.setEnabled(((FilterTableModel)model).isCellEnabled(row, column));
            }
            return cell;
        }
    }

    static final class UserTable
    extends JTable {
        UserTable(TableModel dm) {
            super(dm);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new UserTableHeader(this.columnModel);
        }

        static final class UserTableHeader
        extends JTableHeader {
            UserTableHeader(TableColumnModel cm) {
                super(cm);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return COLUMN_TOOLTIPS[realIndex];
            }
        }
    }
}

