/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

final class RelocatedArtifact
extends AbstractArtifact {
    private final Artifact artifact;
    private final String groupId;
    private final String artifactId;
    private final String version;

    RelocatedArtifact(Artifact artifact, String groupId, String artifactId, String version) {
        this.artifact = (Artifact)Validate.notNull((Object)artifact, (String)"artifact cannot be null", (Object[])new Object[0]);
        this.groupId = groupId != null && groupId.length() > 0 ? groupId : null;
        this.artifactId = artifactId != null && artifactId.length() > 0 ? artifactId : null;
        this.version = version != null && version.length() > 0 ? version : null;
    }

    public String getGroupId() {
        if (this.groupId != null) {
            return this.groupId;
        }
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        if (this.artifactId != null) {
            return this.artifactId;
        }
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return this.artifact.getVersion();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public File getFile() {
        return this.artifact.getFile();
    }

    public String getProperty(String key, String defaultValue) {
        return this.artifact.getProperty(key, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }
}

