"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const debug_1 = require("debug");
const debug = debug_1.default('axm:profiling');
const module_1 = require("../utils/module");
const configuration_1 = require("../configuration");
class ProfilingCPUFallback {
    constructor() {
        this.nsCpuProfiling = 'km-cpu-profiling';
        this.MODULE_NAME = 'v8-profiler-node8';
        this.FALLBACK_MODULE_NAME = 'v8-profiler';
    }
    init() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            let path;
            let moduleName = this.MODULE_NAME;
            try {
                path = yield module_1.default.getModulePath(this.MODULE_NAME);
            }
            catch (e) {
                try {
                    moduleName = this.FALLBACK_MODULE_NAME;
                    path = yield module_1.default.getModulePath(this.FALLBACK_MODULE_NAME);
                }
                catch (err) {
                    configuration_1.default.configureModule({
                        heapdump: false
                    });
                    throw new Error('Profiler not loaded !');
                }
            }
            this.profiler = module_1.default.loadModule(path, moduleName);
            const enable = !(this.profiler instanceof Error);
            configuration_1.default.configureModule({
                heapdump: enable
            });
        });
    }
    destroy() {
        debug('Profiler destroyed !');
    }
    start() {
        this.profiler.startProfiling(this.nsCpuProfiling);
    }
    stop() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return this.getProfileInfo();
        });
    }
    getProfileInfo() {
        const cpu = this.profiler.stopProfiling(this.nsCpuProfiling);
        return JSON.stringify(cpu);
    }
}
exports.default = ProfilingCPUFallback;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvZmlsaW5nQ1BVRmFsbGJhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvcHJvZmlsaW5nL3Byb2ZpbGluZ0NQVUZhbGxiYWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGlDQUF5QjtBQUN6QixNQUFNLEtBQUssR0FBRyxlQUFLLENBQUMsZUFBZSxDQUFDLENBQUE7QUFFcEMsNENBQW1DO0FBQ25DLG9EQUE0QztBQUU1QztJQUFBO1FBRVUsbUJBQWMsR0FBVyxrQkFBa0IsQ0FBQTtRQUUzQyxnQkFBVyxHQUFHLG1CQUFtQixDQUFBO1FBQ2pDLHlCQUFvQixHQUFHLGFBQWEsQ0FBQTtJQThDOUMsQ0FBQztJQTVDTyxJQUFJOztZQUNSLElBQUksSUFBSSxDQUFBO1lBQ1IsSUFBSSxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQTtZQUVqQyxJQUFJO2dCQUNGLElBQUksR0FBRyxNQUFNLGdCQUFLLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQTthQUNuRDtZQUFDLE9BQU8sQ0FBQyxFQUFFO2dCQUNWLElBQUk7b0JBQ0YsVUFBVSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQTtvQkFDdEMsSUFBSSxHQUFHLE1BQU0sZ0JBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLENBQUE7aUJBQzVEO2dCQUFDLE9BQU8sR0FBRyxFQUFFO29CQUNaLHVCQUFhLENBQUMsZUFBZSxDQUFDO3dCQUM1QixRQUFRLEVBQUcsS0FBSztxQkFDakIsQ0FBQyxDQUFBO29CQUNGLE1BQU0sSUFBSSxLQUFLLENBQUMsdUJBQXVCLENBQUMsQ0FBQTtpQkFDekM7YUFDRjtZQUVELElBQUksQ0FBQyxRQUFRLEdBQUcsZ0JBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFBO1lBRWxELE1BQU0sTUFBTSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxZQUFZLEtBQUssQ0FBQyxDQUFBO1lBRWhELHVCQUFhLENBQUMsZUFBZSxDQUFDO2dCQUM1QixRQUFRLEVBQUcsTUFBTTthQUNsQixDQUFDLENBQUE7UUFDSixDQUFDO0tBQUE7SUFFRCxPQUFPO1FBQ0wsS0FBSyxDQUFDLHNCQUFzQixDQUFDLENBQUE7SUFDL0IsQ0FBQztJQUVELEtBQUs7UUFDSCxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUE7SUFDbkQsQ0FBQztJQUVLLElBQUk7O1lBQ1IsT0FBTyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUE7UUFDOUIsQ0FBQztLQUFBO0lBRU8sY0FBYztRQUNwQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUE7UUFFNUQsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFBO0lBQzVCLENBQUM7Q0FDRjtBQW5ERCx1Q0FtREMifQ==