from typing import (Generic, Iterable, Iterator, List, MutableSequence,
                    Optional, TypeVar, Union)

_T = TypeVar('_T')
_Arg = Union[List[_T], Iterable[_T]]


class FrozenList(MutableSequence[_T], Generic[_T]):

    def __init__(self, items: Optional[_Arg]=None) -> None: ...

    @property
    def frozen(self) -> bool: ...

    def freeze(self) -> None: ...

    def __getitem__(self, index): ...

    def __setitem__(self, index, value): ...

    def __delitem__(self, index): ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[_T]: ...

    def __reversed__(self) -> Iterator[_T]: ...

    def __eq__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...

    def insert(self, pos: int, item: _T) -> None: ...

    def __repr__(self) -> str: ...


# types for C accelerators are the same
CFrozenList = PyFrozenList = FrozenList
