/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.UnaryExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Not
extends UnaryExpression {
    public Not(Location location, Expression child) {
        super(location, child);
    }

    @Override
    protected NodeInfo<Not> info() {
        return NodeInfo.create(this, Not::new, this.child());
    }

    @Override
    protected Not replaceChild(Expression newChild) {
        return new Not(this.location(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (DataType.BOOLEAN == this.child().dataType()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution("Cannot negate expression ([" + Expressions.name(this.child()) + "] of type [" + this.child().dataType().esType + "])", new Object[0]);
    }

    @Override
    public Object fold() {
        return Objects.equals(this.child().fold(), Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected Expression canonicalize() {
        Expression canonicalChild = this.child().canonical();
        if (canonicalChild instanceof BinaryOperator.Negateable) {
            return ((BinaryOperator.Negateable)((Object)canonicalChild)).negate();
        }
        return this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }
}

