/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authz.AuthorizedIndices;
import org.elasticsearch.xpack.security.authz.IndicesAndAliasesResolver;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class AuthorizationService
extends AbstractComponent {
    public static final Setting<Boolean> ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"authc.anonymous.authz_exception"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String ORIGINATING_ACTION_KEY = "_originating_action_name";
    public static final String ROLE_NAMES_KEY = "_effective_role_names";
    private static final Predicate<String> MONITOR_INDEX_PREDICATE = IndexPrivilege.MONITOR.predicate();
    private static final Predicate<String> SAME_USER_PRIVILEGE = Automatons.predicate((String[])new String[]{"cluster:admin/xpack/security/user/change_password", "cluster:admin/xpack/security/user/authenticate", "cluster:admin/xpack/security/user/has_privileges"});
    private static final String INDEX_SUB_REQUEST_PRIMARY = "indices:data/write/index[p]";
    private static final String INDEX_SUB_REQUEST_REPLICA = "indices:data/write/index[r]";
    private static final String DELETE_SUB_REQUEST_PRIMARY = "indices:data/write/delete[p]";
    private static final String DELETE_SUB_REQUEST_REPLICA = "indices:data/write/delete[r]";
    private final ClusterService clusterService;
    private final CompositeRolesStore rolesStore;
    private final AuditTrailService auditTrail;
    private final IndicesAndAliasesResolver indicesAndAliasesResolver;
    private final AuthenticationFailureHandler authcFailureHandler;
    private final ThreadContext threadContext;
    private final AnonymousUser anonymousUser;
    private final FieldPermissionsCache fieldPermissionsCache;
    private final boolean isAnonymousEnabled;
    private final boolean anonymousAuthzExceptionEnabled;

    public AuthorizationService(Settings settings, CompositeRolesStore rolesStore, ClusterService clusterService, AuditTrailService auditTrail, AuthenticationFailureHandler authcFailureHandler, ThreadPool threadPool, AnonymousUser anonymousUser) {
        super(settings);
        this.rolesStore = rolesStore;
        this.clusterService = clusterService;
        this.auditTrail = auditTrail;
        this.indicesAndAliasesResolver = new IndicesAndAliasesResolver(settings, clusterService);
        this.authcFailureHandler = authcFailureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.isAnonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.anonymousAuthzExceptionEnabled = (Boolean)ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING.get(settings);
        this.fieldPermissionsCache = new FieldPermissionsCache(settings);
    }

    public void authorize(Authentication authentication, String action, TransportRequest request, Role userRole, Role runAsRole) throws ElasticsearchSecurityException {
        boolean allowsRemoteIndices;
        TransportRequest originalRequest = request;
        if (request instanceof TransportReplicationAction.ConcreteShardRequest) {
            request = ((TransportReplicationAction.ConcreteShardRequest)request).getRequest();
            assert (!TransportActionProxy.isProxyRequest((TransportRequest)request)) : "expected non-proxy request for action: " + action;
        } else {
            request = TransportActionProxy.unwrapRequest((TransportRequest)request);
            if (TransportActionProxy.isProxyRequest((TransportRequest)originalRequest) && !TransportActionProxy.isProxyAction((String)action)) {
                throw new IllegalStateException("originalRequest is a proxy request for: [" + request + "] but action: [" + action + "] isn't");
            }
        }
        this.putTransientIfNonExisting(ORIGINATING_ACTION_KEY, action);
        if (SystemUser.is((User)authentication.getUser())) {
            if (SystemUser.isAuthorized((String)action)) {
                this.putTransientIfNonExisting("_indices_permissions", IndicesAccessControl.ALLOW_ALL);
                this.putTransientIfNonExisting(ROLE_NAMES_KEY, new String[]{"_system"});
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, new String[]{"_system"});
                return;
            }
            throw this.denial(authentication, action, request, new String[]{"_system"});
        }
        Role permission = userRole;
        boolean isRunAs = authentication.getUser().isRunAs();
        if (isRunAs) {
            if (authentication.getLookedUpBy() == null) {
                throw this.denyRunAs(authentication, action, request, permission.names());
            }
            if (permission.runAs().check(authentication.getUser().principal())) {
                this.auditTrail.runAsGranted(authentication, action, (TransportMessage)request, permission.names());
                permission = runAsRole;
            } else {
                throw this.denyRunAs(authentication, action, request, permission.names());
            }
        }
        this.putTransientIfNonExisting(ROLE_NAMES_KEY, permission.names());
        if (ClusterPrivilege.ACTION_MATCHER.test(action)) {
            ClusterPermission cluster = permission.cluster();
            if (cluster.check(action, request) || AuthorizationService.checkSameUserPermissions(action, request, authentication)) {
                this.putTransientIfNonExisting("_indices_permissions", IndicesAccessControl.ALLOW_ALL);
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
                return;
            }
            throw this.denial(authentication, action, request, permission.names());
        }
        if (!IndexPrivilege.ACTION_MATCHER.test(action)) {
            throw this.denial(authentication, action, request, permission.names());
        }
        if (AuthorizationService.isCompositeAction(action)) {
            if (!(request instanceof CompositeIndicesRequest)) {
                throw new IllegalStateException("Composite actions must implement " + CompositeIndicesRequest.class.getSimpleName() + ", " + request.getClass().getSimpleName() + " doesn't");
            }
            if (permission.indices().check(action)) {
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
                return;
            }
            throw this.denial(authentication, action, request, permission.names());
        }
        if (AuthorizationService.isTranslatedToBulkAction(action)) {
            if (!(request instanceof CompositeIndicesRequest)) {
                throw new IllegalStateException("Bulk translated actions must implement " + CompositeIndicesRequest.class.getSimpleName() + ", " + request.getClass().getSimpleName() + " doesn't");
            }
            if (permission.indices().check(action)) {
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
                return;
            }
            throw this.denial(authentication, action, request, permission.names());
        }
        if (TransportActionProxy.isProxyAction((String)action)) {
            if (!TransportActionProxy.isProxyRequest((TransportRequest)originalRequest)) {
                throw new IllegalStateException("originalRequest is not a proxy request: [" + originalRequest + "] but action: [" + action + "] is a proxy action");
            }
            if (permission.indices().check(action)) {
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
                return;
            }
            throw this.denial(authentication, action, request, permission.names());
        }
        if (!(request instanceof IndicesRequest) && !(request instanceof IndicesAliasesRequest)) {
            if (AuthorizationService.isScrollRelatedAction(action)) {
                if ("indices:data/read/scroll".equals(action) && !permission.indices().check(action)) {
                    throw this.denial(authentication, action, request, permission.names());
                }
                this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
                return;
            }
            assert (false) : "only scroll related requests are known indices api that don't support retrieving the indices they relate to";
            throw this.denial(authentication, action, request, permission.names());
        }
        boolean bl = allowsRemoteIndices = request instanceof IndicesRequest && IndicesAndAliasesResolver.allowsRemoteIndices((IndicesRequest)request);
        if (!allowsRemoteIndices && !permission.indices().check(action)) {
            throw this.denial(authentication, action, request, permission.names());
        }
        MetaData metaData = this.clusterService.state().metaData();
        AuthorizedIndices authorizedIndices = new AuthorizedIndices(authentication.getUser(), permission, action, metaData);
        IndicesAndAliasesResolver.ResolvedIndices resolvedIndices = this.resolveIndexNames(authentication, action, request, metaData, authorizedIndices, permission);
        assert (!resolvedIndices.isEmpty()) : "every indices request needs to have its indices set thus the resolved indices must not be empty";
        if (resolvedIndices.getRemote().isEmpty() && !permission.indices().check(action)) {
            throw this.denial(authentication, action, request, permission.names());
        }
        if (resolvedIndices.isNoIndicesPlaceholder()) {
            this.putTransientIfNonExisting("_indices_permissions", IndicesAccessControl.ALLOW_NO_INDICES);
            this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
            return;
        }
        HashSet<String> localIndices = new HashSet<String>(resolvedIndices.getLocal());
        IndicesAccessControl indicesAccessControl = permission.authorize(action, localIndices, metaData, this.fieldPermissionsCache);
        if (!indicesAccessControl.isGranted()) {
            throw this.denial(authentication, action, request, permission.names());
        }
        if (this.hasSecurityIndexAccess(indicesAccessControl) && !MONITOR_INDEX_PREDICATE.test(action) && !AuthorizationService.isSuperuser(authentication.getUser())) {
            this.logger.debug("user [{}] attempted to directly perform [{}] against the security index [{}]", (Object)authentication.getUser().principal(), (Object)action, (Object)".security");
            throw this.denial(authentication, action, request, permission.names());
        }
        this.putTransientIfNonExisting("_indices_permissions", indicesAccessControl);
        if (IndexPrivilege.CREATE_INDEX_MATCHER.test(action)) {
            assert (request instanceof CreateIndexRequest);
            Set aliases = ((CreateIndexRequest)request).aliases();
            if (!aliases.isEmpty()) {
                HashSet aliasesAndIndices = Sets.newHashSet(localIndices);
                for (Alias alias : aliases) {
                    aliasesAndIndices.add(alias.name());
                }
                indicesAccessControl = permission.authorize("indices:admin/aliases", (Set)aliasesAndIndices, metaData, this.fieldPermissionsCache);
                if (!indicesAccessControl.isGranted()) {
                    throw this.denial(authentication, "indices:admin/aliases", request, permission.names());
                }
            }
        }
        if (action.equals("indices:data/write/bulk[s]")) {
            assert (request instanceof BulkShardRequest) : "Action " + action + " requires " + BulkShardRequest.class + " but was " + request.getClass();
            this.authorizeBulkItems(authentication, (BulkShardRequest)request, permission, metaData, localIndices, authorizedIndices);
        }
        this.auditTrail.accessGranted(authentication, action, (TransportMessage)request, permission.names());
    }

    private boolean hasSecurityIndexAccess(IndicesAccessControl indicesAccessControl) {
        for (String index : SecurityIndexManager.indexNames()) {
            IndicesAccessControl.IndexAccessControl indexPermissions = indicesAccessControl.getIndexPermissions(index);
            if (indexPermissions == null || !indexPermissions.isGranted()) continue;
            return true;
        }
        return false;
    }

    private void authorizeBulkItems(Authentication authentication, BulkShardRequest request, Role permission, MetaData metaData, Set<String> indices, AuthorizedIndices authorizedIndices) {
        HashMap<String, String> resolvedIndexNames = new HashMap<String, String>();
        HashMap<Tuple, Boolean> indexActionAuthority = new HashMap<Tuple, Boolean>();
        for (BulkItemRequest item : request.items()) {
            String itemAction;
            String resolvedIndex = resolvedIndexNames.computeIfAbsent(item.index(), key -> {
                IndicesAndAliasesResolver.ResolvedIndices resolvedIndices = this.indicesAndAliasesResolver.resolveIndicesAndAliases((IndicesRequest)item.request(), metaData, authorizedIndices);
                if (resolvedIndices.getRemote().size() != 0) {
                    throw this.illegalArgument("Bulk item should not write to remote indices, but request writes to " + String.join((CharSequence)",", resolvedIndices.getRemote()));
                }
                if (resolvedIndices.getLocal().size() != 1) {
                    throw this.illegalArgument("Bulk item should write to exactly 1 index, but request writes to " + String.join((CharSequence)",", resolvedIndices.getLocal()));
                }
                String resolved = resolvedIndices.getLocal().get(0);
                if (!indices.contains(resolved)) {
                    throw this.illegalArgument("Found bulk item that writes to index " + resolved + " but the request writes to " + indices);
                }
                return resolved;
            });
            Tuple indexAndAction = new Tuple((Object)resolvedIndex, (Object)(itemAction = AuthorizationService.getAction(item)));
            boolean granted = indexActionAuthority.computeIfAbsent(indexAndAction, key -> {
                IndicesAccessControl itemAccessControl = permission.authorize(itemAction, Collections.singleton(resolvedIndex), metaData, this.fieldPermissionsCache);
                return itemAccessControl.isGranted();
            });
            if (granted) continue;
            item.abort(resolvedIndex, (Exception)((Object)this.denial(authentication, itemAction, (TransportRequest)request, permission.names())));
        }
    }

    private IllegalArgumentException illegalArgument(String message) {
        assert (false) : message;
        return new IllegalArgumentException(message);
    }

    private static String getAction(BulkItemRequest item) {
        DocWriteRequest docWriteRequest = item.request();
        switch (docWriteRequest.opType()) {
            case INDEX: 
            case CREATE: {
                return "indices:data/write/index";
            }
            case UPDATE: {
                return "indices:data/write/update";
            }
            case DELETE: {
                return "indices:data/write/delete";
            }
        }
        throw new IllegalArgumentException("No equivalent action for opType [" + docWriteRequest.opType() + "]");
    }

    private IndicesAndAliasesResolver.ResolvedIndices resolveIndexNames(Authentication authentication, String action, TransportRequest request, MetaData metaData, AuthorizedIndices authorizedIndices, Role permission) {
        try {
            return this.indicesAndAliasesResolver.resolve(request, metaData, authorizedIndices);
        }
        catch (Exception e) {
            this.auditTrail.accessDenied(authentication, action, (TransportMessage)request, permission.names());
            throw e;
        }
    }

    private void putTransientIfNonExisting(String key, Object value) {
        Object existing = this.threadContext.getTransient(key);
        if (existing == null) {
            this.threadContext.putTransient(key, value);
        }
    }

    public void roles(User user, ActionListener<Role> roleActionListener) {
        if (SystemUser.is((User)user)) {
            throw new IllegalArgumentException("the user [" + user.principal() + "] is the system user and we should never try to get its roles");
        }
        if (XPackUser.is((User)user)) {
            assert (XPackUser.INSTANCE.roles().length == 1);
            roleActionListener.onResponse((Object)XPackUser.ROLE);
            return;
        }
        if (XPackSecurityUser.is((User)user)) {
            roleActionListener.onResponse((Object)ReservedRolesStore.SUPERUSER_ROLE);
            return;
        }
        HashSet<String> roleNames = new HashSet<String>();
        Collections.addAll(roleNames, user.roles());
        if (this.isAnonymousEnabled && !this.anonymousUser.equals((Object)user)) {
            if (this.anonymousUser.roles().length == 0) {
                throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
            }
            Collections.addAll(roleNames, this.anonymousUser.roles());
        }
        if (roleNames.isEmpty()) {
            roleActionListener.onResponse((Object)Role.EMPTY);
        } else if (roleNames.contains(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName())) {
            roleActionListener.onResponse((Object)ReservedRolesStore.SUPERUSER_ROLE);
        } else {
            this.rolesStore.roles(roleNames, this.fieldPermissionsCache, roleActionListener);
        }
    }

    private static boolean isCompositeAction(String action) {
        return action.equals("indices:data/write/bulk") || action.equals("indices:data/read/mget") || action.equals("indices:data/read/mtv") || action.equals("indices:data/read/msearch") || action.equals("indices:data/read/mpercolate") || action.equals("indices:data/read/msearch/template") || action.equals("indices:data/read/search/template") || action.equals("indices:data/write/reindex") || action.equals("indices:data/read/sql") || action.equals("indices:data/read/sql/translate");
    }

    private static boolean isTranslatedToBulkAction(String action) {
        return action.equals("indices:data/write/index") || action.equals("indices:data/write/delete") || action.equals(INDEX_SUB_REQUEST_PRIMARY) || action.equals(INDEX_SUB_REQUEST_REPLICA) || action.equals(DELETE_SUB_REQUEST_PRIMARY) || action.equals(DELETE_SUB_REQUEST_REPLICA);
    }

    private static boolean isScrollRelatedAction(String action) {
        return action.equals("indices:data/read/scroll") || action.equals("indices:data/read/search[phase/fetch/id/scroll]") || action.equals("indices:data/read/search[phase/query+fetch/scroll]") || action.equals("indices:data/read/search[phase/query/scroll]") || action.equals("indices:data/read/search[free_context/scroll]") || action.equals("indices:data/read/scroll/clear") || action.equals("indices:data/read/sql/close_cursor") || action.equals("indices:data/read/search[clear_scroll_contexts]");
    }

    static boolean checkSameUserPermissions(String action, TransportRequest request, Authentication authentication) {
        boolean actionAllowed = SAME_USER_PRIVILEGE.test(action);
        if (actionAllowed) {
            if (!(request instanceof UserRequest)) {
                assert (false) : "right now only a user request should be allowed";
                return false;
            }
            UserRequest userRequest = (UserRequest)request;
            String[] usernames = userRequest.usernames();
            if (usernames == null || usernames.length != 1 || usernames[0] == null) {
                assert (false) : "this role should only be used for actions to apply to a single user";
                return false;
            }
            String username = usernames[0];
            boolean sameUsername = authentication.getUser().principal().equals(username);
            if (sameUsername && "cluster:admin/xpack/security/user/change_password".equals(action)) {
                return AuthorizationService.checkChangePasswordAction(authentication);
            }
            assert ("cluster:admin/xpack/security/user/authenticate".equals(action) || "cluster:admin/xpack/security/user/has_privileges".equals(action) || !sameUsername) : "Action '" + action + "' should not be possible when sameUsername=" + sameUsername;
            return sameUsername;
        }
        return false;
    }

    private static boolean checkChangePasswordAction(Authentication authentication) {
        boolean isRunAs = authentication.getUser().isRunAs();
        String realmType = isRunAs ? authentication.getLookedUpBy().getType() : authentication.getAuthenticatedBy().getType();
        assert (realmType != null);
        return "reserved".equals(realmType) || "native".equals(realmType);
    }

    ElasticsearchSecurityException denial(Authentication authentication, String action, TransportRequest request, String[] roleNames) {
        this.auditTrail.accessDenied(authentication, action, (TransportMessage)request, roleNames);
        return this.denialException(authentication, action);
    }

    private ElasticsearchSecurityException denyRunAs(Authentication authentication, String action, TransportRequest request, String[] roleNames) {
        this.auditTrail.runAsDenied(authentication, action, (TransportMessage)request, roleNames);
        return this.denialException(authentication, action);
    }

    private ElasticsearchSecurityException denialException(Authentication authentication, String action) {
        User authUser = authentication.getUser().authenticatedUser();
        if (this.isAnonymousEnabled && this.anonymousUser.equals((Object)authUser) && !this.anonymousAuthzExceptionEnabled) {
            throw this.authcFailureHandler.authenticationRequired(action, this.threadContext);
        }
        if (authentication.getUser().isRunAs()) {
            return Exceptions.authorizationError((String)"action [{}] is unauthorized for user [{}] run as [{}]", (Object[])new Object[]{action, authUser.principal(), authentication.getUser().principal()});
        }
        return Exceptions.authorizationError((String)"action [{}] is unauthorized for user [{}]", (Object[])new Object[]{action, authUser.principal()});
    }

    static boolean isSuperuser(User user) {
        return Arrays.stream(user.roles()).anyMatch(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName()::equals);
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING);
    }
}

