/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.mapper.RangeFieldMapper;

final class BinaryRangeUtil
extends Enum<BinaryRangeUtil> {
    private static final /* synthetic */ BinaryRangeUtil[] $VALUES;

    public static BinaryRangeUtil[] values() {
        return (BinaryRangeUtil[])$VALUES.clone();
    }

    public static BinaryRangeUtil valueOf(String name) {
        return Enum.valueOf(BinaryRangeUtil.class, name);
    }

    static BytesRef encodeLongRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingLong(range -> ((Number)range.from).longValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingLong(range -> ((Number)range.to).longValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        byte[] encoded = new byte[5 + 18 * sortedRanges.size()];
        ByteArrayDataOutput out = new ByteArrayDataOutput(encoded);
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeLong(((Number)range2.from).longValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeLong(((Number)range2.to).longValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return new BytesRef(encoded, 0, out.getPosition());
    }

    static BytesRef encodeDoubleRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingDouble(range -> ((Number)range.from).doubleValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingDouble(range -> ((Number)range.to).doubleValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        byte[] encoded = new byte[5 + 16 * sortedRanges.size()];
        ByteArrayDataOutput out = new ByteArrayDataOutput(encoded);
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeDouble(((Number)range2.from).doubleValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeDouble(((Number)range2.to).doubleValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return new BytesRef(encoded, 0, out.getPosition());
    }

    static BytesRef encodeFloatRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingDouble(range -> ((Number)range.from).floatValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingDouble(range -> ((Number)range.to).floatValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        byte[] encoded = new byte[5 + 8 * sortedRanges.size()];
        ByteArrayDataOutput out = new ByteArrayDataOutput(encoded);
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeFloat(((Number)range2.from).floatValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeFloat(((Number)range2.to).floatValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return new BytesRef(encoded, 0, out.getPosition());
    }

    static byte[] encodeDouble(double number) {
        byte[] encoded = new byte[8];
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(number), encoded, 0);
        return encoded;
    }

    static byte[] encodeFloat(float number) {
        byte[] encoded = new byte[4];
        NumericUtils.intToSortableBytes(NumericUtils.floatToSortableInt(number), encoded, 0);
        return encoded;
    }

    static byte[] encodeLong(long number) {
        int sign = 1;
        if (number < 0L) {
            number = -1L - number;
            sign = 0;
        }
        return BinaryRangeUtil.encode(number, sign);
    }

    private static byte[] encode(long l, int sign) {
        int numBits;
        assert (l >= 0L);
        int numAdditionalBytes = (numBits + 7 - 3) / 8;
        byte[] encoded = new byte[1 + numAdditionalBytes];
        int i = encoded.length;
        for (numBits = 64 - Long.numberOfLeadingZeros(l); numBits > 0; numBits -= 8) {
            int index = --i;
            assert (index > 0 || numBits <= 3);
            encoded[index] = (byte)l;
            l >>>= 8;
        }
        assert (Byte.toUnsignedInt(encoded[0]) <= 7);
        assert (encoded.length == 1 || encoded[0] != 0 || Byte.toUnsignedInt(encoded[1]) > 7);
        if (sign == 0) {
            for (int j = 0; j < encoded.length; ++j) {
                encoded[j] = (byte)(~Byte.toUnsignedInt(encoded[j]));
            }
            encoded[0] = (byte)(encoded[0] & 7);
        }
        encoded[0] = (byte)(encoded[0] | sign << 7);
        encoded[0] = sign > 0 ? (byte)(encoded[0] | numAdditionalBytes << 3) : (byte)(encoded[0] | 15 - numAdditionalBytes << 3);
        return encoded;
    }

    static {
        $VALUES = new BinaryRangeUtil[0];
    }
}

