"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class DeepMetricsTracer {
    constructor(metricFeature, tracer, eventName) {
        this.allMetrics = {
            http: {
                histogram: {
                    name: 'HTTP: Response time',
                    type: 'internal/http/inbound/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'HTTP: Throughput',
                    samples: 60,
                    type: 'internal/http/inbound/throughput',
                    unit: 'req/min'
                }
            },
            https: {
                histogram: {
                    name: 'HTTPS: Response time',
                    type: 'internal/https/inbound/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'HTTPS: Throughput',
                    samples: 60,
                    type: 'internal/https/inbound/throughput',
                    unit: 'req/min'
                }
            },
            'http-outbound': {
                histogram: {
                    name: 'HTTP out: Response time',
                    type: 'internal/http/outbound/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'HTTP out: Throughput',
                    samples: 60,
                    type: 'internal/http/outbound/throughput',
                    unit: 'req/min'
                }
            },
            'https-outbound': {
                histogram: {
                    name: 'HTTPS out: Response time',
                    type: 'internal/https/outbound/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'HTTPS out: Throughput',
                    samples: 60,
                    type: 'internal/https/outbound/throughput',
                    unit: 'req/min'
                }
            },
            mysql: {
                histogram: {
                    name: 'MYSQL: Response time',
                    type: 'internal/mysql/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'MYSQL: Throughput',
                    samples: 60,
                    type: 'internal/mysql/throughput',
                    unit: 'req/min'
                }
            },
            mongo: {
                histogram: {
                    name: 'Mongo: Response time',
                    type: 'internal/mongodb/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'Mongo: Throughput',
                    samples: 60,
                    type: 'internal/mongodb/throughput',
                    unit: 'req/min'
                }
            },
            mqtt: {
                histogram: {
                    name: 'MQTT: Response time',
                    type: 'internal/mqtt/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'MQTT: Throughput',
                    samples: 60,
                    type: 'internal/mqtt/throughput',
                    unit: 'req/min'
                }
            },
            socketio: {
                histogram: {
                    name: 'WS: Response time',
                    type: 'internal/socketio/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'WS: Throughput',
                    samples: 60,
                    type: 'internal/socketio/throughput',
                    unit: 'req/min'
                }
            },
            redis: {
                histogram: {
                    name: 'Redis: Response time',
                    type: 'internal/redis/latency',
                    measurement: 'mean',
                    unit: 'ms'
                },
                meter: {
                    name: 'Redis: Throughput',
                    samples: 60,
                    type: 'internal/redis/throughput',
                    unit: 'req/min'
                }
            }
        };
        this.metricFeature = metricFeature;
        this.tracer = tracer;
        this.eventName = eventName;
        this.listenerFunc = this.listener.bind(this);
    }
    init() {
        this.tracer.on(this.eventName, this.listenerFunc);
    }
    destroy() {
        this.tracer.removeListener(this.eventName, this.listenerFunc);
    }
    listener(data) {
        if (!this.latency) {
            this.latency = this.metricFeature.histogram(this.allMetrics[this.eventName].histogram);
        }
        if (!this.throughput) {
            this.throughput = this.metricFeature.meter(this.allMetrics[this.eventName].meter);
        }
        data = JSON.parse(data);
        this.throughput.mark();
        if (data.duration) {
            this.latency.update(data.duration);
        }
    }
}
exports.default = DeepMetricsTracer;
//# sourceMappingURL=data:application/json;base64,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