/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.TexturesCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexturesCatalog {
    private List<TexturesCategory> categories = new ArrayList<TexturesCategory>();
    private final CollectionChangeSupport<CatalogTexture> texturesChangeSupport = new CollectionChangeSupport(this);

    public List<TexturesCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public int getCategoriesCount() {
        return this.categories.size();
    }

    public TexturesCategory getCategory(int n) {
        return this.categories.get(n);
    }

    public void addTexturesListener(CollectionListener<CatalogTexture> collectionListener) {
        this.texturesChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeTexturesListener(CollectionListener<CatalogTexture> collectionListener) {
        this.texturesChangeSupport.removeCollectionListener(collectionListener);
    }

    public void add(TexturesCategory texturesCategory, CatalogTexture catalogTexture) {
        int n = Collections.binarySearch(this.categories, texturesCategory);
        if (n < 0) {
            texturesCategory = new TexturesCategory(texturesCategory.getName());
            this.categories.add(-n - 1, texturesCategory);
        } else {
            texturesCategory = this.categories.get(n);
        }
        texturesCategory.add(catalogTexture);
        this.texturesChangeSupport.fireCollectionChanged(catalogTexture, texturesCategory.getIndexOfTexture(catalogTexture), CollectionEvent.Type.ADD);
    }

    public void delete(CatalogTexture catalogTexture) {
        int n;
        TexturesCategory texturesCategory = catalogTexture.getCategory();
        if (texturesCategory != null && (n = texturesCategory.getIndexOfTexture(catalogTexture)) >= 0) {
            texturesCategory.delete(catalogTexture);
            if (texturesCategory.getTexturesCount() == 0) {
                this.categories = new ArrayList<TexturesCategory>(this.categories);
                this.categories.remove(texturesCategory);
            }
            this.texturesChangeSupport.fireCollectionChanged(catalogTexture, n, CollectionEvent.Type.DELETE);
            return;
        }
        throw new IllegalArgumentException("catalog doesn't contain texture " + catalogTexture.getName());
    }
}

