/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class EFunctionRef
extends AExpression
implements ILambda {
    private final String type;
    private final String call;
    private FunctionRef ref;
    private String defPointer;

    public EFunctionRef(Location location, String type, String call) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (this.expected == null) {
            this.ref = null;
            this.actual = String.class;
            this.defPointer = "S" + this.type + "." + this.call + ",0";
        } else {
            this.defPointer = null;
            try {
                if ("this".equals(this.type)) {
                    PainlessMethod interfaceMethod = locals.getPainlessLookup().getPainlessStructFromJavaClass(this.expected).functionalMethod;
                    if (interfaceMethod == null) {
                        throw new IllegalArgumentException("Cannot convert function reference [" + this.type + "::" + this.call + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expected) + "], not a functional interface");
                    }
                    PainlessMethod delegateMethod = locals.getMethod(PainlessLookupUtility.buildPainlessMethodKey(this.call, interfaceMethod.arguments.size()));
                    if (delegateMethod == null) {
                        throw new IllegalArgumentException("Cannot convert function reference [" + this.type + "::" + this.call + "] to [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expected) + "], function not found");
                    }
                    this.ref = new FunctionRef(this.expected, interfaceMethod, delegateMethod, 0);
                    for (int i = 0; i < interfaceMethod.arguments.size(); ++i) {
                        Class<?> from = interfaceMethod.arguments.get(i);
                        Class<?> to = delegateMethod.arguments.get(i);
                        AnalyzerCaster.getLegalCast(this.location, from, to, false, true);
                    }
                    if (interfaceMethod.rtn != Void.TYPE) {
                        AnalyzerCaster.getLegalCast(this.location, delegateMethod.rtn, interfaceMethod.rtn, false, true);
                    }
                } else {
                    this.ref = new FunctionRef(locals.getPainlessLookup(), this.expected, this.type, this.call, 0);
                }
            }
            catch (IllegalArgumentException e) {
                throw this.createError(e);
            }
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            writer.invokeDynamic(this.ref.interfaceMethodName, this.ref.factoryDescriptor, WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, new Object[]{this.ref.interfaceType, this.ref.delegateClassName, this.ref.delegateInvokeType, this.ref.delegateMethodName, this.ref.delegateType, this.ref.isDelegateInterface ? 1 : 0});
        } else {
            writer.push(null);
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[0];
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type, this.call);
    }
}

