/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Arithmetics;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryNumericProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;

public class BinaryArithmeticProcessor
extends BinaryNumericProcessor<BinaryArithmeticOperation> {
    public static final String NAME = "ab";

    public BinaryArithmeticProcessor(Processor left, Processor right, BinaryArithmeticOperation operation) {
        super(left, right, operation);
    }

    public BinaryArithmeticProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryArithmeticOperation)i.readEnum(BinaryArithmeticOperation.class));
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeEnum((Enum)((BinaryArithmeticOperation)this.operation()));
    }

    public String getWriteableName() {
        return NAME;
    }

    public static enum BinaryArithmeticOperation implements BiFunction<Number, Number, Number>
    {
        ADD(Arithmetics::add, "+"),
        SUB(Arithmetics::sub, "-"),
        MUL(Arithmetics::mul, "*"),
        DIV(Arithmetics::div, "/"),
        MOD(Arithmetics::mod, "%");

        private final BiFunction<Number, Number, Number> process;
        private final String symbol;

        private BinaryArithmeticOperation(BiFunction<Number, Number, Number> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        @Override
        public final Number apply(Number left, Number right) {
            return this.process.apply(left, right);
        }

        public String toString() {
            return this.symbol;
        }
    }
}

