/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.BinaryLogic;
import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.Not;
import org.elasticsearch.xpack.sql.expression.predicate.Or;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class And
extends BinaryLogic
implements BinaryOperator.Negateable {
    public And(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<And> info() {
        return NodeInfo.create(this, And::new, this.left(), this.right());
    }

    @Override
    protected BinaryOperator replaceChildren(Expression newLeft, Expression newRight) {
        return new And(this.location(), newLeft, newRight);
    }

    @Override
    public Object fold() {
        return Objects.equals(this.left().fold(), Boolean.TRUE) && Objects.equals(this.right().fold(), Boolean.TRUE);
    }

    @Override
    public Or negate() {
        return new Or(this.location(), new Not(this.location(), this.left()), new Not(this.location(), this.right()));
    }

    @Override
    public And swapLeftAndRight() {
        return new And(this.location(), this.right(), this.left());
    }

    @Override
    public String symbol() {
        return "&&";
    }
}

