/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class LessThanOrEqual
extends BinaryComparison
implements BinaryOperator.Negateable {
    public LessThanOrEqual(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<LessThanOrEqual> info() {
        return NodeInfo.create(this, LessThanOrEqual::new, this.left(), this.right());
    }

    @Override
    protected LessThanOrEqual replaceChildren(Expression newLeft, Expression newRight) {
        return new LessThanOrEqual(this.location(), newLeft, newRight);
    }

    @Override
    public Object fold() {
        Integer compare = LessThanOrEqual.compare(this.left().fold(), this.right().fold());
        return compare != null && compare <= 0;
    }

    @Override
    public GreaterThanOrEqual swapLeftAndRight() {
        return new GreaterThanOrEqual(this.location(), this.right(), this.left());
    }

    @Override
    public GreaterThan negate() {
        return new GreaterThan(this.location(), this.left(), this.right());
    }

    @Override
    public String symbol() {
        return "<=";
    }
}

