/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.physical.LeafExec;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class CommandExec
extends LeafExec {
    private final Command command;

    public CommandExec(Location location, Command command) {
        super(location);
        this.command = command;
    }

    @Override
    protected NodeInfo<CommandExec> info() {
        return NodeInfo.create(this, CommandExec::new, this.command);
    }

    public Command command() {
        return this.command;
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        this.command.execute(session, listener);
    }

    @Override
    public List<Attribute> output() {
        return this.command.output();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.command);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CommandExec other = (CommandExec)obj;
        return Objects.equals(this.command, other.command);
    }
}

