/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.EsField;

public class KeywordEsField
extends EsField {
    private final int precision;
    private final boolean normalized;

    public KeywordEsField(String name) {
        this(name, Collections.emptyMap(), true, DataType.KEYWORD.defaultPrecision, false);
    }

    public KeywordEsField(String name, Map<String, EsField> properties, boolean hasDocValues, int precision, boolean normalized) {
        super(name, DataType.KEYWORD, properties, hasDocValues);
        this.precision = precision;
        this.normalized = normalized;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public boolean isExact() {
        return !this.normalized;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeywordEsField that = (KeywordEsField)o;
        return this.precision == that.precision && this.normalized == that.normalized;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.normalized);
    }
}

