/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import java.util.HashMap;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.audit.AuditTrailService;

public final class IndicesAliasesRequestInterceptor
implements RequestInterceptor<IndicesAliasesRequest> {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public IndicesAliasesRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState, AuditTrailService auditTrailService) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.auditTrailService = auditTrailService;
    }

    @Override
    public void intercept(IndicesAliasesRequest request, Authentication authentication, Role userPermissions, String action) {
        XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
        if (frozenLicenseState.isAuthAllowed()) {
            if (frozenLicenseState.isDocumentAndFieldLevelSecurityAllowed()) {
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
                for (IndicesAliasesRequest.AliasActions aliasAction : request.getAliasActions()) {
                    if (aliasAction.actionType() != IndicesAliasesRequest.AliasActions.Type.ADD) continue;
                    for (String index : aliasAction.indices()) {
                        boolean dls;
                        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                        if (indexAccessControl == null) continue;
                        boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                        boolean bl = dls = indexAccessControl.getQueries() != null;
                        if (!fls && !dls) continue;
                        throw new ElasticsearchSecurityException("Alias requests are not allowed for users who have field or document level security enabled on one of the indices", RestStatus.BAD_REQUEST, new Object[0]);
                    }
                }
            }
            HashMap<String, Automaton> permissionsMap = new HashMap<String, Automaton>();
            for (IndicesAliasesRequest.AliasActions aliasAction : request.getAliasActions()) {
                if (aliasAction.actionType() != IndicesAliasesRequest.AliasActions.Type.ADD) continue;
                for (String index : aliasAction.indices()) {
                    Automaton indexPermissions = permissionsMap.computeIfAbsent(index, arg_0 -> ((IndicesPermission)userPermissions.indices()).allowedActionsMatcher(arg_0));
                    for (String alias : aliasAction.aliases()) {
                        Automaton aliasPermissions = permissionsMap.computeIfAbsent(alias, arg_0 -> ((IndicesPermission)userPermissions.indices()).allowedActionsMatcher(arg_0));
                        if (Operations.subsetOf((Automaton)aliasPermissions, (Automaton)indexPermissions)) continue;
                        this.auditTrailService.accessDenied(authentication, action, (TransportMessage)request, userPermissions.names());
                        throw Exceptions.authorizationError((String)"Adding an alias is not allowed when the alias has more permissions than any of the indices", (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof IndicesAliasesRequest;
    }
}

