/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.RoundRobinDNSServerSet;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import java.util.Locale;
import javax.net.SocketFactory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public enum LdapLoadBalancing {
    FAILOVER{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, Settings settings, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            FailoverServerSet serverSet = new FailoverServerSet(addresses, ports, socketFactory, options);
            serverSet.setReOrderOnFailover(true);
            return serverSet;
        }
    }
    ,
    ROUND_ROBIN{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, Settings settings, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            return new RoundRobinServerSet(addresses, ports, socketFactory, options);
        }
    }
    ,
    DNS_ROUND_ROBIN{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, Settings settings, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            if (addresses.length != 1) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a single url");
            }
            if (InetAddresses.isInetAddress((String)addresses[0])) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a DNS name");
            }
            TimeValue dnsTtl = settings.getAsTime("cache_ttl", CACHE_TTL_DEFAULT);
            return new RoundRobinDNSServerSet(addresses[0], ports[0], RoundRobinDNSServerSet.AddressSelectionMode.ROUND_ROBIN, dnsTtl.millis(), null, socketFactory, options);
        }
    }
    ,
    DNS_FAILOVER{

        @Override
        ServerSet buildServerSet(String[] addresses, int[] ports, Settings settings, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
            if (addresses.length != 1) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a single url");
            }
            if (InetAddresses.isInetAddress((String)addresses[0])) {
                throw new IllegalArgumentException(this.toString() + " can only be used with a DNS name");
            }
            TimeValue dnsTtl = settings.getAsTime("cache_ttl", CACHE_TTL_DEFAULT);
            return new RoundRobinDNSServerSet(addresses[0], ports[0], RoundRobinDNSServerSet.AddressSelectionMode.FAILOVER, dnsTtl.millis(), null, socketFactory, options);
        }
    };

    public static final String LOAD_BALANCE_TYPE_DEFAULT;
    public static final TimeValue CACHE_TTL_DEFAULT;

    abstract ServerSet buildServerSet(String[] var1, int[] var2, Settings var3, @Nullable SocketFactory var4, @Nullable LDAPConnectionOptions var5);

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LdapLoadBalancing resolve(Settings settings) {
        Settings loadBalanceSettings = settings.getAsSettings("load_balance");
        String type = loadBalanceSettings.get("type", LOAD_BALANCE_TYPE_DEFAULT);
        try {
            return LdapLoadBalancing.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ilae) {
            throw new IllegalArgumentException("unknown load balance type [" + type + "]", ilae);
        }
    }

    public static ServerSet serverSet(String[] addresses, int[] ports, Settings settings, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions options) {
        LdapLoadBalancing loadBalancing = LdapLoadBalancing.resolve(settings);
        Settings loadBalanceSettings = settings.getAsSettings("load_balance");
        return loadBalancing.buildServerSet(addresses, ports, loadBalanceSettings, socketFactory, options);
    }

    static {
        LOAD_BALANCE_TYPE_DEFAULT = FAILOVER.toString();
        CACHE_TTL_DEFAULT = TimeValue.timeValueHours((long)1L);
    }
}

