/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultEntryProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = 6501366526364541767L;
    private final List<Attribute> attributes;
    private final String dn;

    public SearchResultEntryProtocolOp(String dn, List<Attribute> attributes) {
        this.dn = dn;
        this.attributes = Collections.unmodifiableList(attributes);
    }

    public SearchResultEntryProtocolOp(Entry entry) {
        this.dn = entry.getDN();
        this.attributes = Collections.unmodifiableList(new ArrayList<Attribute>(entry.getAttributes()));
    }

    SearchResultEntryProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence attrSequence = reader.beginSequence();
            while (attrSequence.hasMoreElements()) {
                attrs.add(Attribute.readFrom(reader));
            }
            this.attributes = Collections.unmodifiableList(attrs);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getProtocolOpType() {
        return 100;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(this.attributes.size());
        for (Attribute a : this.attributes) {
            attrElements.add(a.encode());
        }
        return new ASN1Sequence(100, new ASN1OctetString(this.dn), new ASN1Sequence(attrElements));
    }

    public static SearchResultEntryProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(attrElements.length);
            for (ASN1Element e : attrElements) {
                attributes.add(Attribute.decode(ASN1Sequence.decodeAsSequence(e)));
            }
            return new SearchResultEntryProtocolOp(dn, attributes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)100);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence attrSequence = buffer.beginSequence();
        for (Attribute a : this.attributes) {
            a.writeTo(buffer);
        }
        attrSequence.end();
        opSequence.end();
    }

    public SearchResultEntry toSearchResultEntry(Control ... controls) {
        return new SearchResultEntry(this.dn, this.attributes, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchResultEntryProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', attrs={");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

