/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.PropertyNode;
import a_vcard.android.syncml.pim.VNode;
import a_vcard.android.telephony.PhoneNumberUtils;
import a_vcard.android.text.TextUtils;
import a_vcard.android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactStruct {
    private static final String LOG_TAG = "ContactStruct";
    public static final int NAME_ORDER_TYPE_ENGLISH = 0;
    public static final int NAME_ORDER_TYPE_JAPANESE = 1;
    public String name;
    public String phoneticName;
    public List<String> notes = new ArrayList<String>();
    public String title;
    public byte[] photoBytes;
    public String photoType;
    public List<PhoneData> phoneList;
    public List<ContactMethod> contactmethodList;
    public List<OrganizationData> organizationList;
    public Map<String, List<String>> extensionMap;
    @Deprecated
    public String company;

    public void addPhone(int type, String data, String label, boolean isPrimary) {
        if (this.phoneList == null) {
            this.phoneList = new ArrayList<PhoneData>();
        }
        PhoneData phoneData = new PhoneData();
        phoneData.type = type;
        StringBuilder builder = new StringBuilder();
        String trimed = data.trim();
        int length = trimed.length();
        for (int i = 0; i < length; ++i) {
            char ch = trimed.charAt(i);
            if (('0' > ch || ch > '9') && (i != 0 || ch != '+')) continue;
            builder.append(ch);
        }
        phoneData.data = PhoneNumberUtils.formatNumber(builder.toString());
        phoneData.label = label;
        phoneData.isPrimary = isPrimary;
        this.phoneList.add(phoneData);
    }

    public void addContactmethod(int kind, int type, String data, String label, boolean isPrimary) {
        if (this.contactmethodList == null) {
            this.contactmethodList = new ArrayList<ContactMethod>();
        }
        ContactMethod contactMethod = new ContactMethod();
        contactMethod.kind = kind;
        contactMethod.type = type;
        contactMethod.data = data;
        contactMethod.label = label;
        contactMethod.isPrimary = isPrimary;
        this.contactmethodList.add(contactMethod);
    }

    public void addOrganization(int type, String companyName, String positionName, boolean isPrimary) {
        if (this.organizationList == null) {
            this.organizationList = new ArrayList<OrganizationData>();
        }
        OrganizationData organizationData = new OrganizationData();
        organizationData.type = type;
        organizationData.companyName = companyName;
        organizationData.positionName = positionName;
        organizationData.isPrimary = isPrimary;
        this.organizationList.add(organizationData);
    }

    public void setPosition(String positionValue) {
        int size;
        if (this.organizationList == null) {
            this.organizationList = new ArrayList<OrganizationData>();
        }
        if ((size = this.organizationList.size()) == 0) {
            this.addOrganization(2, "", null, false);
            size = 1;
        }
        OrganizationData lastData = this.organizationList.get(size - 1);
        lastData.positionName = positionValue;
    }

    public void addExtension(PropertyNode propertyNode) {
        List<Object> list;
        if (propertyNode.propValue.length() == 0) {
            return;
        }
        String name = propertyNode.propName;
        if (this.extensionMap == null) {
            this.extensionMap = new HashMap<String, List<String>>();
        }
        if (!this.extensionMap.containsKey(name)) {
            list = new ArrayList();
            this.extensionMap.put(name, list);
        } else {
            list = this.extensionMap.get(name);
        }
        list.add(propertyNode.encode());
    }

    private static String getNameFromNProperty(List<String> elems, int nameOrderType) {
        int size = elems.size();
        if (size > 1) {
            String second;
            String first;
            StringBuilder builder = new StringBuilder();
            boolean builderIsEmpty = true;
            if (size > 3 && elems.get(3).length() > 0) {
                builder.append(elems.get(3));
                builderIsEmpty = false;
            }
            if (nameOrderType == 1) {
                first = elems.get(0);
                second = elems.get(1);
            } else {
                first = elems.get(1);
                second = elems.get(0);
            }
            if (first.length() > 0) {
                if (!builderIsEmpty) {
                    builder.append(' ');
                }
                builder.append(first);
                builderIsEmpty = false;
            }
            if (size > 2 && elems.get(2).length() > 0) {
                if (!builderIsEmpty) {
                    builder.append(' ');
                }
                builder.append(elems.get(2));
                builderIsEmpty = false;
            }
            if (second.length() > 0) {
                if (!builderIsEmpty) {
                    builder.append(' ');
                }
                builder.append(second);
                builderIsEmpty = false;
            }
            if (size > 4 && elems.get(4).length() > 0) {
                if (!builderIsEmpty) {
                    builder.append(' ');
                }
                builder.append(elems.get(4));
                builderIsEmpty = false;
            }
            return builder.toString();
        }
        if (size == 1) {
            return elems.get(0);
        }
        return "";
    }

    public static ContactStruct constructContactFromVNode(VNode node, int nameOrderType) {
        if (!node.VName.equals("VCARD")) {
            Log.e(LOG_TAG, "Non VCARD data is inserted.");
            return null;
        }
        String fullName = null;
        String nameFromNProperty = null;
        String xPhoneticFirstName = null;
        String xPhoneticMiddleName = null;
        String xPhoneticLastName = null;
        ContactStruct contact = new ContactStruct();
        boolean prefIsSetAddress = false;
        boolean prefIsSetPhone = false;
        boolean prefIsSetEmail = false;
        boolean prefIsSetOrganization = false;
        for (PropertyNode propertyNode : node.propList) {
            String name = propertyNode.propName;
            if (TextUtils.isEmpty(propertyNode.propValue) || name.equals("VERSION")) continue;
            if (name.equals("FN")) {
                fullName = propertyNode.propValue;
                continue;
            }
            if (name.equals("NAME") && fullName == null) {
                fullName = propertyNode.propValue;
                continue;
            }
            if (name.equals("N")) {
                nameFromNProperty = ContactStruct.getNameFromNProperty(propertyNode.propValue_vector, nameOrderType);
                continue;
            }
            if (name.equals("SORT-STRING")) {
                contact.phoneticName = propertyNode.propValue;
                continue;
            }
            if (name.equals("SOUND")) {
                if (propertyNode.paramMap_TYPE.contains("X-IRMC-N") && contact.phoneticName == null) {
                    StringBuilder builder = new StringBuilder();
                    String value = propertyNode.propValue;
                    int length = value.length();
                    for (int i = 0; i < length; ++i) {
                        char ch = value.charAt(i);
                        if (ch == ';') continue;
                        builder.append(ch);
                    }
                    contact.phoneticName = builder.toString();
                    continue;
                }
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("ADR")) {
                String address;
                List<String> list;
                int size;
                List<String> values = propertyNode.propValue_vector;
                boolean valuesAreAllEmpty = true;
                for (String value : values) {
                    if (value.length() <= 0) continue;
                    valuesAreAllEmpty = false;
                    break;
                }
                if (valuesAreAllEmpty) continue;
                int kind = 2;
                int type = -1;
                String label = "";
                boolean isPrimary = false;
                for (String typeString : propertyNode.paramMap_TYPE) {
                    if (typeString.equals("PREF") && !prefIsSetAddress) {
                        prefIsSetAddress = true;
                        isPrimary = true;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("HOME")) {
                        type = 1;
                        label = "";
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("WORK") || typeString.equalsIgnoreCase("COMPANY")) {
                        type = 2;
                        label = "";
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("POSTAL")) {
                        kind = 2;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("PARCEL") || typeString.equalsIgnoreCase("DOM") || typeString.equalsIgnoreCase("INTL")) continue;
                    if (typeString.toUpperCase().startsWith("X-") && type < 0) {
                        type = 0;
                        label = typeString.substring(2);
                        continue;
                    }
                    if (type >= 0) continue;
                    type = 0;
                    label = typeString;
                }
                if (type < 0) {
                    type = 1;
                }
                if ((size = (list = propertyNode.propValue_vector).size()) > 1) {
                    String addressPart;
                    int i;
                    StringBuilder builder = new StringBuilder();
                    boolean builderIsEmpty = true;
                    if (Locale.getDefault().getCountry().equals(Locale.JAPAN.getCountry())) {
                        for (i = size - 1; i >= 0; --i) {
                            addressPart = list.get(i);
                            if (addressPart.length() <= 0) continue;
                            if (!builderIsEmpty) {
                                builder.append(' ');
                            }
                            builder.append(addressPart);
                            builderIsEmpty = false;
                        }
                    } else {
                        for (i = 0; i < size; ++i) {
                            addressPart = list.get(i);
                            if (addressPart.length() <= 0) continue;
                            if (!builderIsEmpty) {
                                builder.append(' ');
                            }
                            builder.append(addressPart);
                            builderIsEmpty = false;
                        }
                    }
                    address = builder.toString().trim();
                } else {
                    address = propertyNode.propValue;
                }
                contact.addContactmethod(kind, type, address, label, isPrimary);
                continue;
            }
            if (name.equals("ORG")) {
                int type = 1;
                boolean isPrimary = false;
                for (String typeString : propertyNode.paramMap_TYPE) {
                    if (!typeString.equals("PREF") || prefIsSetOrganization) continue;
                    prefIsSetOrganization = true;
                    isPrimary = true;
                }
                List<String> list = propertyNode.propValue_vector;
                int size = list.size();
                StringBuilder builder = new StringBuilder();
                Iterator<String> iter = list.iterator();
                while (iter.hasNext()) {
                    builder.append(iter.next());
                    if (!iter.hasNext()) continue;
                    builder.append(' ');
                }
                contact.addOrganization(type, builder.toString(), "", isPrimary);
                continue;
            }
            if (name.equals("TITLE")) {
                contact.setPosition(propertyNode.propValue);
                continue;
            }
            if (name.equals("ROLE")) {
                contact.setPosition(propertyNode.propValue);
                continue;
            }
            if (name.equals("PHOTO")) {
                String valueType = propertyNode.paramMap.getAsString("VALUE");
                if (valueType != null && valueType.equals("URL")) continue;
                contact.photoBytes = propertyNode.propValue_bytes;
                String type = propertyNode.paramMap.getAsString("TYPE");
                if (type == null) continue;
                contact.photoType = type;
                continue;
            }
            if (name.equals("LOGO")) {
                String valueType = propertyNode.paramMap.getAsString("VALUE");
                if (valueType != null && valueType.equals("URL") || contact.photoBytes != null) continue;
                contact.photoBytes = propertyNode.propValue_bytes;
                String type = propertyNode.paramMap.getAsString("TYPE");
                if (type == null) continue;
                contact.photoType = type;
                continue;
            }
            if (name.equals("EMAIL")) {
                int type = -1;
                String label = null;
                boolean isPrimary = false;
                for (String typeString : propertyNode.paramMap_TYPE) {
                    if (typeString.equals("PREF") && !prefIsSetEmail) {
                        prefIsSetEmail = true;
                        isPrimary = true;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("HOME")) {
                        type = 1;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("WORK")) {
                        type = 2;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("CELL")) {
                        type = 0;
                        label = "_AUTO_CELL";
                        continue;
                    }
                    if (typeString.toUpperCase().startsWith("X-") && type < 0) {
                        type = 0;
                        label = typeString.substring(2);
                        continue;
                    }
                    if (type >= 0) continue;
                    type = 0;
                    label = typeString;
                }
                if (type < 0) {
                    type = 3;
                }
                contact.addContactmethod(1, type, propertyNode.propValue, label, isPrimary);
                continue;
            }
            if (name.equals("TEL")) {
                int type = -1;
                String label = null;
                boolean isPrimary = false;
                boolean isFax = false;
                for (String typeString : propertyNode.paramMap_TYPE) {
                    if (typeString.equals("PREF") && !prefIsSetPhone) {
                        prefIsSetPhone = true;
                        isPrimary = true;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("HOME")) {
                        type = 1;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("WORK")) {
                        type = 3;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("CELL")) {
                        type = 2;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("PAGER")) {
                        type = 6;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("FAX")) {
                        isFax = true;
                        continue;
                    }
                    if (typeString.equalsIgnoreCase("VOICE") || typeString.equalsIgnoreCase("MSG")) continue;
                    if (typeString.toUpperCase().startsWith("X-") && type < 0) {
                        type = 0;
                        label = typeString.substring(2);
                        continue;
                    }
                    if (type >= 0) continue;
                    type = 0;
                    label = typeString;
                }
                if (type < 0) {
                    type = 1;
                }
                if (isFax) {
                    if (type == 1) {
                        type = 5;
                    } else if (type == 3) {
                        type = 4;
                    }
                }
                contact.addPhone(type, propertyNode.propValue, label, isPrimary);
                continue;
            }
            if (name.equals("NOTE")) {
                contact.notes.add(propertyNode.propValue);
                continue;
            }
            if (name.equals("BDAY")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("URL")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("REV")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("UID")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("KEY")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("MAILER")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("TZ")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("GEO")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("NICKNAME")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("CLASS")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("PROFILE")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("CATEGORIES")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("SOURCE")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("PRODID")) {
                contact.addExtension(propertyNode);
                continue;
            }
            if (name.equals("X-PHONETIC-FIRST-NAME")) {
                xPhoneticFirstName = propertyNode.propValue;
                continue;
            }
            if (name.equals("X-PHONETIC-MIDDLE-NAME")) {
                xPhoneticMiddleName = propertyNode.propValue;
                continue;
            }
            if (name.equals("X-PHONETIC-LAST-NAME")) {
                xPhoneticLastName = propertyNode.propValue;
                continue;
            }
            contact.addExtension(propertyNode);
        }
        contact.name = fullName != null ? fullName : (nameFromNProperty != null ? nameFromNProperty : "");
        if (contact.phoneticName == null && (xPhoneticFirstName != null || xPhoneticMiddleName != null || xPhoneticLastName != null)) {
            String second;
            String first;
            if (nameOrderType == 1) {
                first = xPhoneticLastName;
                second = xPhoneticFirstName;
            } else {
                first = xPhoneticFirstName;
                second = xPhoneticLastName;
            }
            StringBuilder builder = new StringBuilder();
            if (first != null) {
                builder.append(first);
            }
            if (xPhoneticMiddleName != null) {
                builder.append(xPhoneticMiddleName);
            }
            if (second != null) {
                builder.append(second);
            }
            contact.phoneticName = builder.toString();
        }
        if (contact.phoneticName != null) {
            contact.phoneticName = contact.phoneticName.trim();
        }
        if (!prefIsSetPhone && contact.phoneList != null && contact.phoneList.size() > 0) {
            contact.phoneList.get((int)0).isPrimary = true;
        }
        if (!prefIsSetAddress && contact.contactmethodList != null) {
            for (ContactMethod contactMethod : contact.contactmethodList) {
                if (contactMethod.kind != 2) continue;
                contactMethod.isPrimary = true;
                break;
            }
        }
        if (!prefIsSetEmail && contact.contactmethodList != null) {
            for (ContactMethod contactMethod : contact.contactmethodList) {
                if (contactMethod.kind != 1) continue;
                contactMethod.isPrimary = true;
                break;
            }
        }
        if (!prefIsSetOrganization && contact.organizationList != null && contact.organizationList.size() > 0) {
            contact.organizationList.get((int)0).isPrimary = true;
        }
        return contact;
    }

    public String displayString() {
        if (this.name.length() > 0) {
            return this.name;
        }
        if (this.contactmethodList != null && this.contactmethodList.size() > 0) {
            for (ContactMethod contactMethod : this.contactmethodList) {
                if (contactMethod.kind != 1 || !contactMethod.isPrimary) continue;
                return contactMethod.data;
            }
        }
        if (this.phoneList != null && this.phoneList.size() > 0) {
            for (PhoneData phoneData : this.phoneList) {
                if (!phoneData.isPrimary) continue;
                return phoneData.data;
            }
        }
        return "";
    }

    public boolean isIgnorable() {
        return !(!TextUtils.isEmpty(this.name) || !TextUtils.isEmpty(this.phoneticName) || this.phoneList != null && this.phoneList.size() != 0 || this.contactmethodList != null && this.contactmethodList.size() != 0);
    }

    public static class OrganizationData {
        public int type;
        public String companyName;
        public String positionName;
        public boolean isPrimary;
    }

    public static class ContactMethod {
        public int kind;
        public int type;
        public String data;
        public String label;
        public boolean isPrimary;
    }

    public static class PhoneData {
        public int type;
        public String data;
        public String label;
        public boolean isPrimary;
    }
}

