/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class ColorPanel
extends JPanel
implements ActionListener,
AttributeComponent {
    JTextField colorDisplay = new JTextField();
    private final Color defaultColor;
    private final Object attributeKey;
    private Color originalColor;
    private int setValCount = 0;
    private final JColorChooser colorChooserPane = new JColorChooser();
    private final Vector listeners = new Vector(0);

    public ColorPanel(String title, Color col, Object key) {
        super(new BorderLayout(5, 5));
        this.defaultColor = col;
        this.attributeKey = key;
        this.colorDisplay.setBackground(col);
        Dimension dim = new Dimension(20, 15);
        this.colorDisplay.setMinimumSize(dim);
        this.colorDisplay.setMaximumSize(dim);
        this.colorDisplay.setPreferredSize(dim);
        this.colorDisplay.setEditable(false);
        JButton browseButton = new JButton();
        browseButton.setText("...");
        dim = new Dimension(20, 15);
        browseButton.setMinimumSize(dim);
        browseButton.setMaximumSize(dim);
        browseButton.setPreferredSize(dim);
        browseButton.addActionListener(this);
        JPanel eastPanel = new JPanel(new FlowLayout());
        eastPanel.add(this.colorDisplay);
        eastPanel.add(browseButton);
        if (title != null && title.length() > 0) {
            JLabel titleLabel = new JLabel(title);
            titleLabel.setFont(UIManager.getFont("TextField.font"));
            this.add((Component)titleLabel, "West");
            this.add((Component)eastPanel, "East");
        } else {
            this.add((Component)eastPanel, "West");
        }
    }

    public Color getColor() {
        return this.colorDisplay.getBackground();
    }

    private void setColor(Color color) {
        this.colorDisplay.setBackground(color);
        if (++this.setValCount < 2) {
            this.originalColor = color;
        }
        this.fireColorChanged();
    }

    public void actionPerformed(ActionEvent e) {
        Color color = this.showColorChooserDialog();
        if (color != null) {
            ++this.setValCount;
            this.setColor(color);
        }
    }

    private Color showColorChooserDialog() {
        this.colorChooserPane.setColor(this.colorDisplay.getBackground());
        class ColorTracker
        implements ActionListener {
            JColorChooser chooser;
            Color color;

            public ColorTracker(JColorChooser c) {
                this.chooser = c;
            }

            public void actionPerformed(ActionEvent e) {
                this.color = this.chooser.getColor();
            }
        }
        ColorTracker ok = new ColorTracker(this.colorChooserPane);
        JDialog dialog = JColorChooser.createDialog(this, "Select Color", true, this.colorChooserPane, ok, null);
        dialog.setVisible(true);
        dialog.dispose();
        return ok.color;
    }

    public boolean setValue(AttributeSet a) {
        Color newSelection = null;
        if (this.getAttributeKey() == CSS.Attribute.COLOR) {
            newSelection = Util.styleSheet().getForeground(a);
        }
        if (this.getAttributeKey() == CSS.Attribute.BACKGROUND_COLOR && (newSelection = Util.styleSheet().getBackground(a)) == null) {
            newSelection = SystemColor.text;
        }
        if (newSelection != null) {
            this.setColor(newSelection);
            return true;
        }
        return false;
    }

    public void setValue(String value) {
        try {
            this.setColor(new Color(Integer.parseInt(value.toString().substring(1).toUpperCase(), 16)));
        }
        catch (Exception e) {
            try {
                this.setColor(Color.getColor(value));
            }
            catch (Exception e2) {
                Util.errMsg(null, null, e2);
            }
        }
    }

    public String getAttr() {
        String color = "#" + Integer.toHexString(this.getColor().getRGB()).substring(2);
        return color;
    }

    public AttributeSet getValue() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        Color value = this.getColor();
        if (value != this.originalColor) {
            String color = "#" + Integer.toHexString(value.getRGB()).substring(2);
            Util.styleSheet().addCSSAttribute(set, (CSS.Attribute)this.getAttributeKey(), color);
            if (this.getAttributeKey() == CSS.Attribute.COLOR) {
                set.addAttribute(HTML.Attribute.COLOR, color);
            } else if (this.getAttributeKey() == CSS.Attribute.BACKGROUND_COLOR) {
                set.addAttribute(HTML.Attribute.BGCOLOR, color);
            }
        }
        return set;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet set = new SimpleAttributeSet();
            Color value = this.getColor();
            String color = "#" + Integer.toHexString(value.getRGB()).substring(2);
            try {
                Util.styleSheet().addCSSAttribute(set, (CSS.Attribute)this.getAttributeKey(), color);
            }
            catch (Exception e) {
                set.addAttribute(this.getAttributeKey(), color);
            }
            return set;
        }
        return this.getValue();
    }

    public Object getAttributeKey() {
        return this.attributeKey;
    }

    public void addColorPanelListener(ColorPanelListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeColorPanelListener(ColorPanelListener listener) {
        this.listeners.removeElement(listener);
    }

    void fireColorChanged() {
        Enumeration listenerList = this.listeners.elements();
        while (listenerList.hasMoreElements()) {
            ((ColorPanelListener)listenerList.nextElement()).colorChanged(new ColorPanelEvent(this));
        }
    }

    static interface ColorPanelListener
    extends EventListener {
        public void colorChanged(ColorPanelEvent var1);
    }

    class ColorPanelEvent
    extends EventObject {
        public ColorPanelEvent(Object source) {
            super(source);
        }
    }
}

