/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import java.util.HashSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.TaskOutputFilesRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.GFileUtils;

public class CleanupStaleOutputsExecuter
implements TaskExecuter {
    public static final String CLEAN_STALE_OUTPUTS_DISPLAY_NAME = "Clean stale outputs";
    private final Logger logger = Logging.getLogger(CleanupStaleOutputsExecuter.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskOutputChangesListener taskOutputChangesListener;
    private final TaskExecuter executer;
    private final TaskOutputFilesRepository taskOutputFilesRepository;
    private final BuildOutputCleanupRegistry cleanupRegistry;

    public CleanupStaleOutputsExecuter(BuildOutputCleanupRegistry cleanupRegistry, TaskOutputFilesRepository taskOutputFilesRepository, BuildOperationExecutor buildOperationExecutor, TaskOutputChangesListener taskOutputChangesListener, TaskExecuter executer) {
        this.cleanupRegistry = cleanupRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.taskOutputChangesListener = taskOutputChangesListener;
        this.executer = executer;
        this.taskOutputFilesRepository = taskOutputFilesRepository;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        final HashSet<File> filesToDelete = new HashSet<File>();
        TaskProperties taskProperties = context.getTaskProperties();
        for (TaskOutputFilePropertySpec outputFileSpec : taskProperties.getOutputFileProperties()) {
            FileCollection files = outputFileSpec.getPropertyFiles();
            for (File file : files) {
                if (!this.cleanupRegistry.isOutputOwnedByBuild(file) || this.taskOutputFilesRepository.isGeneratedByGradle(file) || !file.exists()) continue;
                filesToDelete.add(file);
            }
        }
        if (!filesToDelete.isEmpty()) {
            this.taskOutputChangesListener.beforeTaskOutputChanged();
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    for (File file : filesToDelete) {
                        if (!file.exists()) continue;
                        CleanupStaleOutputsExecuter.this.logger.info("Deleting stale output file: {}", (Object)file.getAbsolutePath());
                        GFileUtils.forceDelete((File)file);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)CleanupStaleOutputsExecuter.CLEAN_STALE_OUTPUTS_DISPLAY_NAME).progressDisplayName("Cleaning stale outputs");
                }
            });
        }
        this.executer.execute(task, state, context);
    }
}

