/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.MiscUtilities;

public class SplitConfigParser {
    private String splitConfig;
    private boolean includeSplits = true;
    private boolean includeFiles = true;
    private boolean includeRemotes = false;

    public SplitConfigParser(String string) {
        this.splitConfig = string == null ? "" : string;
    }

    public void setIncludeSplits(boolean bl) {
        this.includeSplits = bl;
    }

    public void setIncludeFiles(boolean bl) {
        this.includeFiles = bl;
    }

    public void setIncludeRemoteFiles(boolean bl) {
        this.includeRemotes = this.includeFiles && bl;
    }

    public String parse() {
        if (this.splitConfig == null || this.splitConfig.length() == 0) {
            return "";
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        ArrayDeque<Object> arrayDeque2 = new ArrayDeque<Object>();
        BufferSet bufferSet = new BufferSet(this.includeFiles, this.includeRemotes);
        boolean bl = false;
        try {
            Object object;
            BufferSet bufferSet2;
            StringBuilder stringBuilder;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.splitConfig));
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.wordChars(35, 126);
            streamTokenizer.commentChar(33);
            streamTokenizer.quoteChar(34);
            streamTokenizer.eolIsSignificant(false);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                switch (n) {
                    case -3: {
                        if ("vertical".equals(streamTokenizer.sval) || "horizontal".equals(streamTokenizer.sval)) {
                            if (!this.includeSplits) break;
                            stringBuilder = arrayDeque2.pop();
                            bufferSet2 = arrayDeque2.pop();
                            object = new Split();
                            ((Split)object).setLeft(bufferSet2);
                            ((Split)object).setRight(stringBuilder);
                            ((Split)object).setDirection(streamTokenizer.sval);
                            int n2 = (Integer)arrayDeque.pop();
                            ((Split)object).setOffset(n2);
                            arrayDeque2.push(object);
                            bl = true;
                            break;
                        }
                        if ("buffer".equals(streamTokenizer.sval) || "buff".equals(streamTokenizer.sval)) {
                            stringBuilder = arrayDeque.pop();
                            bufferSet.addBuffer(((Object)stringBuilder).toString());
                            break;
                        }
                        if (!"bufferset".equals(streamTokenizer.sval)) break;
                        stringBuilder = arrayDeque.pop();
                        bufferSet.setScope(((Object)stringBuilder).toString());
                        arrayDeque2.push(bufferSet);
                        bufferSet = new BufferSet(this.includeFiles, this.includeRemotes);
                        break;
                    }
                    case -2: {
                        arrayDeque.push((int)streamTokenizer.nval);
                        break;
                    }
                    case 34: {
                        arrayDeque.push(streamTokenizer.sval);
                    }
                }
                n = streamTokenizer.nextToken();
            }
            stringBuilder = new StringBuilder();
            if (bl) {
                while (!arrayDeque2.isEmpty()) {
                    stringBuilder.append(arrayDeque2.pop().toString()).append(' ');
                }
            } else {
                bufferSet2 = new BufferSet();
                while (!arrayDeque2.isEmpty()) {
                    object = (BufferSet)arrayDeque2.pop();
                    if (bufferSet2.getScope() == null) {
                        bufferSet2.setScope(((BufferSet)object).getScope());
                    }
                    bufferSet2.addBufferSet((BufferSet)object);
                }
                stringBuilder.append(bufferSet2.toString());
            }
            return stringBuilder.toString().replaceAll("\\\\", "\\\\\\\\").trim();
        }
        catch (IOException iOException) {
            return this.splitConfig;
        }
    }

    private class Split {
        Object left = null;
        Object right = null;
        String direction = null;
        int offset = 0;

        private Split() {
        }

        public void setLeft(Object object) {
            this.left = object;
        }

        public void setRight(Object object) {
            this.right = object;
        }

        public void setDirection(String string) {
            this.direction = string;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.left != null) {
                stringBuilder.append(this.left.toString()).append(' ');
            }
            if (this.right != null) {
                stringBuilder.append(this.right.toString()).append(' ');
            }
            stringBuilder.append(this.offset).append(' ').append(this.direction);
            return stringBuilder.toString();
        }
    }

    private class BufferSet {
        List<String> buffers = new ArrayList<String>();
        String scope = null;
        boolean includeFiles = true;
        boolean includeRemotes = false;

        public BufferSet() {
        }

        public BufferSet(boolean bl, boolean bl2) {
            this.includeFiles = bl;
            this.includeRemotes = bl2;
        }

        public void addBuffer(String string) {
            if (this.includeFiles) {
                if (this.includeRemotes) {
                    this.buffers.add(string);
                    return;
                }
                if (!this.isRemote(string)) {
                    this.buffers.add(string);
                }
            }
        }

        public List<String> getBuffers() {
            return this.buffers;
        }

        public void addBufferSet(BufferSet bufferSet) {
            this.buffers.addAll(bufferSet.getBuffers());
        }

        public void setScope(String string) {
            this.scope = string;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.buffers.size() == 0) {
                stringBuilder.append("\"Untitled-1\" buffer ");
            } else {
                for (int i = 0; i < this.buffers.size(); ++i) {
                    stringBuilder.append('\"').append(this.buffers.get(i)).append('\"');
                    stringBuilder.append(i == 0 ? " buffer " : " buff ");
                }
            }
            if (this.scope == null) {
                this.scope = "view";
            }
            stringBuilder.append('\"').append(this.scope).append("\" bufferset");
            return stringBuilder.toString();
        }

        public boolean isRemote(String string) {
            if (MiscUtilities.isURL(string)) {
                String string2 = MiscUtilities.getProtocolOfURL(string);
                return !string2.equals("file");
            }
            return false;
        }
    }
}

