Clazz.declarePackage ("J.popup");
Clazz.load (["J.popup.PopupResource"], "J.popup.MainPopupResourceBundle", ["JU.PT", "J.i18n.GT", "JV.JC", "$.Viewer"], function () {
c$ = Clazz.declareType (J.popup, "MainPopupResourceBundle", J.popup.PopupResource);
Clazz.overrideMethod (c$, "getMenuName", 
function () {
return "popupMenu";
});
Clazz.overrideMethod (c$, "buildStructure", 
function (menuStructure) {
this.addItems (J.popup.MainPopupResourceBundle.menuContents);
this.addItems (J.popup.MainPopupResourceBundle.structureContents);
if (menuStructure != null) this.setStructure (menuStructure,  new J.i18n.GT ());
}, "~S");
c$.Box = Clazz.defineMethod (c$, "Box", 
 function (cmd) {
return "if (showBoundBox or showUnitcell) {" + cmd + "} else {boundbox on;" + cmd + ";boundbox off}";
}, "~S");
Clazz.overrideMethod (c$, "getWordContents", 
function () {
var wasTranslating = J.i18n.GT.setDoTranslate (true);
var vdw = J.i18n.GT.$ ("{0}% van der Waals");
var exm = J.i18n.GT.$ ("Export {0} 3D model");
var exi = J.i18n.GT.$ ("Export {0} image");
var rld = J.i18n.GT.$ ("Reload {0}");
var scl = J.i18n.GT.$ ("Scale {0}");
var ang = J.i18n.GT.$ ("{0} \u00C5");
var pxl = J.i18n.GT.$ ("{0} px");
var words =  Clazz.newArray (-1, ["cnmrMenu", J.i18n.GT.$ ("13C-NMR"), "hnmrMenu", J.i18n.GT.$ ("1H-NMR"), "aboutMenu", J.i18n.GT.$ ("About..."), "negativeCharge", J.i18n.GT.$ ("Acidic Residues (-)"), "allModelsText", J.i18n.GT.$ ("All {0} models"), "allHetero", J.i18n.GT.$ ("All PDB \"HETATM\""), "Solvent", J.i18n.GT.$ ("All Solvent"), "Water", J.i18n.GT.$ ("All Water"), "selectAll", J.i18n.GT.$ ("All"), "allProtein", null, "allNucleic", null, "allCarbo", null, "altloc#PDB", J.i18n.GT.$ ("Alternative Location"), "amino#PDB", J.i18n.GT.$ ("Amino Acid"), "byAngstromMenu", J.i18n.GT.$ ("Angstrom Width"), "animModeMenu", J.i18n.GT.$ ("Animation Mode"), "FRAMESanimateMenu", J.i18n.GT.$ ("Animation"), "atPairs", J.i18n.GT.$ ("AT pairs"), "atomMenu", J.i18n.GT.$ ("Atoms"), "[color_atoms]Menu", null, "atomsText", J.i18n.GT.$ ("atoms: {0}"), "auPairs", J.i18n.GT.$ ("AU pairs"), "[color_axes]Menu", J.i18n.GT.$ ("Axes"), "showAxesCB", null, "[set_axes]Menu", null, "axisA", J.i18n.GT.$ ("Axis a"), "axisB", J.i18n.GT.$ ("Axis b"), "axisC", J.i18n.GT.$ ("Axis c"), "axisX", J.i18n.GT.$ ("Axis x"), "axisY", J.i18n.GT.$ ("Axis y"), "axisZ", J.i18n.GT.$ ("Axis z"), "back", J.i18n.GT.$ ("Back"), "proteinBackbone", J.i18n.GT.$ ("Backbone"), "nucleicBackbone", null, "backbone", null, "[color_backbone]Menu", null, "[color_background]Menu", J.i18n.GT.$ ("Background"), "renderBallAndStick", J.i18n.GT.$ ("Ball and Stick"), "nucleicBases", J.i18n.GT.$ ("Bases"), "positiveCharge", J.i18n.GT.$ ("Basic Residues (+)"), "best", J.i18n.GT.$ ("Best"), "biomoleculeText", J.i18n.GT.$ ("biomolecule {0} ({1} atoms)"), "biomoleculesMenuText", J.i18n.GT.$ ("Biomolecules"), "black", J.i18n.GT.$ ("Black"), "blue", J.i18n.GT.$ ("Blue"), "bondMenu", J.i18n.GT.$ ("Bonds"), "[color_bonds]Menu", null, "bondsText", J.i18n.GT.$ ("bonds: {0}"), "bottom", J.i18n.GT.$ ("Bottom"), "[color_boundbox]Menu", J.i18n.GT.$ ("Boundbox"), "[set_boundbox]Menu", null, "showBoundBoxCB", null, "PDBheteroComputedMenu", J.i18n.GT.$ ("By HETATM"), "PDBaaResiduesComputedMenu", J.i18n.GT.$ ("By Residue Name"), "PDBnucleicResiduesComputedMenu", null, "PDBcarboResiduesComputedMenu", null, "schemeMenu", J.i18n.GT.$ ("By Scheme"), "[color_]schemeMenu", null, "hbondCalc", J.i18n.GT.$ ("Calculate"), "SIGNEDJAVAcaptureRock", J.i18n.GT.$ ("Capture rock"), "SIGNEDJAVAcaptureSpin", J.i18n.GT.$ ("Capture spin"), "SIGNEDJAVAcaptureMenuSPECIAL", J.i18n.GT.$ ("Capture"), "PDBcarboMenu", J.i18n.GT.$ ("Carbohydrate"), "cartoonRockets", J.i18n.GT.$ ("Cartoon Rockets"), "PDBrenderCartoonsOnly", J.i18n.GT.$ ("Cartoon"), "cartoon", null, "[color_cartoon]sMenu", null, "pickCenter", J.i18n.GT.$ ("Center"), "labelCentered", J.i18n.GT.$ ("Centered"), "chain#PDB", J.i18n.GT.$ ("Chain"), "chainsText", J.i18n.GT.$ ("chains: {0}"), "colorChargeMenu", J.i18n.GT.$ ("Charge"), "measureAngle", J.i18n.GT.$ ("Click for angle measurement"), "measureDistance", J.i18n.GT.$ ("Click for distance measurement"), "measureTorsion", J.i18n.GT.$ ("Click for torsion (dihedral) measurement"), "PDBmeasureSequence", J.i18n.GT.$ ("Click two atoms to display a sequence in the console"), "modelSetCollectionText", J.i18n.GT.$ ("Collection of {0} models"), "colorMenu", J.i18n.GT.$ ("Color"), "computationMenu", J.i18n.GT.$ ("Computation"), "configurationMenuText", J.i18n.GT.$ ("Configurations ({0})"), "configurationComputedMenu", J.i18n.GT.$ ("Configurations"), "showConsole", J.i18n.GT.$ ("Console"), "renderCpkSpacefill", J.i18n.GT.$ ("CPK Spacefill"), "stereoCrossEyed", J.i18n.GT.$ ("Cross-eyed viewing"), "showState", J.i18n.GT.$ ("Current state"), "cyan", J.i18n.GT.$ ("Cyan"), "darkgray", J.i18n.GT.$ ("Dark Gray"), "measureDelete", J.i18n.GT.$ ("Delete measurements"), "SIGNEDJAVAcaptureOff", J.i18n.GT.$ ("Disable capturing"), "hideNotSelectedCB", J.i18n.GT.$ ("Display Selected Only"), "distanceAngstroms", J.i18n.GT.$ ("Distance units Angstroms"), "distanceNanometers", J.i18n.GT.$ ("Distance units nanometers"), "distancePicometers", J.i18n.GT.$ ("Distance units picometers"), "ssbondMenu", J.i18n.GT.$ ("Disulfide Bonds"), "[color_ssbonds]Menu", null, "DNA", J.i18n.GT.$ ("DNA"), "surfDots", J.i18n.GT.$ ("Dot Surface"), "dotted", J.i18n.GT.$ ("Dotted"), "measureOff", J.i18n.GT.$ ("Double-Click begins and ends all measurements"), "cpk", J.i18n.GT.$ ("Element (CPK)"), "elementsComputedMenu", J.i18n.GT.$ ("Element"), "SIGNEDJAVAcaptureEnd", J.i18n.GT.$ ("End capturing"), "exportMenu", J.i18n.GT.$ ("Export"), "extractMOL", J.i18n.GT.$ ("Extract MOL data"), "showFile", J.i18n.GT.$ ("File Contents"), "showFileHeader", J.i18n.GT.$ ("File Header"), "fileMenu", J.i18n.GT.$ ("File"), "formalcharge", J.i18n.GT.$ ("Formal Charge"), "front", J.i18n.GT.$ ("Front"), "gcPairs", J.i18n.GT.$ ("GC pairs"), "gold", J.i18n.GT.$ ("Gold"), "gray", J.i18n.GT.$ ("Gray"), "green", J.i18n.GT.$ ("Green"), "group#PDB", J.i18n.GT.$ ("Group"), "groupsText", J.i18n.GT.$ ("groups: {0}"), "PDBheteroMenu", J.i18n.GT.$ ("Hetero"), "off#axes", J.i18n.GT.$ ("Hide"), "showHistory", J.i18n.GT.$ ("History"), "hbondMenu", J.i18n.GT.$ ("Hydrogen Bonds"), "[color_hbonds]Menu", null, "pickIdent", J.i18n.GT.$ ("Identity"), "indigo", J.i18n.GT.$ ("Indigo"), "none", J.i18n.GT.$ ("Inherit"), "invertSelection", J.i18n.GT.$ ("Invert Selection"), "showIsosurface", J.i18n.GT.$ ("Isosurface JVXL data"), "help", J.i18n.GT.$ ("Jmol Script Commands"), "pickLabel", J.i18n.GT.$ ("Label"), "labelMenu", J.i18n.GT.$ ("Labels"), "[color_labels]Menu", null, "languageComputedMenu", J.i18n.GT.$ ("Language"), "left", J.i18n.GT.$ ("Left"), "Ligand", J.i18n.GT.$ ("Ligand"), "lightgray", J.i18n.GT.$ ("Light Gray"), "measureList", J.i18n.GT.$ ("List measurements"), "loadBiomoleculeText", J.i18n.GT.$ ("load biomolecule {0} ({1} atoms)"), "SIGNEDloadFileUnitCell", J.i18n.GT.$ ("Load full unit cell"), "loadMenu", J.i18n.GT.$ ("Load"), "loop", J.i18n.GT.$ ("Loop"), "labelLowerLeft", J.i18n.GT.$ ("Lower Left"), "labelLowerRight", J.i18n.GT.$ ("Lower Right"), "mainMenuText", J.i18n.GT.$ ("Main Menu"), "opaque", J.i18n.GT.$ ("Make Opaque"), "surfOpaque", null, "translucent", J.i18n.GT.$ ("Make Translucent"), "surfTranslucent", null, "maroon", J.i18n.GT.$ ("Maroon"), "measureMenu", J.i18n.GT.$ ("Measurements"), "showMeasure", null, "modelMenuText", J.i18n.GT.$ ("model {0}"), "hiddenModelSetText", J.i18n.GT.$ ("Model information"), "modelkit", J.i18n.GT.$ ("Model kit"), "showModel", J.i18n.GT.$ ("Model"), "FRAMESbyModelComputedMenu", J.i18n.GT.$ ("Model/Frame"), "modelKitMode", J.i18n.GT.$ ("modelKitMode"), "surf2MEP", J.i18n.GT.$ ("Molecular Electrostatic Potential (range -0.1 0.1)"), "surfMEP", J.i18n.GT.$ ("Molecular Electrostatic Potential (range ALL)"), "showMo", J.i18n.GT.$ ("Molecular orbital JVXL data"), "surfMoComputedMenuText", J.i18n.GT.$ ("Molecular Orbitals ({0})"), "surfMolecular", J.i18n.GT.$ ("Molecular Surface"), "molecule", J.i18n.GT.$ ("Molecule"), "monomer#PDB", J.i18n.GT.$ ("Monomer"), "mouse", J.i18n.GT.$ ("Mouse Manual"), "nextframe", J.i18n.GT.$ ("Next Frame"), "modelSetMenu", J.i18n.GT.$ ("No atoms loaded"), "exceptWater", J.i18n.GT.$ ("Nonaqueous HETATM") + " (hetero and not water)", "nonWaterSolvent", J.i18n.GT.$ ("Nonaqueous Solvent") + " (solvent and not water)", "PDBnoneOfTheAbove", J.i18n.GT.$ ("None of the above"), "selectNone", J.i18n.GT.$ ("None"), "stereoNone", null, "labelNone", null, "nonpolar", J.i18n.GT.$ ("Nonpolar Residues"), "PDBnucleicMenu", J.i18n.GT.$ ("Nucleic"), "atomNone", J.i18n.GT.$ ("Off"), "bondNone", null, "hbondNone", null, "ssbondNone", null, "structureNone", null, "vibrationOff", null, "vectorOff", null, "spinOff", null, "pickOff", null, "surfOff", null, "olive", J.i18n.GT.$ ("Olive"), "bondWireframe", J.i18n.GT.$ ("On"), "hbondWireframe", null, "ssbondWireframe", null, "vibrationOn", null, "vectorOn", null, "spinOn", null, "on", null, "SIGNEDloadPdb", J.i18n.GT.$ ("Open from PDB"), "SIGNEDloadFile", J.i18n.GT.$ ("Open local file"), "SIGNEDloadScript", J.i18n.GT.$ ("Open script"), "SIGNEDloadUrl", J.i18n.GT.$ ("Open URL"), "minimize", J.i18n.GT.$ ("Optimize structure"), "orange", J.i18n.GT.$ ("Orange"), "orchid", J.i18n.GT.$ ("Orchid"), "showOrient", J.i18n.GT.$ ("Orientation"), "palindrome", J.i18n.GT.$ ("Palindrome"), "partialcharge", J.i18n.GT.$ ("Partial Charge"), "pause", J.i18n.GT.$ ("Pause"), "perspectiveDepthCB", J.i18n.GT.$ ("Perspective Depth"), "byPixelMenu", J.i18n.GT.$ ("Pixel Width"), "onceThrough", J.i18n.GT.$ ("Play Once"), "play", J.i18n.GT.$ ("Play"), "polar", J.i18n.GT.$ ("Polar Residues"), "polymersText", J.i18n.GT.$ ("polymers: {0}"), "labelPositionMenu", J.i18n.GT.$ ("Position Label on Atom"), "prevframe", J.i18n.GT.$ ("Previous Frame"), "PDBproteinMenu", J.i18n.GT.$ ("Protein"), "colorrasmolCB", J.i18n.GT.$ ("RasMol Colors"), "red", J.i18n.GT.$ ("Red"), "stereoRedBlue", J.i18n.GT.$ ("Red+Blue glasses"), "stereoRedCyan", J.i18n.GT.$ ("Red+Cyan glasses"), "stereoRedGreen", J.i18n.GT.$ ("Red+Green glasses"), "SIGNEDJAVAcaptureOn", J.i18n.GT.$ ("Re-enable capturing"), "FILEUNITninePoly", J.i18n.GT.$ ("Reload + Polyhedra"), "reload", J.i18n.GT.$ ("Reload"), "restart", J.i18n.GT.$ ("Restart"), "resume", J.i18n.GT.$ ("Resume"), "playrev", J.i18n.GT.$ ("Reverse"), "rewind", J.i18n.GT.$ ("Rewind"), "ribbons", J.i18n.GT.$ ("Ribbons"), "[color_ribbon]sMenu", null, "right", J.i18n.GT.$ ("Right"), "RNA", J.i18n.GT.$ ("RNA"), "rockets", J.i18n.GT.$ ("Rockets"), "[color_rockets]Menu", null, "salmon", J.i18n.GT.$ ("Salmon"), "writeFileTextVARIABLE", J.i18n.GT.$ ("Save a copy of {0}"), "SIGNEDwriteJmol", J.i18n.GT.$ ("Save as PNG/JMOL (image+zip)"), "SIGNEDwriteIsosurface", J.i18n.GT.$ ("Save JVXL isosurface"), "writeHistory", J.i18n.GT.$ ("Save script with history"), "writeState", J.i18n.GT.$ ("Save script with state"), "saveMenu", J.i18n.GT.$ ("Save"), "sceneComputedMenu", J.i18n.GT.$ ("Scenes"), "renderSchemeMenu", J.i18n.GT.$ ("Scheme"), "aaStructureMenu", J.i18n.GT.$ ("Secondary Structure"), "structure#PDB", null, "selectMenuText", J.i18n.GT.$ ("Select ({0})"), "pickAtom", J.i18n.GT.$ ("Select atom"), "PDBpickChain", J.i18n.GT.$ ("Select chain"), "pickElement", J.i18n.GT.$ ("Select element"), "PDBpickGroup", J.i18n.GT.$ ("Select group"), "pickMolecule", J.i18n.GT.$ ("Select molecule"), "SYMMETRYpickSite", J.i18n.GT.$ ("Select site"), "showSelectionsCB", J.i18n.GT.$ ("Selection Halos"), "SIGNEDJAVAcaptureFpsSPECIAL", J.i18n.GT.$ ("Set capture replay rate"), "[set_spin_FPS]Menu", J.i18n.GT.$ ("Set FPS"), "FRAMESanimFpsMenu", null, "PDBhbondBackbone", J.i18n.GT.$ ("Set H-Bonds Backbone"), "PDBhbondSidechain", J.i18n.GT.$ ("Set H-Bonds Side Chain"), "pickingMenu", J.i18n.GT.$ ("Set picking"), "PDBssbondBackbone", J.i18n.GT.$ ("Set SS-Bonds Backbone"), "PDBssbondSidechain", J.i18n.GT.$ ("Set SS-Bonds Side Chain"), "[set_spin_X]Menu", J.i18n.GT.$ ("Set X Rate"), "[set_spin_Y]Menu", J.i18n.GT.$ ("Set Y Rate"), "[set_spin_Z]Menu", J.i18n.GT.$ ("Set Z Rate"), "shapely#PDB", J.i18n.GT.$ ("Shapely"), "showHydrogensCB", J.i18n.GT.$ ("Show Hydrogens"), "showMeasurementsCB", J.i18n.GT.$ ("Show Measurements"), "SYMMETRYpickSymmetry", J.i18n.GT.$ ("Show symmetry operation"), "showMenu", J.i18n.GT.$ ("Show"), "proteinSideChains", J.i18n.GT.$ ("Side Chains"), "slateblue", J.i18n.GT.$ ("Slate Blue"), "SYMMETRYShowComputedMenu", J.i18n.GT.$ ("Space Group"), "showSpacegroup", null, "spectraMenu", J.i18n.GT.$ ("Spectra"), "spinMenu", J.i18n.GT.$ ("Spin"), "pickSpin", null, "SIGNEDJAVAcaptureBegin", J.i18n.GT.$ ("Start capturing"), "stereoMenu", J.i18n.GT.$ ("Stereographic"), "renderSticks", J.i18n.GT.$ ("Sticks"), "stop", J.i18n.GT.$ ("Stop"), "strands", J.i18n.GT.$ ("Strands"), "[color_strands]Menu", null, "PDBstructureMenu", J.i18n.GT.$ ("Structures"), "colorPDBStructuresMenu", null, "renderMenu", J.i18n.GT.$ ("Style"), "[color_isosurface]Menu", J.i18n.GT.$ ("Surfaces"), "surfaceMenu", null, "SYMMETRYSelectComputedMenu", J.i18n.GT.$ ("Symmetry"), "SYMMETRYshowSymmetry", null, "FILEUNITMenu", null, "systemMenu", J.i18n.GT.$ ("System"), "relativeTemperature#BFACTORS", J.i18n.GT.$ ("Temperature (Relative)"), "fixedTemperature#BFACTORS", J.i18n.GT.$ ("Temperature (Fixed)"), "SIGNEDJAVAcaptureLoopingSPECIAL", J.i18n.GT.$ ("Toggle capture looping"), "top", JU.PT.split (J.i18n.GT.$ ("Top[as in \"view from the top, from above\" - (translators: remove this bracketed part]"), "[")[0], "PDBrenderTraceOnly", J.i18n.GT.$ ("Trace"), "trace", null, "[color_trace]Menu", null, "translations", J.i18n.GT.$ ("Translations"), "noCharge", J.i18n.GT.$ ("Uncharged Residues"), "[color_UNITCELL]Menu", J.i18n.GT.$ ("Unit cell"), "UNITCELLshow", null, "[set_UNITCELL]Menu", null, "showUNITCELLCB", null, "labelUpperLeft", J.i18n.GT.$ ("Upper Left"), "labelUpperRight", J.i18n.GT.$ ("Upper Right"), "surfVDW", J.i18n.GT.$ ("van der Waals Surface"), "VIBRATIONvectorMenu", J.i18n.GT.$ ("Vectors"), "property_vxyz#VIBRATION", null, "[color_vectors]Menu", null, "VIBRATIONMenu", J.i18n.GT.$ ("Vibration"), "viewMenuText", J.i18n.GT.$ ("View {0}"), "viewMenu", J.i18n.GT.$ ("View"), "violet", J.i18n.GT.$ ("Violet"), "stereoWallEyed", J.i18n.GT.$ ("Wall-eyed viewing"), "white", J.i18n.GT.$ ("White"), "renderWireframe", J.i18n.GT.$ ("Wireframe"), "labelName", J.i18n.GT.$ ("With Atom Name"), "labelNumber", J.i18n.GT.$ ("With Atom Number"), "labelSymbol", J.i18n.GT.$ ("With Element Symbol"), "yellow", J.i18n.GT.$ ("Yellow"), "zoomIn", J.i18n.GT.$ ("Zoom In"), "zoomOut", J.i18n.GT.$ ("Zoom Out"), "zoomMenu", J.i18n.GT.$ ("Zoom"), "vector005", J.i18n.GT.o (ang, "0.05"), "bond100", J.i18n.GT.o (ang, "0.10"), "hbond100", null, "ssbond100", null, "vector01", null, "10a", null, "bond150", J.i18n.GT.o (ang, "0.15"), "hbond150", null, "ssbond150", null, "bond200", J.i18n.GT.o (ang, "0.20"), "hbond200", null, "ssbond200", null, "20a", null, "bond250", J.i18n.GT.o (ang, "0.25"), "hbond250", null, "ssbond250", null, "25a", null, "bond300", J.i18n.GT.o (ang, "0.30"), "hbond300", null, "ssbond300", null, "50a", J.i18n.GT.o (ang, "0.50"), "100a", J.i18n.GT.o (ang, "1.0"), "1p", J.i18n.GT.i (pxl, 1), "10p", J.i18n.GT.i (pxl, 10), "3p", J.i18n.GT.i (pxl, 3), "vector3", null, "5p", J.i18n.GT.i (pxl, 5), "atom100", J.i18n.GT.i (vdw, 100), "atom15", J.i18n.GT.i (vdw, 15), "atom20", J.i18n.GT.i (vdw, 20), "atom25", J.i18n.GT.i (vdw, 25), "atom50", J.i18n.GT.i (vdw, 50), "atom75", J.i18n.GT.i (vdw, 75), "SIGNEDNOGLwriteIdtf", J.i18n.GT.o (exm, "IDTF"), "SIGNEDNOGLwriteMaya", J.i18n.GT.o (exm, "Maya"), "SIGNEDNOGLwriteVrml", J.i18n.GT.o (exm, "VRML"), "SIGNEDNOGLwriteX3d", J.i18n.GT.o (exm, "X3D"), "SIGNEDNOGLwriteSTL", J.i18n.GT.o (exm, "STL"), "SIGNEDNOGLwriteGif", J.i18n.GT.o (exi, "GIF"), "SIGNEDNOGLwriteJpg", J.i18n.GT.o (exi, "JPG"), "SIGNEDNOGLwritePng", J.i18n.GT.o (exi, "PNG"), "SIGNEDNOGLwritePngJmol", J.i18n.GT.o (exi, "PNG+JMOL"), "SIGNEDNOGLwritePovray", J.i18n.GT.o (exi, "POV-Ray"), "FILEUNITnineRestricted", J.i18n.GT.o (J.i18n.GT.$ ("Reload {0} + Display {1}"),  Clazz.newArray (-1, ["{444 666 1}", "555"])), "FILEMOLload", J.i18n.GT.o (rld, "(molecular)"), "FILEUNITone", J.i18n.GT.o (rld, "{1 1 1}"), "FILEUNITnine", J.i18n.GT.o (rld, "{444 666 1}"), "vectorScale02", J.i18n.GT.o (scl, "0.2"), "vectorScale05", J.i18n.GT.o (scl, "0.5"), "vectorScale1", J.i18n.GT.o (scl, "1"), "vectorScale2", J.i18n.GT.o (scl, "2"), "vectorScale5", J.i18n.GT.o (scl, "5"), "surfSolvent14", J.i18n.GT.o (J.i18n.GT.$ ("Solvent Surface ({0}-Angstrom probe)"), "1.4"), "surfSolventAccessible14", J.i18n.GT.o (J.i18n.GT.$ ("Solvent-Accessible Surface (VDW + {0} Angstrom)"), "1.4"), "vibration20", "*2", "vibration05", "/2", "JAVAmemTotal", "?", "JAVAmemMax", null, "JAVAprocessors", null, "s0", "0", "animfps10", "10", "s10", null, "zoom100", "100%", "zoom150", "150%", "animfps20", "20", "s20", null, "zoom200", "200%", "animfps30", "30", "s30", null, "s40", "40", "zoom400", "400%", "animfps5", "5", "s5", null, "animfps50", "50", "s50", null, "zoom50", "50%", "zoom800", "800%", "JSConsole", "JavaScript Console", "jmolMenu", "Jmol", "date", JV.JC.date, "version", JV.JC.version, "javaVender", JV.Viewer.strJavaVendor, "javaVersion", JV.Viewer.strJavaVersion, "os", JV.Viewer.strOSName, "jmolorg", "http://www.jmol.org"]);
J.i18n.GT.setDoTranslate (wasTranslating);
for (var i = 1, n = words.length; i < n; i += 2) if (words[i] == null) words[i] = words[i - 2];

return words;
});
Clazz.overrideMethod (c$, "getMenuAsText", 
function (title) {
return this.getStuctureAsText (title, J.popup.MainPopupResourceBundle.menuContents, J.popup.MainPopupResourceBundle.structureContents);
}, "~S");
Clazz.defineStatics (c$,
"MENU_NAME", "popupMenu");
c$.menuContents = c$.prototype.menuContents =  Clazz.newArray (-1, [ Clazz.newArray (-1, ["@COLOR", "black darkgray lightgray white - red orange yellow green cyan blue indigo violet"]),  Clazz.newArray (-1, ["@AXESCOLOR", "gray salmon maroon olive slateblue gold orchid"]),  Clazz.newArray (-1, ["popupMenu", "fileMenu modelSetMenu FRAMESbyModelComputedMenu configurationComputedMenu - selectMenuText viewMenu renderMenu colorMenu - surfaceMenu FILEUNITMenu - sceneComputedMenu zoomMenu spinMenu VIBRATIONMenu spectraMenu FRAMESanimateMenu - measureMenu pickingMenu - showConsole JSConsole showMenu computationMenu - languageComputedMenu aboutMenu"]),  Clazz.newArray (-1, ["fileMenu", "loadMenu saveMenu exportMenu SIGNEDJAVAcaptureMenuSPECIAL "]),  Clazz.newArray (-1, ["loadMenu", "SIGNEDloadFile SIGNEDloadUrl SIGNEDloadPdb SIGNEDloadScript - reload SIGNEDloadFileUnitCell"]),  Clazz.newArray (-1, ["saveMenu", "writeFileTextVARIABLE writeState writeHistory SIGNEDwriteJmol SIGNEDwriteIsosurface "]),  Clazz.newArray (-1, ["exportMenu", "SIGNEDNOGLwriteGif SIGNEDNOGLwriteJpg SIGNEDNOGLwritePng SIGNEDNOGLwritePngJmol SIGNEDNOGLwritePovray - SIGNEDNOGLwriteVrml SIGNEDNOGLwriteX3d SIGNEDNOGLwriteSTL"]),  Clazz.newArray (-1, ["selectMenuText", "hideNotSelectedCB showSelectionsCB - selectAll selectNone invertSelection - elementsComputedMenu SYMMETRYSelectComputedMenu - PDBproteinMenu PDBnucleicMenu PDBheteroMenu PDBcarboMenu PDBnoneOfTheAbove"]),  Clazz.newArray (-1, ["PDBproteinMenu", "PDBaaResiduesComputedMenu - allProtein proteinBackbone proteinSideChains - polar nonpolar - positiveCharge negativeCharge noCharge"]),  Clazz.newArray (-1, ["PDBcarboMenu", "PDBcarboResiduesComputedMenu - allCarbo"]),  Clazz.newArray (-1, ["PDBnucleicMenu", "PDBnucleicResiduesComputedMenu - allNucleic nucleicBackbone nucleicBases - DNA RNA - atPairs auPairs gcPairs - aaStructureMenu"]),  Clazz.newArray (-1, ["PDBheteroMenu", "PDBheteroComputedMenu - allHetero Solvent Water - Ligand exceptWater nonWaterSolvent"]),  Clazz.newArray (-1, ["viewMenu", "best front left right top bottom back - axisX axisY axisZ - axisA axisB axisC"]),  Clazz.newArray (-1, ["renderMenu", "renderSchemeMenu - atomMenu labelMenu bondMenu hbondMenu ssbondMenu - PDBstructureMenu - [set_axes]Menu [set_boundbox]Menu [set_UNITCELL]Menu - perspectiveDepthCB stereoMenu"]),  Clazz.newArray (-1, ["renderSchemeMenu", "renderCpkSpacefill renderBallAndStick renderSticks renderWireframe PDBrenderCartoonsOnly PDBrenderTraceOnly"]),  Clazz.newArray (-1, ["atomMenu", "showHydrogensCB - atomNone - atom15 atom20 atom25 atom50 atom75 atom100"]),  Clazz.newArray (-1, ["bondMenu", "bondNone bondWireframe - bond100 bond150 bond200 bond250 bond300"]),  Clazz.newArray (-1, ["hbondMenu", "hbondCalc hbondNone hbondWireframe - PDBhbondSidechain PDBhbondBackbone - hbond100 hbond150 hbond200 hbond250 hbond300"]),  Clazz.newArray (-1, ["ssbondMenu", "ssbondNone ssbondWireframe - PDBssbondSidechain PDBssbondBackbone - ssbond100 ssbond150 ssbond200 ssbond250 ssbond300"]),  Clazz.newArray (-1, ["PDBstructureMenu", "structureNone - backbone cartoon cartoonRockets ribbons rockets strands trace"]),  Clazz.newArray (-1, ["VIBRATIONvectorMenu", "vectorOff vectorOn vibScale20 vibScale05 vector3 vector005 vector01 - vectorScale02 vectorScale05 vectorScale1 vectorScale2 vectorScale5"]),  Clazz.newArray (-1, ["stereoMenu", "stereoNone stereoRedCyan stereoRedBlue stereoRedGreen stereoCrossEyed stereoWallEyed"]),  Clazz.newArray (-1, ["labelMenu", "labelNone - labelSymbol labelName labelNumber - labelPositionMenu"]),  Clazz.newArray (-1, ["labelPositionMenu", "labelCentered labelUpperRight labelLowerRight labelUpperLeft labelLowerLeft"]),  Clazz.newArray (-1, ["colorMenu", "colorrasmolCB [color_]schemeMenu - [color_atoms]Menu [color_bonds]Menu [color_hbonds]Menu [color_ssbonds]Menu colorPDBStructuresMenu [color_isosurface]Menu - [color_labels]Menu [color_vectors]Menu - [color_axes]Menu [color_boundbox]Menu [color_UNITCELL]Menu [color_background]Menu"]),  Clazz.newArray (-1, ["[color_atoms]Menu", "schemeMenu - @COLOR - opaque translucent"]),  Clazz.newArray (-1, ["[color_bonds]Menu", "none - @COLOR - opaque translucent"]),  Clazz.newArray (-1, ["[color_hbonds]Menu", null]),  Clazz.newArray (-1, ["[color_ssbonds]Menu", null]),  Clazz.newArray (-1, ["[color_labels]Menu", null]),  Clazz.newArray (-1, ["[color_vectors]Menu", null]),  Clazz.newArray (-1, ["[color_backbone]Menu", "none - schemeMenu - @COLOR - opaque translucent"]),  Clazz.newArray (-1, ["[color_cartoon]sMenu", null]),  Clazz.newArray (-1, ["[color_ribbon]sMenu", null]),  Clazz.newArray (-1, ["[color_rockets]Menu", null]),  Clazz.newArray (-1, ["[color_strands]Menu", null]),  Clazz.newArray (-1, ["[color_trace]Menu", null]),  Clazz.newArray (-1, ["[color_background]Menu", "@COLOR"]),  Clazz.newArray (-1, ["[color_isosurface]Menu", "@COLOR - opaque translucent"]),  Clazz.newArray (-1, ["[color_axes]Menu", "@AXESCOLOR"]),  Clazz.newArray (-1, ["[color_boundbox]Menu", null]),  Clazz.newArray (-1, ["[color_UNITCELL]Menu", null]),  Clazz.newArray (-1, ["colorPDBStructuresMenu", "[color_backbone]Menu [color_cartoon]sMenu [color_ribbon]sMenu [color_rockets]Menu [color_strands]Menu [color_trace]Menu"]),  Clazz.newArray (-1, ["schemeMenu", "cpk molecule formalcharge partialcharge - altloc#PDB amino#PDB chain#PDB group#PDB monomer#PDB shapely#PDB structure#PDB relativeTemperature#BFACTORS fixedTemperature#BFACTORS property_vxyz#VIBRATION"]),  Clazz.newArray (-1, ["[color_]schemeMenu", null]),  Clazz.newArray (-1, ["zoomMenu", "zoom50 zoom100 zoom150 zoom200 zoom400 zoom800 - zoomIn zoomOut"]),  Clazz.newArray (-1, ["spinMenu", "spinOn spinOff - [set_spin_X]Menu [set_spin_Y]Menu [set_spin_Z]Menu - [set_spin_FPS]Menu"]),  Clazz.newArray (-1, ["VIBRATIONMenu", "vibrationOff vibrationOn vibration20 vibration05 VIBRATIONvectorMenu"]),  Clazz.newArray (-1, ["spectraMenu", "hnmrMenu cnmrMenu"]),  Clazz.newArray (-1, ["FRAMESanimateMenu", "animModeMenu - play pause resume stop - nextframe prevframe rewind - playrev restart - FRAMESanimFpsMenu"]),  Clazz.newArray (-1, ["FRAMESanimFpsMenu", "animfps5 animfps10 animfps20 animfps30 animfps50"]),  Clazz.newArray (-1, ["measureMenu", "showMeasurementsCB - measureOff measureDistance measureAngle measureTorsion PDBmeasureSequence - measureDelete measureList - distanceNanometers distanceAngstroms distancePicometers"]),  Clazz.newArray (-1, ["pickingMenu", "pickOff pickCenter pickIdent pickLabel pickAtom pickMolecule pickElement - pickSpin - modelKitMode - PDBpickChain PDBpickGroup SYMMETRYpickSite"]),  Clazz.newArray (-1, ["computationMenu", "minimize modelkit"]),  Clazz.newArray (-1, ["showMenu", "showHistory showFile showFileHeader - showOrient showMeasure - showSpacegroup showState SYMMETRYshowSymmetry UNITCELLshow - showIsosurface showMo - extractMOL"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureMenuSPECIAL", "SIGNEDJAVAcaptureRock SIGNEDJAVAcaptureSpin - SIGNEDJAVAcaptureBegin SIGNEDJAVAcaptureEnd SIGNEDJAVAcaptureOff SIGNEDJAVAcaptureOn SIGNEDJAVAcaptureFpsSPECIAL SIGNEDJAVAcaptureLoopingSPECIAL"]),  Clazz.newArray (-1, ["[set_spin_X]Menu", "s0 s5 s10 s20 s30 s40 s50"]),  Clazz.newArray (-1, ["[set_spin_Y]Menu", null]),  Clazz.newArray (-1, ["[set_spin_Z]Menu", null]),  Clazz.newArray (-1, ["[set_spin_FPS]Menu", null]),  Clazz.newArray (-1, ["animModeMenu", "onceThrough palindrome loop"]),  Clazz.newArray (-1, ["surfaceMenu", "surfDots surfVDW surfSolventAccessible14 surfSolvent14 surfMolecular surf2MEP surfMEP surfMoComputedMenuText - surfOpaque surfTranslucent surfOff"]),  Clazz.newArray (-1, ["FILEUNITMenu", "SYMMETRYShowComputedMenu FILEMOLload FILEUNITone FILEUNITnine FILEUNITnineRestricted FILEUNITninePoly"]),  Clazz.newArray (-1, ["[set_axes]Menu", "on off#axes dotted - byPixelMenu byAngstromMenu"]),  Clazz.newArray (-1, ["[set_boundbox]Menu", null]),  Clazz.newArray (-1, ["[set_UNITCELL]Menu", null]),  Clazz.newArray (-1, ["byPixelMenu", "1p 3p 5p 10p"]),  Clazz.newArray (-1, ["byAngstromMenu", "10a 20a 25a 50a 100a"]),  Clazz.newArray (-1, ["aboutMenu", "jmolMenu systemMenu"]),  Clazz.newArray (-1, ["jmolMenu", "APPLETid version date - help - mouse translations jmolorg"]),  Clazz.newArray (-1, ["systemMenu", "os javaVender javaVersion JAVAprocessors JAVAmemMax JAVAmemTotal"])]);
c$.structureContents = c$.prototype.structureContents =  Clazz.newArray (-1, [ Clazz.newArray (-1, ["jmolorg", "show url \"http://www.jmol.org\""]),  Clazz.newArray (-1, ["help", "help"]),  Clazz.newArray (-1, ["mouse", "show url \"http://wiki.jmol.org/index.php/Mouse_Manual\""]),  Clazz.newArray (-1, ["translations", "show url \"http://wiki.jmol.org/index.php/Internationalisation\""]),  Clazz.newArray (-1, ["colorrasmolCB", ""]),  Clazz.newArray (-1, ["hideNotSelectedCB", "set hideNotSelected true | set hideNotSelected false; hide(none)"]),  Clazz.newArray (-1, ["perspectiveDepthCB", ""]),  Clazz.newArray (-1, ["showAxesCB", "set showAxes true | set showAxes false;set axesMolecular"]),  Clazz.newArray (-1, ["showBoundBoxCB", ""]),  Clazz.newArray (-1, ["showHydrogensCB", ""]),  Clazz.newArray (-1, ["showMeasurementsCB", ""]),  Clazz.newArray (-1, ["showSelectionsCB", ""]),  Clazz.newArray (-1, ["showUNITCELLCB", ""]),  Clazz.newArray (-1, ["selectAll", "SELECT all"]),  Clazz.newArray (-1, ["selectNone", "SELECT none"]),  Clazz.newArray (-1, ["invertSelection", "SELECT not selected"]),  Clazz.newArray (-1, ["allProtein", "SELECT protein"]),  Clazz.newArray (-1, ["proteinBackbone", "SELECT protein and backbone"]),  Clazz.newArray (-1, ["proteinSideChains", "SELECT protein and not backbone"]),  Clazz.newArray (-1, ["polar", "SELECT protein and polar"]),  Clazz.newArray (-1, ["nonpolar", "SELECT protein and not polar"]),  Clazz.newArray (-1, ["positiveCharge", "SELECT protein and basic"]),  Clazz.newArray (-1, ["negativeCharge", "SELECT protein and acidic"]),  Clazz.newArray (-1, ["noCharge", "SELECT protein and not (acidic,basic)"]),  Clazz.newArray (-1, ["allCarbo", "SELECT carbohydrate"]),  Clazz.newArray (-1, ["allNucleic", "SELECT nucleic"]),  Clazz.newArray (-1, ["DNA", "SELECT dna"]),  Clazz.newArray (-1, ["RNA", "SELECT rna"]),  Clazz.newArray (-1, ["nucleicBackbone", "SELECT nucleic and backbone"]),  Clazz.newArray (-1, ["nucleicBases", "SELECT nucleic and not backbone"]),  Clazz.newArray (-1, ["atPairs", "SELECT a,t"]),  Clazz.newArray (-1, ["gcPairs", "SELECT g,c"]),  Clazz.newArray (-1, ["auPairs", "SELECT a,u"]),  Clazz.newArray (-1, ["A", "SELECT a"]),  Clazz.newArray (-1, ["C", "SELECT c"]),  Clazz.newArray (-1, ["G", "SELECT g"]),  Clazz.newArray (-1, ["T", "SELECT t"]),  Clazz.newArray (-1, ["U", "SELECT u"]),  Clazz.newArray (-1, ["allHetero", "SELECT hetero"]),  Clazz.newArray (-1, ["Solvent", "SELECT solvent"]),  Clazz.newArray (-1, ["Water", "SELECT water"]),  Clazz.newArray (-1, ["nonWaterSolvent", "SELECT solvent and not water"]),  Clazz.newArray (-1, ["exceptWater", "SELECT hetero and not water"]),  Clazz.newArray (-1, ["Ligand", "SELECT ligand"]),  Clazz.newArray (-1, ["PDBnoneOfTheAbove", "SELECT not(hetero,protein,nucleic,carbohydrate)"]),  Clazz.newArray (-1, ["best", "rotate best -1.0"]),  Clazz.newArray (-1, ["front", J.popup.MainPopupResourceBundle.Box ("moveto 2.0 front;delay 1")]),  Clazz.newArray (-1, ["left", J.popup.MainPopupResourceBundle.Box ("moveto 1.0 front;moveto 2.0 left;delay 1")]),  Clazz.newArray (-1, ["right", J.popup.MainPopupResourceBundle.Box ("moveto 1.0 front;moveto 2.0 right;delay 1")]),  Clazz.newArray (-1, ["top", J.popup.MainPopupResourceBundle.Box ("moveto 1.0 front;moveto 2.0 top;delay 1")]),  Clazz.newArray (-1, ["bottom", J.popup.MainPopupResourceBundle.Box ("moveto 1.0 front;moveto 2.0 bottom;delay 1")]),  Clazz.newArray (-1, ["back", J.popup.MainPopupResourceBundle.Box ("moveto 1.0 front;moveto 2.0 back;delay 1")]),  Clazz.newArray (-1, ["axisA", "moveto axis a"]),  Clazz.newArray (-1, ["axisB", "moveto axis b"]),  Clazz.newArray (-1, ["axisC", "moveto axis c"]),  Clazz.newArray (-1, ["axisX", "moveto axis x"]),  Clazz.newArray (-1, ["axisY", "moveto axis y"]),  Clazz.newArray (-1, ["axisZ", "moveto axis z"]),  Clazz.newArray (-1, ["renderCpkSpacefill", "restrict bonds not selected;select not selected;spacefill 100%;color cpk"]),  Clazz.newArray (-1, ["renderBallAndStick", "restrict bonds not selected;select not selected;spacefill 23%AUTO;wireframe 0.15;color cpk"]),  Clazz.newArray (-1, ["renderSticks", "restrict bonds not selected;select not selected;wireframe 0.3;color cpk"]),  Clazz.newArray (-1, ["renderWireframe", "restrict bonds not selected;select not selected;wireframe on;color cpk"]),  Clazz.newArray (-1, ["PDBrenderCartoonsOnly", "restrict bonds not selected;select not selected;cartoons on;color structure"]),  Clazz.newArray (-1, ["PDBrenderTraceOnly", "restrict bonds not selected;select not selected;trace on;color structure"]),  Clazz.newArray (-1, ["atomNone", "cpk off"]),  Clazz.newArray (-1, ["atom15", "cpk 15%"]),  Clazz.newArray (-1, ["atom20", "cpk 20%"]),  Clazz.newArray (-1, ["atom25", "cpk 25%"]),  Clazz.newArray (-1, ["atom50", "cpk 50%"]),  Clazz.newArray (-1, ["atom75", "cpk 75%"]),  Clazz.newArray (-1, ["atom100", "cpk on"]),  Clazz.newArray (-1, ["bondNone", "wireframe off"]),  Clazz.newArray (-1, ["bondWireframe", "wireframe on"]),  Clazz.newArray (-1, ["bond100", "wireframe .1"]),  Clazz.newArray (-1, ["bond150", "wireframe .15"]),  Clazz.newArray (-1, ["bond200", "wireframe .2"]),  Clazz.newArray (-1, ["bond250", "wireframe .25"]),  Clazz.newArray (-1, ["bond300", "wireframe .3"]),  Clazz.newArray (-1, ["hbondCalc", "hbonds calculate"]),  Clazz.newArray (-1, ["hbondNone", "hbonds off"]),  Clazz.newArray (-1, ["hbondWireframe", "hbonds on"]),  Clazz.newArray (-1, ["PDBhbondSidechain", "set hbonds sidechain"]),  Clazz.newArray (-1, ["PDBhbondBackbone", "set hbonds backbone"]),  Clazz.newArray (-1, ["hbond100", "hbonds .1"]),  Clazz.newArray (-1, ["hbond150", "hbonds .15"]),  Clazz.newArray (-1, ["hbond200", "hbonds .2"]),  Clazz.newArray (-1, ["hbond250", "hbonds .25"]),  Clazz.newArray (-1, ["hbond300", "hbonds .3"]),  Clazz.newArray (-1, ["ssbondNone", "ssbonds off"]),  Clazz.newArray (-1, ["ssbondWireframe", "ssbonds on"]),  Clazz.newArray (-1, ["PDBssbondSidechain", "set ssbonds sidechain"]),  Clazz.newArray (-1, ["PDBssbondBackbone", "set ssbonds backbone"]),  Clazz.newArray (-1, ["ssbond100", "ssbonds .1"]),  Clazz.newArray (-1, ["ssbond150", "ssbonds .15"]),  Clazz.newArray (-1, ["ssbond200", "ssbonds .2"]),  Clazz.newArray (-1, ["ssbond250", "ssbonds .25"]),  Clazz.newArray (-1, ["ssbond300", "ssbonds .3"]),  Clazz.newArray (-1, ["structureNone", "backbone off;cartoons off;ribbons off;rockets off;strands off;trace off;"]),  Clazz.newArray (-1, ["backbone", "restrict not selected;select not selected;backbone 0.3"]),  Clazz.newArray (-1, ["cartoon", "restrict not selected;select not selected;set cartoonRockets false;cartoons on"]),  Clazz.newArray (-1, ["cartoonRockets", "restrict not selected;select not selected;set cartoonRockets;cartoons on"]),  Clazz.newArray (-1, ["ribbons", "restrict not selected;select not selected;ribbons on"]),  Clazz.newArray (-1, ["rockets", "restrict not selected;select not selected;rockets on"]),  Clazz.newArray (-1, ["strands", "restrict not selected;select not selected;strands on"]),  Clazz.newArray (-1, ["trace", "restrict not selected;select not selected;trace 0.3"]),  Clazz.newArray (-1, ["vibrationOff", "vibration off"]),  Clazz.newArray (-1, ["vibrationOn", "vibration on"]),  Clazz.newArray (-1, ["vibration20", "vibrationScale *= 2"]),  Clazz.newArray (-1, ["vibration05", "vibrationScale /= 2"]),  Clazz.newArray (-1, ["vectorOff", "vectors off"]),  Clazz.newArray (-1, ["vectorOn", "vectors on"]),  Clazz.newArray (-1, ["vector3", "vectors 3"]),  Clazz.newArray (-1, ["vector005", "vectors 0.05"]),  Clazz.newArray (-1, ["vector01", "vectors 0.1"]),  Clazz.newArray (-1, ["vectorScale02", "vector scale 0.2"]),  Clazz.newArray (-1, ["vectorScale05", "vector scale 0.5"]),  Clazz.newArray (-1, ["vectorScale1", "vector scale 1"]),  Clazz.newArray (-1, ["vectorScale2", "vector scale 2"]),  Clazz.newArray (-1, ["vectorScale5", "vector scale 5"]),  Clazz.newArray (-1, ["stereoNone", "stereo off"]),  Clazz.newArray (-1, ["stereoRedCyan", "stereo redcyan 3"]),  Clazz.newArray (-1, ["stereoRedBlue", "stereo redblue 3"]),  Clazz.newArray (-1, ["stereoRedGreen", "stereo redgreen 3"]),  Clazz.newArray (-1, ["stereoCrossEyed", "stereo -5"]),  Clazz.newArray (-1, ["stereoWallEyed", "stereo 5"]),  Clazz.newArray (-1, ["labelNone", "label off"]),  Clazz.newArray (-1, ["labelSymbol", "label %e"]),  Clazz.newArray (-1, ["labelName", "label %a"]),  Clazz.newArray (-1, ["labelNumber", "label %i"]),  Clazz.newArray (-1, ["labelCentered", "set labeloffset 0 0"]),  Clazz.newArray (-1, ["labelUpperRight", "set labeloffset 4 4"]),  Clazz.newArray (-1, ["labelLowerRight", "set labeloffset 4 -4"]),  Clazz.newArray (-1, ["labelUpperLeft", "set labeloffset -4 4"]),  Clazz.newArray (-1, ["labelLowerLeft", "set labeloffset -4 -4"]),  Clazz.newArray (-1, ["zoom50", "zoom 50"]),  Clazz.newArray (-1, ["zoom100", "zoom 100"]),  Clazz.newArray (-1, ["zoom150", "zoom 150"]),  Clazz.newArray (-1, ["zoom200", "zoom 200"]),  Clazz.newArray (-1, ["zoom400", "zoom 400"]),  Clazz.newArray (-1, ["zoom800", "zoom 800"]),  Clazz.newArray (-1, ["zoomIn", "move 0 0 0 40 0 0 0 0 1"]),  Clazz.newArray (-1, ["zoomOut", "move 0 0 0 -40 0 0 0 0 1"]),  Clazz.newArray (-1, ["spinOn", "spin on"]),  Clazz.newArray (-1, ["spinOff", "spin off"]),  Clazz.newArray (-1, ["s0", "0"]),  Clazz.newArray (-1, ["s5", "5"]),  Clazz.newArray (-1, ["s10", "10"]),  Clazz.newArray (-1, ["s20", "20"]),  Clazz.newArray (-1, ["s30", "30"]),  Clazz.newArray (-1, ["s40", "40"]),  Clazz.newArray (-1, ["s50", "50"]),  Clazz.newArray (-1, ["onceThrough", "anim mode once#"]),  Clazz.newArray (-1, ["palindrome", "anim mode palindrome#"]),  Clazz.newArray (-1, ["loop", "anim mode loop#"]),  Clazz.newArray (-1, ["play", "anim play#"]),  Clazz.newArray (-1, ["pause", "anim pause#"]),  Clazz.newArray (-1, ["resume", "anim resume#"]),  Clazz.newArray (-1, ["stop", "anim off#"]),  Clazz.newArray (-1, ["nextframe", "frame next#"]),  Clazz.newArray (-1, ["prevframe", "frame prev#"]),  Clazz.newArray (-1, ["playrev", "anim playrev#"]),  Clazz.newArray (-1, ["rewind", "anim rewind#"]),  Clazz.newArray (-1, ["restart", "anim on#"]),  Clazz.newArray (-1, ["animfps5", "anim fps 5#"]),  Clazz.newArray (-1, ["animfps10", "anim fps 10#"]),  Clazz.newArray (-1, ["animfps20", "anim fps 20#"]),  Clazz.newArray (-1, ["animfps30", "anim fps 30#"]),  Clazz.newArray (-1, ["animfps50", "anim fps 50#"]),  Clazz.newArray (-1, ["measureOff", "set pickingstyle MEASURE OFF; set picking OFF"]),  Clazz.newArray (-1, ["measureDistance", "set pickingstyle MEASURE; set picking MEASURE DISTANCE"]),  Clazz.newArray (-1, ["measureAngle", "set pickingstyle MEASURE; set picking MEASURE ANGLE"]),  Clazz.newArray (-1, ["measureTorsion", "set pickingstyle MEASURE; set picking MEASURE TORSION"]),  Clazz.newArray (-1, ["PDBmeasureSequence", "set pickingstyle MEASURE; set picking MEASURE SEQUENCE"]),  Clazz.newArray (-1, ["measureDelete", "measure delete"]),  Clazz.newArray (-1, ["measureList", "console on;show measurements"]),  Clazz.newArray (-1, ["distanceNanometers", "select *; set measure nanometers"]),  Clazz.newArray (-1, ["distanceAngstroms", "select *; set measure angstroms"]),  Clazz.newArray (-1, ["distancePicometers", "select *; set measure picometers"]),  Clazz.newArray (-1, ["pickOff", "set picking off"]),  Clazz.newArray (-1, ["pickCenter", "set picking center"]),  Clazz.newArray (-1, ["pickIdent", "set picking ident"]),  Clazz.newArray (-1, ["pickLabel", "set picking label"]),  Clazz.newArray (-1, ["pickAtom", "set picking atom"]),  Clazz.newArray (-1, ["PDBpickChain", "set picking chain"]),  Clazz.newArray (-1, ["pickElement", "set picking element"]),  Clazz.newArray (-1, ["modelKitMode", "set modelKitMode"]),  Clazz.newArray (-1, ["PDBpickGroup", "set picking group"]),  Clazz.newArray (-1, ["pickMolecule", "set picking molecule"]),  Clazz.newArray (-1, ["SYMMETRYpickSite", "set picking site"]),  Clazz.newArray (-1, ["pickSpin", "set picking spin"]),  Clazz.newArray (-1, ["SYMMETRYpickSymmetry", "set picking symmetry"]),  Clazz.newArray (-1, ["showConsole", "console"]),  Clazz.newArray (-1, ["JSConsole", "JSCONSOLE"]),  Clazz.newArray (-1, ["showFile", "console on;show file"]),  Clazz.newArray (-1, ["showFileHeader", "console on;getProperty FileHeader"]),  Clazz.newArray (-1, ["showHistory", "console on;show history"]),  Clazz.newArray (-1, ["showIsosurface", "console on;show isosurface"]),  Clazz.newArray (-1, ["showMeasure", "console on;show measure"]),  Clazz.newArray (-1, ["showMo", "console on;show mo"]),  Clazz.newArray (-1, ["showModel", "console on;show model"]),  Clazz.newArray (-1, ["showOrient", "console on;show orientation"]),  Clazz.newArray (-1, ["showSpacegroup", "console on;show spacegroup"]),  Clazz.newArray (-1, ["showState", "console on;show state"]),  Clazz.newArray (-1, ["reload", "load \"\""]),  Clazz.newArray (-1, ["SIGNEDloadPdb", "load ?PdbId?"]),  Clazz.newArray (-1, ["SIGNEDloadFile", "load ?"]),  Clazz.newArray (-1, ["SIGNEDloadUrl", "load http://?"]),  Clazz.newArray (-1, ["SIGNEDloadFileUnitCell", "load ? {1 1 1}"]),  Clazz.newArray (-1, ["SIGNEDloadScript", "script ?.spt"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureRock", "animation mode loop;capture '?Jmol.gif' rock y 10"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureSpin", "animation mode loop;capture '?Jmol.gif' spin y"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureBegin", "capture '?Jmol.gif'"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureEnd", "capture ''"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureOff", "capture off"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureOn", "capture on"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureFpsSPECIAL", "animation fps @{0+prompt('Capture replay frames per second?', animationFPS)};prompt 'animation FPS ' + animationFPS"]),  Clazz.newArray (-1, ["SIGNEDJAVAcaptureLoopingSPECIAL", "animation mode @{(animationMode=='ONCE' ? 'LOOP':'ONCE')};prompt 'animation MODE ' + animationMode"]),  Clazz.newArray (-1, ["writeFileTextVARIABLE", "if (_applet && !_signedApplet) { console;show file } else { write file \"?FILE?\"}"]),  Clazz.newArray (-1, ["writeState", "if (_applet && !_signedApplet) { console;show state } else { write state \"?FILEROOT?.spt\"}"]),  Clazz.newArray (-1, ["writeHistory", "if (_applet && !_signedApplet) { console;show history } else { write history \"?FILEROOT?.his\"}"]),  Clazz.newArray (-1, ["SIGNEDwriteJmol", "write PNGJ \"?FILEROOT?.png\""]),  Clazz.newArray (-1, ["SIGNEDwriteIsosurface", "write isosurface \"?FILEROOT?.jvxl\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteGif", "write image \"?FILEROOT?.gif\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteJpg", "write image \"?FILEROOT?.jpg\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwritePng", "write image \"?FILEROOT?.png\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwritePngJmol", "write PNGJ \"?FILEROOT?.png\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwritePovray", "write POVRAY \"?FILEROOT?.pov\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteVrml", "write VRML \"?FILEROOT?.wrl\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteX3d", "write X3D \"?FILEROOT?.x3d\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteSTL", "write STL \"?FILEROOT?.stl\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteIdtf", "write IDTF \"?FILEROOT?.idtf\""]),  Clazz.newArray (-1, ["SIGNEDNOGLwriteMaya", "write MAYA \"?FILEROOT?.ma\""]),  Clazz.newArray (-1, ["SYMMETRYshowSymmetry", "console on;show symmetry"]),  Clazz.newArray (-1, ["UNITCELLshow", "console on;show unitcell"]),  Clazz.newArray (-1, ["extractMOL", "console on;getproperty extractModel \"visible\" "]),  Clazz.newArray (-1, ["minimize", "minimize"]),  Clazz.newArray (-1, ["modelkit", "set modelkitmode"]),  Clazz.newArray (-1, ["surfDots", "dots on"]),  Clazz.newArray (-1, ["surfVDW", "isosurface delete resolution 0 solvent 0 translucent"]),  Clazz.newArray (-1, ["surfMolecular", "isosurface delete resolution 0 molecular translucent"]),  Clazz.newArray (-1, ["surfSolvent14", "isosurface delete resolution 0 solvent 1.4 translucent"]),  Clazz.newArray (-1, ["surfSolventAccessible14", "isosurface delete resolution 0 sasurface 1.4 translucent"]),  Clazz.newArray (-1, ["surfMEP", "isosurface delete resolution 0 vdw color range all map MEP translucent"]),  Clazz.newArray (-1, ["surf2MEP", "isosurface delete resolution 0 vdw color range -0.1 0.1 map MEP translucent"]),  Clazz.newArray (-1, ["surfOpaque", "mo opaque;isosurface opaque"]),  Clazz.newArray (-1, ["surfTranslucent", "mo translucent;isosurface translucent"]),  Clazz.newArray (-1, ["surfOff", "mo delete;isosurface delete;var ~~sel = {selected};select *;dots off;select ~~sel"]),  Clazz.newArray (-1, ["FILEMOLload", "save orientation;load \"\";restore orientation;center"]),  Clazz.newArray (-1, ["FILEUNITone", "save orientation;load \"\" {1 1 1} ;restore orientation;center"]),  Clazz.newArray (-1, ["FILEUNITnine", "save orientation;load \"\" {444 666 1} ;restore orientation;center"]),  Clazz.newArray (-1, ["FILEUNITnineRestricted", "save orientation;load \"\" {444 666 1} ;restore orientation; unitcell on; display cell=555;center visible;zoom 200"]),  Clazz.newArray (-1, ["FILEUNITninePoly", "save orientation;load \"\" {444 666 1} ;restore orientation; unitcell on; display cell=555; polyhedra 4,6 (displayed);center (visible);zoom 200"]),  Clazz.newArray (-1, ["1p", "on"]),  Clazz.newArray (-1, ["3p", "3"]),  Clazz.newArray (-1, ["5p", "5"]),  Clazz.newArray (-1, ["10p", "10"]),  Clazz.newArray (-1, ["10a", "0.1"]),  Clazz.newArray (-1, ["20a", "0.20"]),  Clazz.newArray (-1, ["25a", "0.25"]),  Clazz.newArray (-1, ["50a", "0.50"]),  Clazz.newArray (-1, ["100a", "1.0"])]);
});
