/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

public class CachedFile
implements Closeable {
    protected String name;
    protected long maxAge;
    protected String destDir;
    protected String httpAccept;
    protected CachingStrategy cachingStrategy;
    private boolean fastFail;
    private HttpClient activeConnection;
    protected File cacheFile;
    protected boolean initialized;
    protected String parameter;
    public static final long DEFAULT_MAXTIME = -1L;
    public static final long DAYS = TimeUnit.DAYS.toSeconds(1L);
    private final Map<String, String> httpHeaders = new ConcurrentHashMap<String, String>();

    public CachedFile(String name) {
        this.name = name;
    }

    public CachedFile setName(String name) {
        this.name = name;
        return this;
    }

    public CachedFile setMaxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CachedFile setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public CachedFile setHttpAccept(String httpAccept) {
        this.httpAccept = httpAccept;
        return this;
    }

    public CachedFile setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        return this;
    }

    public CachedFile setHttpHeaders(Map<String, String> headers) {
        this.httpHeaders.putAll(headers);
        return this;
    }

    public void setFastFail(boolean fastFail) {
        this.fastFail = fastFail;
    }

    public void setParam(String parameter) {
        this.parameter = parameter;
    }

    public String getName() {
        if (this.parameter != null) {
            return this.name.replaceAll("%<(.*)>", "");
        }
        return this.name;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getHttpAccept() {
        return this.httpAccept;
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public InputStream getInputStream() throws IOException {
        File file = this.getFile();
        if (file == null) {
            if (this.name != null && this.name.startsWith("resource://")) {
                InputStream is = this.getClass().getResourceAsStream(this.name.substring("resource:/".length()));
                if (is == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", this.name));
                }
                return is;
            }
            throw new IOException("No file found for: " + this.name);
        }
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    public byte[] getByteContent() throws IOException {
        try (InputStream is = this.getInputStream();){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public BufferedReader getContentReader() throws IOException {
        return new BufferedReader(UTFInputStreamReader.create(this.getInputStream()));
    }

    public synchronized File getFile() throws IOException {
        block9: {
            if (this.initialized) {
                return this.cacheFile;
            }
            this.initialized = true;
            try {
                URL url = new URL(this.name);
                if ("file".equals(url.getProtocol())) {
                    this.cacheFile = new File(this.name.substring("file:/".length() - 1));
                    if (!this.cacheFile.exists()) {
                        this.cacheFile = new File(this.name.substring("file://".length() - 1));
                    }
                    break block9;
                }
                try {
                    this.cacheFile = this.checkLocal(url);
                }
                catch (SecurityException e) {
                    throw new IOException(e);
                }
            }
            catch (MalformedURLException e) {
                if (this.name == null || this.name.startsWith("resource://")) {
                    return null;
                }
                this.cacheFile = this.name.startsWith("josmdir://") ? new File(Config.getDirs().getUserDataDirectory(false), this.name.substring("josmdir://".length())) : (this.name.startsWith("josmplugindir://") ? new File(Preferences.main().getPluginsDirectory(), this.name.substring("josmplugindir://".length())) : new File(this.name));
            }
        }
        if (this.cacheFile == null) {
            throw new IOException("Unable to get cache file for " + this.getName());
        }
        return this.cacheFile;
    }

    public String findZipEntryPath(String extension, String namepart) {
        Pair<String, InputStream> ze = this.findZipEntryImpl(extension, namepart);
        if (ze == null) {
            return null;
        }
        return (String)ze.a;
    }

    public InputStream findZipEntryInputStream(String extension, String namepart) {
        Pair<String, InputStream> ze = this.findZipEntryImpl(extension, namepart);
        if (ze == null) {
            return null;
        }
        return (InputStream)ze.b;
    }

    private Pair<String, InputStream> findZipEntryImpl(String extension, String namepart) {
        Pair<String, InputStream> res;
        block8: {
            File file = null;
            try {
                file = this.getFile();
            }
            catch (IOException ex) {
                Logging.log(Logging.LEVEL_WARN, ex);
            }
            if (file == null) {
                return null;
            }
            res = null;
            try {
                ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                ZipEntry resentry = null;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith('.' + extension) || resentry != null && entry.getName().indexOf(namepart) < 0) continue;
                    resentry = entry;
                }
                if (resentry != null) {
                    InputStream is = zipFile.getInputStream(resentry);
                    res = Pair.create(resentry.getName(), is);
                } else {
                    Utils.close(zipFile);
                }
            }
            catch (IOException e) {
                if (!file.getName().endsWith(".zip")) break block8;
                Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", file.getName(), e.toString(), extension, namepart), e);
            }
        }
        return res;
    }

    public static void cleanup(String name) {
        CachedFile.cleanup(name, null);
    }

    public static void cleanup(String name, String destDir) {
        try {
            URL url = new URL(name);
            if (!"file".equals(url.getProtocol())) {
                File lfile;
                String prefKey = CachedFile.getPrefKey(url, destDir);
                ArrayList<String> localPath = new ArrayList<String>(Config.getPref().getList(prefKey));
                if (localPath.size() == 2 && (lfile = new File((String)localPath.get(1))).exists()) {
                    Utils.deleteFile(lfile);
                }
                Config.getPref().putList(prefKey, null);
            }
        }
        catch (MalformedURLException e) {
            Logging.warn(e);
        }
    }

    private static String getPrefKey(URL url, String destDir) {
        StringBuilder prefKey = new StringBuilder("mirror.");
        if (destDir != null) {
            prefKey.append(destDir).append('.');
        }
        prefKey.append(url.toString().replaceAll("%<(.*)>", ""));
        return prefKey.toString().replaceAll("=", "_");
    }

    private File checkLocal(URL url) throws IOException {
        File destDirFile;
        String prefKey = CachedFile.getPrefKey(url, this.destDir);
        String urlStr = url.toExternalForm();
        if (this.parameter != null) {
            urlStr = urlStr.replaceAll("%<(.*)>", "");
        }
        long age = 0L;
        long maxAgeMillis = TimeUnit.SECONDS.toMillis(this.maxAge);
        Long ifModifiedSince = null;
        File localFile = null;
        ArrayList<String> localPathEntry = new ArrayList<String>(Config.getPref().getList(prefKey));
        boolean offline = false;
        try {
            CachedFile.checkOfflineAccess(urlStr);
        }
        catch (OfflineAccessException e) {
            Logging.trace(e);
            offline = true;
        }
        if (localPathEntry.size() == 2) {
            localFile = new File((String)localPathEntry.get(1));
            if (!localFile.exists()) {
                localFile = null;
            } else {
                if (this.maxAge == -1L || this.maxAge <= 0L) {
                    maxAgeMillis = TimeUnit.SECONDS.toMillis(Config.getPref().getLong("mirror.maxtime", TimeUnit.DAYS.toSeconds(7L)));
                }
                age = System.currentTimeMillis() - Long.parseLong((String)localPathEntry.get(0));
                if (offline || age < maxAgeMillis) {
                    return localFile;
                }
                if (this.cachingStrategy == CachingStrategy.IfModifiedSince) {
                    ifModifiedSince = Long.valueOf((String)localPathEntry.get(0));
                }
            }
        }
        if (this.destDir == null) {
            this.destDir = Config.getDirs().getCacheDirectory(true).getPath();
        }
        if (!(destDirFile = new File(this.destDir)).exists()) {
            Utils.mkDirs(destDirFile);
        }
        if (offline) {
            return null;
        }
        if (this.parameter != null) {
            String u = url.toExternalForm();
            String uc = this.parameter.isEmpty() ? u.replaceAll("%<(.*)>", "") : u.replaceAll("%<(.*)>", "$1" + Utils.encodeUrl(this.parameter));
            if (!uc.equals(u)) {
                url = new URL(uc);
            }
        }
        String a = urlStr.replaceAll("[^A-Za-z0-9_.-]", "_");
        String localPath = "mirror_" + a;
        localPath = CachedFile.truncatePath(this.destDir, localPath);
        destDirFile = new File(this.destDir, localPath + ".tmp");
        try {
            this.activeConnection = HttpClient.create(url).setAccept(this.httpAccept).setIfModifiedSince(ifModifiedSince == null ? 0L : ifModifiedSince).setHeaders(this.httpHeaders);
            if (this.fastFail) {
                this.activeConnection.setReadTimeout(1000);
            }
            HttpClient.Response con = this.activeConnection.connect();
            if (ifModifiedSince != null && con.getResponseCode() == 304) {
                Logging.debug("304 Not Modified ({0})", urlStr);
                if (localFile == null) {
                    throw new AssertionError();
                }
                Config.getPref().putList(prefKey, Arrays.asList(Long.toString(System.currentTimeMillis()), (String)localPathEntry.get(1)));
                return localFile;
            }
            if (con.getResponseCode() == 404) {
                throw new IOException(I18n.tr("The requested URL {0} was not found", urlStr));
            }
            try (InputStream is = con.getContent();){
                Files.copy(is, destDirFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.activeConnection = null;
            localFile = new File(this.destDir, localPath);
            if (PlatformManager.getPlatform().rename(destDirFile, localFile)) {
                Config.getPref().putList(prefKey, Arrays.asList(Long.toString(System.currentTimeMillis()), localFile.toString()));
            } else {
                Logging.warn(I18n.tr("Failed to rename file {0} to {1}.", destDirFile.getPath(), localFile.getPath()));
            }
        }
        catch (IOException e) {
            if (age >= maxAgeMillis && age < maxAgeMillis * 2L) {
                Logging.warn(I18n.tr("Failed to load {0}, use cached file and retry next time: {1}", urlStr, e));
                return localFile;
            }
            throw e;
        }
        return localFile;
    }

    private static void checkOfflineAccess(String urlString) {
        OnlineResource.JOSM_WEBSITE.checkOfflineAccess(urlString, Config.getUrls().getJOSMWebsite());
        OnlineResource.OSM_API.checkOfflineAccess(urlString, OsmApi.getOsmApi().getServerUrl());
    }

    private static String truncatePath(String directory, String fileName) {
        if (directory.length() + fileName.length() > 255) {
            if (directory.length() > 191 && PlatformManager.isPlatformWindows()) {
                throw new IllegalArgumentException("Path " + directory + " too long to cached files");
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(fileName.getBytes(StandardCharsets.UTF_8));
                String digest = String.format("%064x", new BigInteger(1, md.digest()));
                return fileName.substring(0, Math.min(fileName.length(), 32)) + digest.substring(0, 32);
            }
            catch (NoSuchAlgorithmException e) {
                Logging.error(e);
                throw new IllegalArgumentException("Missing digest algorithm SHA-256", e);
            }
        }
        return fileName;
    }

    @Override
    public void close() {
        if (this.activeConnection != null) {
            this.activeConnection.disconnect();
        }
    }

    public void clear() throws IOException {
        try {
            URL url = new URL(this.name);
            if ("file".equals(url.getProtocol())) {
                return;
            }
        }
        catch (MalformedURLException e) {
            return;
        }
        File f = this.getFile();
        if (f != null && f.exists()) {
            Utils.deleteFile(f);
        }
    }

    public static enum CachingStrategy {
        MaxAge,
        IfModifiedSince;

    }
}

