/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedPsiElementImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.SharedPsiElementImplUtil");

    private SharedPsiElementImplUtil() {
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset2, @Nullable Language lang) {
        PsiElement element;
        if (thisElement == null) {
            return null;
        }
        PsiElement psiElement = element = lang != null ? thisElement.getContainingFile().getViewProvider().findElementAt(offset2, lang) : thisElement.findElementAt(offset2);
        if (element == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset2 = thisElement.getTextRange().getStartOffset() + offset2 - element.getTextRange().getStartOffset();
        ArrayList referencesList = new ArrayList();
        while (element != null) {
            SharedPsiElementImplUtil.addReferences(offset2, element, referencesList);
            if (element instanceof PsiFile || element instanceof HintedReferenceHost && !((HintedReferenceHost)element).shouldAskParentForReferences(new PsiReferenceService.Hints(null, offset2))) break;
            offset2 = element.getStartOffsetInParent() + offset2;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(PsiReference.EMPTY_ARRAY), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset2) {
        return SharedPsiElementImplUtil.findReferenceAt(thisElement, offset2, null);
    }

    private static void addReferences(int offset2, PsiElement element, Collection<? super PsiReference> outReferences) {
        PsiReference[] references = element instanceof HintedReferenceHost ? ((HintedReferenceHost)element).getReferences(new PsiReferenceService.Hints(null, offset2)) : element.getReferences();
        for (PsiReference reference : references) {
            if (reference == null) {
                LOG.error("Null reference returned from " + element + " of " + element.getClass());
                continue;
            }
            for (TextRange range : ReferenceRange.getRanges(reference)) {
                LOG.assertTrue(range != null, reference);
                if (!range.containsOffset(offset2)) continue;
                outReferences.add(reference);
            }
        }
    }

    @NotNull
    public static PsiReference[] getReferences(PsiElement thisElement) {
        PsiReference ref = thisElement.getReference();
        if (ref == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SharedPsiElementImplUtil.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            SharedPsiElementImplUtil.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement getNextSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement[] children2 = parent2.getChildren();
        int index2 = SharedPsiElementImplUtil.getChildIndex(children2, element);
        return 0 <= index2 && index2 < children2.length - 1 ? children2[index2 + 1] : null;
    }

    @Nullable
    public static PsiElement getPrevSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement[] children2 = parent2.getChildren();
        int index2 = SharedPsiElementImplUtil.getChildIndex(children2, element);
        return index2 > 0 ? children2[index2 - 1] : null;
    }

    private static int getChildIndex(PsiElement[] children2, PsiElement child) {
        for (int i = 0; i < children2.length; ++i) {
            PsiElement candidate2 = children2[i];
            if (candidate2 != child) continue;
            return i;
        }
        LOG.error("Cannot find element among its parent' children. element: '" + child + "'; parent: '" + child.getParent() + "'; children: " + Arrays.asList(children2) + ";  file:" + child.getContainingFile());
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/SharedPsiElementImplUtil", "getReferences"));
    }
}

