/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrDynamicTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.ConstantValueGenerator;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.ScopedTypeParametersResolver;
import org.jetbrains.kotlin.ir.util.TypeParametersResolver;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0018\u0010$\u001a\u00020(2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u0002020-2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040-H\u0002J\u0014\u00105\u001a\u00020'*\u00020'2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeParametersResolver", "Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;", "enterTableScope", "", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;Z)V", "constantValueGenerator", "Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "getConstantValueGenerator", "()Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "setConstantValueGenerator", "(Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeApproximatorForNI", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "buildWithScope", "T", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "builder", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterScope", "", "irElement", "leaveScope", "resolveTypeParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "translateType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ktType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/ir/types/IrTypeProjection;", "ktType0", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "translateTypeAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "translateTypeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "arguments", "Lorg/jetbrains/kotlin/types/TypeProjection;", "approximate", "ir.tree"})
public final class TypeTranslator {
    private final TypeApproximator typeApproximatorForNI;
    @NotNull
    public ConstantValueGenerator constantValueGenerator;
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final TypeParametersResolver typeParametersResolver;
    private final boolean enterTableScope;

    @NotNull
    public final ConstantValueGenerator getConstantValueGenerator() {
        ConstantValueGenerator constantValueGenerator = this.constantValueGenerator;
        if (constantValueGenerator == null) {
            Intrinsics.throwUninitializedPropertyAccessException("constantValueGenerator");
        }
        return constantValueGenerator;
    }

    public final void setConstantValueGenerator(@NotNull ConstantValueGenerator constantValueGenerator) {
        Intrinsics.checkParameterIsNotNull(constantValueGenerator, "<set-?>");
        this.constantValueGenerator = constantValueGenerator;
    }

    public final void enterScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkParameterIsNotNull(irElement, "irElement");
        this.typeParametersResolver.enterTypeParameterScope(irElement);
        if (this.enterTableScope) {
            this.symbolTable.enterScope(irElement.getDescriptor());
        }
    }

    public final void leaveScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkParameterIsNotNull(irElement, "irElement");
        this.typeParametersResolver.leaveTypeParameterScope();
        if (this.enterTableScope) {
            this.symbolTable.leaveScope(irElement.getDescriptor());
        }
    }

    public final <T> T buildWithScope(@NotNull IrTypeParametersContainer container2, @NotNull Function0<? extends T> builder) {
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        this.enterScope(container2);
        T result2 = builder.invoke();
        this.leaveScope(container2);
        return result2;
    }

    private final IrTypeParameterSymbol resolveTypeParameter(TypeParameterDescriptor typeParameterDescriptor) {
        IrTypeParameterSymbol irTypeParameterSymbol = this.typeParametersResolver.resolveScopedTypeParameter(typeParameterDescriptor);
        if (irTypeParameterSymbol == null) {
            irTypeParameterSymbol = this.symbolTable.referenceTypeParameter(typeParameterDescriptor);
        }
        return irTypeParameterSymbol;
    }

    @NotNull
    public final IrType translateType(@NotNull KotlinType ktType) {
        Intrinsics.checkParameterIsNotNull(ktType, "ktType");
        return this.translateType(ktType, Variance.INVARIANT).getType();
    }

    private final IrTypeProjection translateType(KotlinType ktType0, Variance variance) {
        IrSimpleTypeImpl irSimpleTypeImpl;
        ClassifierDescriptor ktTypeDescriptor;
        KotlinType ktTypeUpper = this.approximate(ktType0, this.languageVersionSettings);
        if (KotlinTypeKt.isError(ktTypeUpper)) {
            return new IrErrorTypeImpl(ktTypeUpper, this.translateTypeAnnotations(ktTypeUpper.getAnnotations()), variance);
        }
        if (DynamicTypesKt.isDynamic(ktTypeUpper)) {
            return new IrDynamicTypeImpl(ktTypeUpper, this.translateTypeAnnotations(ktTypeUpper.getAnnotations()), variance);
        }
        if (FlexibleTypesKt.isFlexible(ktTypeUpper)) {
            return this.translateType(FlexibleTypesKt.upperIfFlexible(ktTypeUpper), variance);
        }
        TypeConstructor ktTypeConstructor = ktTypeUpper.getConstructor();
        ClassifierDescriptor classifierDescriptor = ktTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No descriptor for type " + ktTypeUpper)));
        }
        ClassifierDescriptor classifierDescriptor2 = ktTypeDescriptor = classifierDescriptor;
        if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            ClassifierDescriptor classifierDescriptor3 = ktTypeDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor3, "ktTypeDescriptor");
            irSimpleTypeImpl = new IrSimpleTypeImpl(ktTypeUpper, this.resolveTypeParameter((TypeParameterDescriptor)classifierDescriptor3), ktTypeUpper.isMarkedNullable(), CollectionsKt.emptyList(), this.translateTypeAnnotations(ktTypeUpper.getAnnotations()), variance);
        } else if (classifierDescriptor2 instanceof ClassDescriptor) {
            ClassifierDescriptor classifierDescriptor4 = ktTypeDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor4, "ktTypeDescriptor");
            irSimpleTypeImpl = new IrSimpleTypeImpl(ktTypeUpper, this.symbolTable.referenceClass((ClassDescriptor)classifierDescriptor4), ktTypeUpper.isMarkedNullable(), this.translateTypeArguments(ktTypeUpper.getArguments()), this.translateTypeAnnotations(ktTypeUpper.getAnnotations()), variance);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected type descriptor " + ktTypeDescriptor + " :: " + Reflection.getOrCreateKotlinClass(ktTypeDescriptor.getClass()))));
        }
        return irSimpleTypeImpl;
    }

    private final KotlinType approximate(@NotNull KotlinType $receiver, LanguageVersionSettings languageVersionSettings) {
        if ($receiver.getConstructor().isDenotable()) {
            return $receiver;
        }
        return languageVersionSettings.supportsFeature(LanguageFeature.NewInference) ? (KotlinType)this.typeApproximatorForNI.approximateDeclarationType($receiver, false, languageVersionSettings) : CapturedTypeApproximationKt.approximateCapturedTypes($receiver).getUpper();
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrCall> translateTypeAnnotations(Annotations annotations2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)annotations2.getAllAnnotations();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            AnnotationWithTarget annotationWithTarget = (AnnotationWithTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstantValueGenerator constantValueGenerator = this.constantValueGenerator;
            if (constantValueGenerator == null) {
                Intrinsics.throwUninitializedPropertyAccessException("constantValueGenerator");
            }
            IrCall irCall = constantValueGenerator.generateAnnotationConstructorCall(it.getAnnotation());
            collection.add(irCall);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrTypeArgument> translateTypeArguments(List<? extends TypeProjection> arguments2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)arguments2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (it.isStarProjection()) {
                irTypeArgument = IrStarProjectionImpl.INSTANCE;
            } else {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                Variance variance = it.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "it.projectionKind");
                irTypeArgument = this.translateType(kotlinType, variance);
            }
            IrTypeArgument irTypeArgument2 = irTypeArgument;
            collection.add(irTypeArgument2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public TypeTranslator(@NotNull ReferenceSymbolTable symbolTable, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull TypeParametersResolver typeParametersResolver, boolean enterTableScope) {
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(typeParametersResolver, "typeParametersResolver");
        this.symbolTable = symbolTable;
        this.languageVersionSettings = languageVersionSettings;
        this.typeParametersResolver = typeParametersResolver;
        this.enterTableScope = enterTableScope;
        this.typeApproximatorForNI = new TypeApproximator();
    }

    public /* synthetic */ TypeTranslator(ReferenceSymbolTable referenceSymbolTable, LanguageVersionSettings languageVersionSettings, TypeParametersResolver typeParametersResolver, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            typeParametersResolver = new ScopedTypeParametersResolver();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(referenceSymbolTable, languageVersionSettings, typeParametersResolver, bl);
    }
}

