/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;

public final class KtStubbedPsiUtil {
    @Nullable
    public static KtDeclaration getContainingDeclaration(@NotNull PsiElement element) {
        return KtStubbedPsiUtil.getPsiOrStubParent(element, KtDeclaration.class, true);
    }

    @Nullable
    public static <T extends KtDeclaration> T getContainingDeclaration(@NotNull PsiElement element, @NotNull Class<T> declarationClass) {
        return (T)((KtDeclaration)KtStubbedPsiUtil.getPsiOrStubParent(element, declarationClass, true));
    }

    @Nullable
    public static <T extends KtElement> T getPsiOrStubParent(@NotNull PsiElement element, @NotNull Class<T> declarationClass, boolean strict) {
        Object stub2;
        if (!strict && declarationClass.isInstance(element)) {
            return (T)((KtElement)element);
        }
        if (element instanceof KtElementImplStub && (stub2 = ((KtElementImplStub)element).getStub()) != null) {
            return (T)((KtElement)stub2.getParentStubOfType(declarationClass));
        }
        return (T)((KtElement)PsiTreeUtil.getParentOfType(element, declarationClass, strict));
    }

    @Nullable
    public static <T extends KtElement> T getStubOrPsiChild(@NotNull KtElementImplStub<?> element, @NotNull TokenSet types, @NotNull ArrayFactory<T> factory2) {
        KtElement[] typeElements = (KtElement[])element.getStubOrPsiChildren(types, factory2);
        if (typeElements.length == 0) {
            return null;
        }
        return (T)typeElements[0];
    }

    private KtStubbedPsiUtil() {
    }
}

