/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_SERVICE = "Export-Service";
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String ATTR_RESOLUTION = "resolution";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_BUNDLE_VERSION = "bundle-version";
    private static final String ATTR_USE = "use";

    public static BundleInfo parseJarManifest(InputStream inputStream) throws IOException, ParseException {
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        BundleInfo bundleInfo = ManifestParser.parseManifest(jarInputStream.getManifest());
        jarInputStream.close();
        return bundleInfo;
    }

    public static BundleInfo parseManifest(File file) throws IOException, ParseException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BundleInfo bundleInfo = ManifestParser.parseManifest(fileInputStream);
        fileInputStream.close();
        return bundleInfo;
    }

    public static BundleInfo parseManifest(InputStream inputStream) throws IOException, ParseException {
        BundleInfo bundleInfo = ManifestParser.parseManifest(new Manifest(inputStream));
        inputStream.close();
        return bundleInfo;
    }

    public static BundleInfo parseManifest(Manifest manifest) throws ParseException {
        Version version;
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue(BUNDLE_MANIFEST_VERSION);
        if (string == null) {
            throw new ParseException("No Bundle-ManifestVersion in the manifest", 0);
        }
        String string2 = new ManifestHeaderValue(attributes.getValue(BUNDLE_SYMBOLIC_NAME)).getSingleValue();
        if (string2 == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        String string3 = new ManifestHeaderValue(attributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        if (string3 == null) {
            string3 = new ManifestHeaderValue(attributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        }
        String string4 = new ManifestHeaderValue(attributes.getValue(BUNDLE_VERSION)).getSingleValue();
        try {
            version = ManifestParser.versionOf(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + string4 + " (" + numberFormatException.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(string2, version);
        bundleInfo.setDescription(string3);
        List list = new ManifestHeaderValue(attributes.getValue(BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT)).getValues();
        bundleInfo.setExecutionEnvironments(list);
        ManifestParser.parseRequirement(bundleInfo, attributes, REQUIRE_BUNDLE, "bundle", ATTR_BUNDLE_VERSION);
        ManifestParser.parseRequirement(bundleInfo, attributes, IMPORT_PACKAGE, "package", ATTR_VERSION);
        ManifestParser.parseRequirement(bundleInfo, attributes, IMPORT_SERVICE, "service", ATTR_VERSION);
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(EXPORT_PACKAGE));
        for (ManifestHeaderElement manifestHeaderElement : manifestHeaderValue.getElements()) {
            String string5 = (String)manifestHeaderElement.getAttributes().get(ATTR_VERSION);
            Version version2 = null;
            try {
                version2 = ManifestParser.versionOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The Export-Package has an incorrect version: " + string5 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string6 : manifestHeaderElement.getValues()) {
                ExportPackage exportPackage = new ExportPackage(string6, version2);
                String string7 = (String)manifestHeaderElement.getDirectives().get(ATTR_USE);
                if (string7 != null) {
                    String[] stringArray = string7.trim().split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        exportPackage.addUse(stringArray[i].trim());
                    }
                }
                bundleInfo.addCapability(exportPackage);
            }
        }
        ManifestParser.parseCapability(bundleInfo, attributes, EXPORT_SERVICE, "service");
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes attributes, String string, String string2, String string3) throws ParseException {
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(string));
        for (ManifestHeaderElement manifestHeaderElement : manifestHeaderValue.getElements()) {
            String string4 = (String)manifestHeaderElement.getDirectives().get(ATTR_RESOLUTION);
            String string5 = (String)manifestHeaderElement.getAttributes().get(string3);
            VersionRange versionRange = null;
            try {
                versionRange = ManifestParser.versionRangeOf(string5);
            }
            catch (ParseException parseException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string5 + " (" + parseException.getMessage() + ")", 0);
            }
            for (String string6 : manifestHeaderElement.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(string2, string6, versionRange, string4));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes attributes, String string, String string2) throws ParseException {
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(string));
        for (ManifestHeaderElement manifestHeaderElement : manifestHeaderValue.getElements()) {
            String string3 = (String)manifestHeaderElement.getAttributes().get(ATTR_VERSION);
            Version version = null;
            try {
                version = ManifestParser.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string4 : manifestHeaderElement.getValues()) {
                BundleCapability bundleCapability = new BundleCapability(string2, string4, version);
                bundleInfo.addCapability(bundleCapability);
            }
        }
    }

    private static VersionRange versionRangeOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new VersionRange(string);
    }

    private static Version versionOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }
}

