/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.OSGiManifestParser;
import org.apache.ivy.util.Message;

public class RepoDescriptor {
    private final Map moduleByCapbilities = new HashMap();
    private final Set modules = new HashSet();
    private final ExecutionEnvironmentProfileProvider profileProvider;
    private final URI baseUri;

    public RepoDescriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        this.baseUri = uRI;
        this.profileProvider = executionEnvironmentProfileProvider;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public Set getModules() {
        return this.modules;
    }

    public Map getModuleByCapbilities() {
        return this.moduleByCapbilities;
    }

    public Set findModule(String string, String string2) {
        Map map = (Map)this.moduleByCapbilities.get(string);
        if (map == null) {
            return null;
        }
        return (Set)map.get(string2);
    }

    public Set getCapabilityValues(String string) {
        Map map = (Map)this.moduleByCapbilities.get(string);
        if (map == null) {
            return null;
        }
        return map.keySet();
    }

    public void add(String string, String string2, ModuleDescriptor moduleDescriptor) {
        HashSet<ModuleDescriptor> hashSet;
        this.modules.add(moduleDescriptor);
        HashMap<String, HashSet<ModuleDescriptor>> hashMap = (HashMap<String, HashSet<ModuleDescriptor>>)this.moduleByCapbilities.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, HashSet<ModuleDescriptor>>();
            this.moduleByCapbilities.put(string, hashMap);
        }
        if ((hashSet = (HashSet<ModuleDescriptor>)hashMap.get(string2)) == null) {
            hashSet = new HashSet<ModuleDescriptor>();
            hashMap.put(string2, hashSet);
        }
        if (!hashSet.add(moduleDescriptor)) {
            Message.debug("Duplicate module in the repo " + this.baseUri + " for " + string + " " + string2 + ": " + moduleDescriptor.getModuleRevisionId());
        }
    }

    public void addBundle(BundleInfo bundleInfo) {
        DefaultModuleDescriptor defaultModuleDescriptor = BundleInfoAdapter.toModuleDescriptor(OSGiManifestParser.getInstance(), this.baseUri, bundleInfo, this.profileProvider);
        this.add("bundle", bundleInfo.getSymbolicName(), defaultModuleDescriptor);
        for (BundleCapability bundleCapability : bundleInfo.getCapabilities()) {
            this.add(bundleCapability.getType(), bundleCapability.getName(), defaultModuleDescriptor);
        }
    }

    public String toString() {
        return this.modules.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.modules == null ? 0 : ((Object)this.modules).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepoDescriptor repoDescriptor = (RepoDescriptor)object;
        return !(this.modules == null ? repoDescriptor.modules != null : !((Object)this.modules).equals(repoDescriptor.modules));
    }
}

