/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Scroll
extends Component
implements MouseListener,
MouseMotionListener {
    Image imageGrabber = BasicComp.fetchImage("grabber.gif");
    Image imageGrabberX;
    Image imageGrabberDown = BasicComp.fetchImage("grabber-pressed.gif");
    Graphics paintG = null;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 8;
    int rightBorder = 8;
    int sliderWidth;
    int width;
    int height;
    int displayPercent;
    float[] detents;
    Dimension dimension;
    float lower = 0.0f;
    float upper = 1.0f;
    float range = 1.0f;
    float value = 0.5f;
    boolean dragging = false;
    boolean grabberVisible = true;
    ActionListener actionListener = null;

    public Scroll() {
        this(null, null);
    }

    public Scroll(float[] detents) {
        this(detents, null);
    }

    public Scroll(float[] detents, Color background) {
        this.imageGrabberX = BasicComp.fetchImage("grabber-disabled.gif");
        this.detents = detents;
        if (background != null) {
            this.setBackground(background);
        }
        this.width = 115;
        this.height = 18;
        this.displayPercent = 100;
        this.dimension = new Dimension(this.width, this.height);
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.grabbed = false;
        this.entered = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setActionListener(ActionListener al) {
        this.actionListener = al;
    }

    public void setValue(float value) {
        this.lower = 0.0f;
        this.upper = 1.0f;
        this.range = this.upper - this.lower;
        this.setSliderPosition(value - this.lower, this.range);
        this.repaint();
    }

    public float getValue() {
        return this.value;
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.repaint();
    }

    public Point getPosition() {
        return new Point(this.grabberPosition + this.leftBorder, 10);
    }

    public void setDisplayPercent(int percent) {
        if (percent != this.displayPercent) {
            this.displayPercent = percent;
            if (this.displayPercent > 100) {
                this.displayPercent = 100;
            } else if (this.displayPercent < 0) {
                this.displayPercent = 0;
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int x;
        Dimension size = this.getSize();
        int y = size.height / 2 - 2;
        this.paintG = g;
        int grabberX = this.grabberPosition + this.leftBorder - 5;
        g.setColor(this.getBackground());
        y = this.getSize().height / 2 - 2;
        g.draw3DRect(2, y, size.width - 4, 3, false);
        if (this.displayPercent < 100) {
            g.setColor(Color.green);
            x = this.sliderWidth * this.displayPercent / 100 + 3;
            g.drawLine(x, y += 2, size.width - 4, y);
        }
        if (this.detents != null && this.detents.length != 0) {
            this.paintG.setColor(Color.black);
            int i = 0;
            while (i < this.detents.length) {
                x = this.leftBorder + (int)(this.detents[i] * (float)this.sliderWidth / this.range);
                this.paintG.drawLine(x, 12, x, 15);
                ++i;
            }
        }
        if (this.grabberVisible) {
            Image image = this.isEnabled() ? (this.grabbed || this.entered ? this.imageGrabberDown : this.imageGrabber) : this.imageGrabberX;
            this.paintG.drawImage(image, grabberX, 4, this);
        }
    }

    private int limitGrabber(int mousex) {
        int x = mousex - this.leftBorder;
        if (x < 0) {
            x = 0;
        } else if (x > this.sliderWidth) {
            x = this.sliderWidth;
        }
        return x;
    }

    private void setSliderPosition(float value, float range) {
        this.grabberPosition = (int)(value / range * (float)this.sliderWidth);
    }

    private void seek() {
        this.value = (float)this.grabberPosition / (float)this.sliderWidth;
        if (this.detents != null && this.detents.length > 0 && this.dragging) {
            float tolerance = 0.05f;
            int i = 0;
            while (i < this.detents.length) {
                if (Math.abs(this.detents[i] - this.value) <= tolerance) {
                    this.value = this.detents[i];
                }
                ++i;
            }
        }
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "scroll"));
        }
    }

    public void mousePressed(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = true;
            this.grabberPosition = this.limitGrabber(me.getX());
            this.seek();
        }
    }

    public void mouseReleased(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent me) {
        int modifier = me.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0 && this.isEnabled()) {
            this.dragging = true;
            this.grabberPosition = this.limitGrabber(me.getX());
            this.seek();
        }
    }

    public void mouseEntered(MouseEvent me) {
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent me) {
        this.entered = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.paintG = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }
}

