/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;

public class SftpStatVFS {
    private long bsize;
    private long frsize;
    private long blocks;
    private long bfree;
    private long bavail;
    private long files;
    private long ffree;
    private long favail;
    private long fsid;
    private long flag;
    private long namemax;
    int flags = 0;
    long size;
    int uid;
    int gid;
    int permissions;
    int atime;
    int mtime;
    String[] extended = null;

    private SftpStatVFS() {
    }

    static SftpStatVFS getStatVFS(Buffer buffer) {
        SftpStatVFS sftpStatVFS = new SftpStatVFS();
        sftpStatVFS.bsize = buffer.getLong();
        sftpStatVFS.frsize = buffer.getLong();
        sftpStatVFS.blocks = buffer.getLong();
        sftpStatVFS.bfree = buffer.getLong();
        sftpStatVFS.bavail = buffer.getLong();
        sftpStatVFS.files = buffer.getLong();
        sftpStatVFS.ffree = buffer.getLong();
        sftpStatVFS.favail = buffer.getLong();
        sftpStatVFS.fsid = buffer.getLong();
        int n = (int)buffer.getLong();
        sftpStatVFS.namemax = buffer.getLong();
        sftpStatVFS.flag = (n & 1) != 0 ? 1L : 0L;
        sftpStatVFS.flag = sftpStatVFS.flag | ((n & 2) != 0 ? 2L : 0L);
        return sftpStatVFS;
    }

    public long getBlockSize() {
        return this.bsize;
    }

    public long getFragmentSize() {
        return this.frsize;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public long getFreeBlocks() {
        return this.bfree;
    }

    public long getAvailBlocks() {
        return this.bavail;
    }

    public long getINodes() {
        return this.files;
    }

    public long getFreeINodes() {
        return this.ffree;
    }

    public long getAvailINodes() {
        return this.favail;
    }

    public long getFileSystemID() {
        return this.fsid;
    }

    public long getMountFlag() {
        return this.flag;
    }

    public long getMaximumFilenameLength() {
        return this.namemax;
    }

    public long getSize() {
        return this.getFragmentSize() * this.getBlocks() / 1024L;
    }

    public long getUsed() {
        return this.getFragmentSize() * (this.getBlocks() - this.getFreeBlocks()) / 1024L;
    }

    public long getAvailForNonRoot() {
        return this.getFragmentSize() * this.getAvailBlocks() / 1024L;
    }

    public long getAvail() {
        return this.getFragmentSize() * this.getFreeBlocks() / 1024L;
    }

    public int getCapacity() {
        return (int)(100L * (this.getBlocks() - this.getFreeBlocks()) / this.getBlocks());
    }
}

