/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.InputStream;
import Ice.MarshalException;
import Ice.OutputStream;
import java.io.Serializable;

public enum OperationMode implements Serializable
{
    Normal(0),
    Nonmutating(1),
    Idempotent(2);

    private final int _value;

    public int value() {
        return this._value;
    }

    public static OperationMode valueOf(int v) {
        switch (v) {
            case 0: {
                return Normal;
            }
            case 1: {
                return Nonmutating;
            }
            case 2: {
                return Idempotent;
            }
        }
        return null;
    }

    private OperationMode(int v) {
        this._value = v;
    }

    public void ice_write(OutputStream ostr) {
        ostr.writeEnum(this._value, 2);
    }

    public static void ice_write(OutputStream ostr, OperationMode v) {
        if (v == null) {
            ostr.writeEnum(Normal.value(), 2);
        } else {
            ostr.writeEnum(v.value(), 2);
        }
    }

    public static OperationMode ice_read(InputStream istr) {
        int v = istr.readEnum(2);
        return OperationMode.validate(v);
    }

    private static OperationMode validate(int v) {
        OperationMode e = OperationMode.valueOf(v);
        if (e == null) {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }
}

