/*
 * Decompiled with CFR 0.152.
 */
package IceGrid;

import Ice.InputStream;
import Ice.MarshalException;
import Ice.OutputStream;
import java.io.Serializable;

public enum ServerState implements Serializable
{
    Inactive(0),
    Activating(1),
    ActivationTimedOut(2),
    Active(3),
    Deactivating(4),
    Destroying(5),
    Destroyed(6);

    private final int _value;

    public int value() {
        return this._value;
    }

    public static ServerState valueOf(int v) {
        switch (v) {
            case 0: {
                return Inactive;
            }
            case 1: {
                return Activating;
            }
            case 2: {
                return ActivationTimedOut;
            }
            case 3: {
                return Active;
            }
            case 4: {
                return Deactivating;
            }
            case 5: {
                return Destroying;
            }
            case 6: {
                return Destroyed;
            }
        }
        return null;
    }

    private ServerState(int v) {
        this._value = v;
    }

    public void ice_write(OutputStream ostr) {
        ostr.writeEnum(this._value, 6);
    }

    public static void ice_write(OutputStream ostr, ServerState v) {
        if (v == null) {
            ostr.writeEnum(Inactive.value(), 6);
        } else {
            ostr.writeEnum(v.value(), 6);
        }
    }

    public static ServerState ice_read(InputStream istr) {
        int v = istr.readEnum(6);
        return ServerState.validate(v);
    }

    private static ServerState validate(int v) {
        ServerState e = ServerState.valueOf(v);
        if (e == null) {
            throw new MarshalException("enumerator value " + v + " is out of range");
        }
        return e;
    }
}

