// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 *
 **/
public interface _LoggerAdminOperations
{
    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     *
     * @throws RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     *
     * @param current The Current object for the invocation.
     **/
    void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Current current)
        throws RemoteLoggerAlreadyAttachedException;

    /**
     * Detaches a RemoteLogger object from the local logger.
     *
     * @param prx A proxy to the remote logger.
     *
     * @param current The Current object for the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     *
     **/
    boolean detachRemoteLogger(RemoteLoggerPrx prx, Current current);

    /**
     * Retrieves log messages recently logged.
     *
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     *
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     *
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     *
     * @param prefix The prefix of the associated local logger.
     *
     * @param current The Current object for the invocation.
     * @return The Log messages.
     *
     **/
    LogMessage[] getLog(LogMessageType[] messageTypes, String[] traceCategories, int messageMax, Ice.StringHolder prefix, Current current);
}
