/* gpaste-1.0.vapi generated by vapigen-0.42, do not modify. */

[CCode (cprefix = "GPaste", gir_namespace = "GPaste", gir_version = "1.0", lower_case_cprefix = "g_paste_")]
namespace GPaste {
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_bus_get_type ()")]
	public class Bus : GLib.Object {
		[CCode (has_construct_function = false)]
		public Bus (GPaste.BusAcquiredCallback? on_bus_acquired);
		public unowned GLib.DBusConnection? get_connection ();
		public void own_name ();
		public signal void name_lost ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_bus_object_get_type ()")]
	public abstract class BusObject : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BusObject ();
		public virtual bool register_on_connection (GLib.DBusConnection connection) throws GLib.Error;
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_client_get_type ()")]
	public class Client : GLib.DBusProxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		[CCode (cname = "g_paste_client_new", has_construct_function = false)]
		public async Client () throws GLib.Error;
		public async void about () throws GLib.Error;
		public void about_sync () throws GLib.Error;
		public async void add (string text) throws GLib.Error;
		public async void add_file (string file) throws GLib.Error;
		public void add_file_sync (string file) throws GLib.Error;
		public async void add_password (string name, string password) throws GLib.Error;
		public void add_password_sync (string name, string password) throws GLib.Error;
		public void add_sync (string text) throws GLib.Error;
		public async void backup_history (string history, string backup) throws GLib.Error;
		public void backup_history_sync (string history, string backup) throws GLib.Error;
		public async void @delete (uint64 index) throws GLib.Error;
		public void delete_history_sync (string name) throws GLib.Error;
		public async void delete_password (string name) throws GLib.Error;
		public void delete_password_sync (string name) throws GLib.Error;
		public void delete_sync (uint64 index) throws GLib.Error;
		public void empty_history_sync (string name) throws GLib.Error;
		public async string get_element (uint64 index) throws GLib.Error;
		public async GPaste.ItemKind get_element_kind (uint64 index) throws GLib.Error;
		public GPaste.ItemKind get_element_kind_sync (uint64 index) throws GLib.Error;
		public string get_element_sync (uint64 index) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] get_elements ([CCode (array_length_cname = "n_indexes", array_length_pos = 1.1, array_length_type = "guint64")] uint64[] indexes) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_elements_sync ([CCode (array_length_cname = "n_indexes", array_length_pos = 1.1, array_length_type = "guint64")] uint64[] indexes) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] get_history () throws GLib.Error;
		public async string get_history_name () throws GLib.Error;
		public string get_history_name_sync () throws GLib.Error;
		public async uint64 get_history_size (string name) throws GLib.Error;
		public uint64 get_history_size_sync (string name) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_history_sync () throws GLib.Error;
		public async string get_raw_element (uint64 index) throws GLib.Error;
		public string get_raw_element_sync (uint64 index) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] get_raw_history () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_raw_history_sync () throws GLib.Error;
		public string get_version ();
		public bool is_active ();
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] list_histories () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] list_histories_sync () throws GLib.Error;
		public async void merge (string? decoration, string? separator, [CCode (array_length_cname = "n_indexes", array_length_pos = 3.1, array_length_type = "guint64")] uint64[] indexes) throws GLib.Error;
		public void merge_sync (string? decoration, string? separator, [CCode (array_length_cname = "n_indexes", array_length_pos = 3.1, array_length_type = "guint64")] uint64[] indexes) throws GLib.Error;
		public async void on_extension_state_changed (bool state) throws GLib.Error;
		public void on_extension_state_changed_sync (bool state) throws GLib.Error;
		public async void reexecute () throws GLib.Error;
		public void reexecute_sync () throws GLib.Error;
		public async void rename_password (string old_name, string new_name) throws GLib.Error;
		public void rename_password_sync (string old_name, string new_name) throws GLib.Error;
		public async void replace (uint64 index, string contents) throws GLib.Error;
		public void replace_sync (uint64 index, string contents) throws GLib.Error;
		public async unowned uint64[] search (string pattern) throws GLib.Error;
		[CCode (array_length_pos = 1.1, array_length_type = "guint64")]
		public unowned uint64[] search_sync (string pattern) throws GLib.Error;
		public async void select (uint64 index) throws GLib.Error;
		public void select_sync (uint64 index) throws GLib.Error;
		public async void set_password (uint64 index, string name) throws GLib.Error;
		public void set_password_sync (uint64 index, string name) throws GLib.Error;
		public void show_history_sync () throws GLib.Error;
		public void switch_history_sync (string name) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Client.sync () throws GLib.Error;
		public async void track (bool state) throws GLib.Error;
		public void track_sync (bool state) throws GLib.Error;
		public async void upload (uint64 index) throws GLib.Error;
		public void upload_sync (uint64 index) throws GLib.Error;
		[HasEmitter]
		public signal void delete_history (string name);
		[HasEmitter]
		public signal void empty_history (string name);
		public signal void item_selected (uint64 index);
		[HasEmitter]
		public signal void show_history ();
		[HasEmitter]
		public signal void switch_history (string name);
		public signal void tracking (bool object);
		public signal void update (GPaste.UpdateAction action, GPaste.UpdateTarget target, uint64 index);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_clipboard_get_type ()")]
	public class Clipboard : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Clipboard ();
		public void bootstrap (GPaste.History history);
		public void clear ();
		[CCode (has_construct_function = false)]
		public Clipboard.clipboard (GPaste.Settings settings);
		public void ensure_not_empty (GPaste.History history);
		public unowned string get_image_checksum ();
		public unowned Gtk.Clipboard get_real ();
		public unowned string get_text ();
		public bool is_clipboard ();
		[CCode (has_construct_function = false)]
		public Clipboard.primary (GPaste.Settings settings);
		public bool select_item (GPaste.Item item);
		public void select_text (string text);
		public void set_image ([CCode (scope = "async")] GPaste.ClipboardImageCallback callback);
		public void set_text ([CCode (scope = "async")] GPaste.ClipboardTextCallback callback);
		public void store ();
		public void sync_text (GPaste.Clipboard other);
		public signal void owner_change (Gdk.EventOwnerChange event);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_clipboards_manager_get_type ()")]
	public class ClipboardsManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ClipboardsManager (GPaste.History history, GPaste.Settings settings);
		public void activate ();
		public void add_clipboard (GPaste.Clipboard clipboard);
		public bool select (GPaste.Item item);
		public void store ();
		public void sync_from_to (bool from_clipboard);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_daemon_get_type ()")]
	public class Daemon : GPaste.BusObject {
		[CCode (has_construct_function = false)]
		public Daemon ();
		public void show_history () throws GLib.Error;
		public void upload (uint64 index);
		public signal void reexecute_self ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_file_backend_get_type ()")]
	public class FileBackend : GPaste.StorageBackend {
		[CCode (has_construct_function = false)]
		protected FileBackend ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_gnome_shell_client_get_type ()")]
	public class GnomeShellClient : GLib.DBusProxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		[CCode (cname = "g_paste_gnome_shell_client_new", has_construct_function = false)]
		public async GnomeShellClient () throws GLib.Error;
		public async uint32 grab_accelerator (GPaste.GnomeShellAccelerator accelerator) throws GLib.Error;
		public uint32 grab_accelerator_sync (GPaste.GnomeShellAccelerator accelerator) throws GLib.Error;
		public async uint32 grab_accelerators ([CCode (array_length = false)] GPaste.GnomeShellAccelerator[] accelerators) throws GLib.Error;
		public uint32 grab_accelerators_sync ([CCode (array_length = false)] GPaste.GnomeShellAccelerator[] accelerators) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public GnomeShellClient.sync () throws GLib.Error;
		public async bool ungrab_accelerator (uint32 action) throws GLib.Error;
		public bool ungrab_accelerator_sync (uint32 action) throws GLib.Error;
		public signal void accelerator_activated (uint id);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_history_get_type ()")]
	public class History : GLib.Object {
		[CCode (has_construct_function = false)]
		public History (GPaste.Settings settings);
		public void add (owned GPaste.Item item);
		public void @delete (string? name) throws GLib.Error;
		public void delete_password (string name);
		public GPaste.Item dup (uint64 index);
		public void empty ();
		public unowned GPaste.Item @get (uint64 index);
		public unowned string get_current ();
		public unowned string get_display_string (uint64 index);
		public unowned GLib.List<GPaste.Item> get_history ();
		public uint64 get_length ();
		public unowned GPaste.PasswordItem? get_password (string name);
		public unowned string get_value (uint64 index);
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] list () throws GLib.Error;
		public void load (string? name);
		public void refresh_item_size (GPaste.Item item, uint64 old_size);
		public void remove (uint64 index);
		public void rename_password (string old_name, string? new_name);
		public void replace (uint64 index, string contents);
		public void save (string? name);
		public GLib.Array<uint64> search (string pattern);
		public void select (uint64 index);
		public void set_password (uint64 index, string? name);
		public signal void selected (GPaste.Item item);
		[HasEmitter]
		public signal void @switch (string name);
		public signal void update (GPaste.UpdateAction action, GPaste.UpdateTarget target, uint64 index);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_image_item_get_type ()")]
	public class ImageItem : GPaste.Item {
		[CCode (has_construct_function = false, type = "GPasteItem*")]
		public ImageItem (Gdk.Pixbuf img);
		[CCode (has_construct_function = false, type = "GPasteItem*")]
		public ImageItem.from_file (string path, GLib.DateTime date);
		public unowned string get_checksum ();
		public unowned GLib.DateTime get_date ();
		public unowned Gdk.Pixbuf get_image ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_item_get_type ()")]
	public abstract class Item : GLib.Object {
		[CCode (has_construct_function = false)]
		public Item (GLib.Type type, string value);
		public void add_size (uint64 size);
		public void add_special_value (GPaste.SpecialValue special_value);
		public virtual bool equals (GPaste.Item other);
		public unowned string get_display_string ();
		public virtual unowned string get_kind ();
		public unowned string get_real_value ();
		public uint64 get_size ();
		public unowned string get_special_value (GPaste.SpecialAtom atom);
		public unowned GLib.SList<GPaste.SpecialValue?> get_special_values ();
		public virtual unowned string get_value ();
		public void remove_size (uint64 size);
		public void set_display_string (string display_string);
		public void set_size (uint64 size);
		public virtual void set_state (GPaste.ItemState state);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_keybinder_get_type ()")]
	public class Keybinder : GLib.Object {
		[CCode (has_construct_function = false)]
		public Keybinder (GPaste.Settings settings, GPaste.GnomeShellClient shell_client);
		public void activate_all ();
		public void add_keybinding (owned GPaste.Keybinding binding);
		public void deactivate_all ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_keybinding_get_type ()")]
	public abstract class Keybinding : GLib.Object {
		[CCode (has_construct_function = false)]
		public Keybinding (GLib.Type type, string dconf_key, GPaste.KeybindingGetter getter, GPaste.KeybindingFunc callback);
		public void activate (GPaste.Settings settings);
		public void deactivate ();
		public unowned string get_accelerator (GPaste.Settings settings);
		public unowned string get_dconf_key ();
		public uint32 get_keycodes ();
		public Gdk.ModifierType get_modifiers ();
		public bool is_active ();
		public void notify (Gdk.ModifierType modifiers, uint64 keycode);
		public void perform ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_make_password_keybinding_get_type ()")]
	public class MakePasswordKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public MakePasswordKeybinding (GPaste.History history);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_password_item_get_type ()")]
	public class PasswordItem : GPaste.TextItem {
		[CCode (has_construct_function = false, type = "GPasteItem*")]
		public PasswordItem (string? name, string password);
		public unowned string get_name ();
		public void set_name (string? name);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_pop_keybinding_get_type ()")]
	public class PopKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public PopKeybinding (GPaste.History history);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_screensaver_client_get_type ()")]
	public class ScreensaverClient : GLib.DBusProxy, GLib.AsyncInitable, GLib.DBusInterface, GLib.Initable {
		[CCode (cname = "g_paste_screensaver_client_new", has_construct_function = false)]
		public async ScreensaverClient () throws GLib.Error;
		[CCode (has_construct_function = false)]
		public ScreensaverClient.sync () throws GLib.Error;
		public signal void active_changed (bool active);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_search_provider_get_type ()")]
	public class SearchProvider : GPaste.BusObject {
		[CCode (has_construct_function = false, type = "GPasteBusObject*")]
		public SearchProvider ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_settings_get_type ()")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		public Settings ();
		public bool get_close_on_select ();
		public uint64 get_element_size ();
		public bool get_empty_history_confirmation ();
		public bool get_extension_enabled ();
		public bool get_growing_lines ();
		public unowned string get_history_name ();
		public bool get_images_support ();
		public unowned string get_launch_ui ();
		public unowned string get_make_password ();
		public uint64 get_max_displayed_history_size ();
		public uint64 get_max_history_size ();
		public uint64 get_max_memory_usage ();
		public uint64 get_max_text_item_size ();
		public uint64 get_min_text_item_size ();
		public unowned string get_pop ();
		public bool get_primary_to_history ();
		public bool get_rich_text_support ();
		public bool get_save_history ();
		public unowned string get_show_history ();
		public unowned string get_sync_clipboard_to_primary ();
		public unowned string get_sync_primary_to_clipboard ();
		public bool get_synchronize_clipboards ();
		public bool get_track_changes ();
		public bool get_track_extension_state ();
		public bool get_trim_items ();
		public unowned string get_upload ();
		public void reset_close_on_select ();
		public void reset_element_size ();
		public void reset_empty_history_confirmation ();
		public void reset_growing_lines ();
		public void reset_history_name ();
		public void reset_images_support ();
		public void reset_launch_ui ();
		public void reset_make_password ();
		public void reset_max_displayed_history_size ();
		public void reset_max_history_size ();
		public void reset_max_memory_usage ();
		public void reset_max_text_item_size ();
		public void reset_min_text_item_size ();
		public void reset_pop ();
		public void reset_primary_to_history ();
		public void reset_rich_text_support ();
		public void reset_save_history ();
		public void reset_show_history ();
		public void reset_sync_clipboard_to_primary ();
		public void reset_sync_primary_to_clipboard ();
		public void reset_synchronize_clipboards ();
		public void reset_track_changes ();
		public void reset_track_extension_state ();
		public void reset_trim_items ();
		public void reset_upload ();
		public void set_close_on_select (bool value);
		public void set_element_size (uint64 value);
		public void set_empty_history_confirmation (bool value);
		public void set_extension_enabled (bool value);
		public void set_growing_lines (bool value);
		public void set_history_name (string value);
		public void set_images_support (bool value);
		public void set_launch_ui (string value);
		public void set_make_password (string value);
		public void set_max_displayed_history_size (uint64 value);
		public void set_max_history_size (uint64 value);
		public void set_max_memory_usage (uint64 value);
		public void set_max_text_item_size (uint64 value);
		public void set_min_text_item_size (uint64 value);
		public void set_pop (string value);
		public void set_primary_to_history (bool value);
		public void set_rich_text_support (bool value);
		public void set_save_history (bool value);
		public void set_show_history (string value);
		public void set_sync_clipboard_to_primary (string value);
		public void set_sync_primary_to_clipboard (string value);
		public void set_synchronize_clipboards (bool value);
		public void set_track_changes (bool value);
		public void set_track_extension_state (bool value);
		public void set_trim_items (bool value);
		public void set_upload (string value);
		public signal void changed (string key);
		public signal void rebind (string key);
		public signal void track (bool tracking_state);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_settings_ui_panel_get_type ()")]
	public class SettingsUiPanel : Gtk.Grid, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		public SettingsUiPanel ();
		public unowned Gtk.Switch add_boolean_setting (string label, bool value, [CCode (delegate_target_pos = 4.1)] GPaste.BooleanCallback on_value_changed, GPaste.ResetCallback on_reset);
		public unowned Gtk.SpinButton add_range_setting (string label, double value, double min, double max, double step, [CCode (delegate_target_pos = 7.1)] GPaste.RangeCallback on_value_changed, GPaste.ResetCallback on_reset);
		public void add_separator ();
		public unowned Gtk.Entry add_text_setting (string label, string value, [CCode (delegate_target_pos = 4.1)] GPaste.TextCallback on_value_changed, GPaste.ResetCallback on_reset);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_settings_ui_stack_get_type ()")]
	public class SettingsUiStack : Gtk.Stack, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public SettingsUiStack ();
		public void add_panel (string name, string label, GPaste.SettingsUiPanel panel);
		public void fill ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_settings_ui_widget_get_type ()")]
	public class SettingsUiWidget : Gtk.Grid, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SettingsUiWidget ();
		public unowned GPaste.SettingsUiStack get_stack ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_show_history_keybinding_get_type ()")]
	public class ShowHistoryKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public ShowHistoryKeybinding (GPaste.Daemon gpaste_daemon);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_storage_backend_get_type ()")]
	public abstract class StorageBackend : GLib.Object {
		[CCode (has_construct_function = false)]
		public StorageBackend (GPaste.Storage storage_kind, GPaste.Settings settings);
		[NoWrapper]
		public virtual unowned string get_extension ();
		[NoWrapper]
		public virtual unowned GPaste.Settings get_settings ();
		public void read_history (string name, out GLib.List<GPaste.Item> history, out size_t size);
		public void write_history (string name, GLib.List<GPaste.Item> history);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_sync_clipboard_to_primary_keybinding_get_type ()")]
	public class SyncClipboardToPrimaryKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public SyncClipboardToPrimaryKeybinding (GPaste.ClipboardsManager gcm);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_sync_primary_to_clipboard_keybinding_get_type ()")]
	public class SyncPrimaryToClipboardKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public SyncPrimaryToClipboardKeybinding (GPaste.ClipboardsManager gcm);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_text_item_get_type ()")]
	public class TextItem : GPaste.Item {
		[CCode (has_construct_function = false, type = "GPasteItem*")]
		public TextItem (string text);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_about_get_type ()")]
	public class UiAbout : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiAbout (Gtk.Application app);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_backup_history_get_type ()")]
	public class UiBackupHistory : GPaste.UiHistoryAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiBackupHistory (GPaste.Client client, GPaste.Settings settings, Gtk.Widget actions, Gtk.Window rootwin);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_delete_history_get_type ()")]
	public class UiDeleteHistory : GPaste.UiHistoryAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiDeleteHistory (GPaste.Client client, GPaste.Settings settings, Gtk.Widget actions, Gtk.Window rootwin);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_delete_item_get_type ()")]
	public class UiDeleteItem : GPaste.UiItemAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiDeleteItem (GPaste.Client client);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_edit_item_get_type ()")]
	public class UiEditItem : GPaste.UiItemAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiEditItem (GPaste.Client client, Gtk.Window rootwin);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_empty_history_get_type ()")]
	public class UiEmptyHistory : GPaste.UiHistoryAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiEmptyHistory (GPaste.Client client, GPaste.Settings settings, Gtk.Widget actions, Gtk.Window rootwin);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_empty_item_get_type ()")]
	public class UiEmptyItem : GPaste.UiItemSkeleton, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiEmptyItem (GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin);
		public void show_empty ();
		public void show_no_result ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_header_get_type ()")]
	public class UiHeader : Gtk.HeaderBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiHeader (Gtk.Window topwin, GPaste.Client client);
		public unowned Gtk.Button get_search_button ();
		public void show_prefs ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_history_get_type ()")]
	public class UiHistory : Gtk.ListBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiHistory (GPaste.Client client, GPaste.Settings settings, GPaste.UiPanel panel, Gtk.Window rootwin);
		public void search (string search);
		public bool select_first ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_history_action_get_type ()")]
	public abstract class UiHistoryAction : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiHistoryAction (GLib.Type type, GPaste.Client client, GPaste.Settings settings, Gtk.Widget actions, Gtk.Window rootwin, string label);
		[NoWrapper]
		public virtual bool activate (GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin, string history);
		public void set_history (string history);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_history_actions_get_type ()")]
	public class UiHistoryActions : Gtk.Popover, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiHistoryActions (GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin);
		public void set_relative_to (GPaste.UiPanelHistory? history);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_item_get_type ()")]
	public class UiItem : GPaste.UiItemSkeleton, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiItem (GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin, uint64 index);
		public bool activate ();
		public void refresh ();
		public void set_index (uint64 index);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_item_action_get_type ()")]
	public abstract class UiItemAction : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiItemAction (GLib.Type type, GPaste.Client client, string icon_name, string tooltip);
		[NoWrapper]
		public virtual void activate (GPaste.Client client, uint64 index);
		public void set_index (uint64 index);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_item_skeleton_get_type ()")]
	public abstract class UiItemSkeleton : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiItemSkeleton (GLib.Type type, GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin);
		public unowned Gtk.Label get_label ();
		public void set_activatable (bool activatable);
		public void set_editable (bool editable);
		public void set_index (uint64 index);
		public void set_markup (string markup);
		public void set_text (string text);
		public void set_uploadable (bool uploadable);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_keybinding_get_type ()")]
	public class UiKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public UiKeybinding ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_new_item_get_type ()")]
	public class UiNewItem : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiNewItem (Gtk.Window rootwin, GPaste.Client client);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_panel_get_type ()")]
	public class UiPanel : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiPanel (GPaste.Client client, GPaste.Settings settings, Gtk.Window rootwin, Gtk.SearchEntry search_entry);
		public void update_history_length (string history, uint64 length);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_panel_history_get_type ()")]
	public class UiPanelHistory : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiPanelHistory (GPaste.Client client, string history);
		public void activate ();
		public unowned string get_history ();
		public void set_length (uint64 length);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_reexec_get_type ()")]
	public class UiReexec : Gtk.Button, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiReexec (Gtk.Window topwin, GPaste.Client client);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_search_get_type ()")]
	public class UiSearch : Gtk.ToggleButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiSearch ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_search_bar_get_type ()")]
	public class UiSearchBar : Gtk.SearchBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiSearchBar ();
		public unowned Gtk.SearchEntry get_entry ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_settings_get_type ()")]
	public class UiSettings : Gtk.MenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiSettings ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_shortcuts_window_get_type ()")]
	public class UiShortcutsWindow : Gtk.ShortcutsWindow, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiShortcutsWindow (GPaste.Settings settings);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_switch_get_type ()")]
	public class UiSwitch : Gtk.Switch, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiSwitch (Gtk.Window topwin, GPaste.Client client);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_upload_item_get_type ()")]
	public class UiUploadItem : GPaste.UiItemAction, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiUploadItem (GPaste.Client client);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_ui_window_get_type ()")]
	public class UiWindow : Gtk.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public UiWindow (Gtk.Application app);
		public void empty_history (string history);
		public void search (string search);
		public void show_prefs ();
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_upload_keybinding_get_type ()")]
	public class UploadKeybinding : GPaste.Keybinding {
		[CCode (has_construct_function = false, type = "GPasteKeybinding*")]
		public UploadKeybinding (GPaste.Daemon daemon);
	}
	[CCode (cheader_filename = "gpaste.h", type_id = "g_paste_uris_item_get_type ()")]
	public class UrisItem : GPaste.TextItem {
		[CCode (has_construct_function = false, type = "GPasteItem*")]
		public UrisItem (string uris);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_uris ();
	}
	[CCode (cheader_filename = "gpaste.h", has_type_id = false)]
	public struct GnomeShellAccelerator {
		public weak string accelerator;
		public GPaste.GnomeShellActionMode flags;
	}
	[CCode (cheader_filename = "gpaste.h", has_type_id = false)]
	public struct SpecialValue {
		public GPaste.SpecialAtom mime;
		public weak string data;
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_GNOME_SHELL_ACTION_MODE_", has_type_id = false)]
	[Flags]
	public enum GnomeShellActionMode {
		NONE,
		NORMAL,
		OVERVIEW,
		LOCK_SCREEN,
		UNLOCK_SCREEN,
		LOGIN_SCREEN,
		SYSTEM_MODAL,
		LOOKING_GLASS,
		POPUP,
		ALL
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_ITEM_KIND_", type_id = "g_paste_item_kind_get_type ()")]
	public enum ItemKind {
		TEXT,
		URIS,
		IMAGE,
		PASSWORD
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_ITEM_STATE_", has_type_id = false)]
	public enum ItemState {
		IDLE,
		ACTIVE
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_SPECIAL_ATOM_", type_id = "g_paste_special_atom_get_type ()")]
	public enum SpecialAtom {
		GNOME_COPIED_FILES,
		TEXT_HTML,
		TEXT_XML;
		public Gdk.Atom @get ();
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_STORAGE_", has_type_id = false)]
	public enum Storage {
		FILE,
		DEFAULT
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_UPDATE_ACTION_", type_id = "g_paste_update_action_get_type ()")]
	public enum UpdateAction {
		REPLACE,
		REMOVE
	}
	[CCode (cheader_filename = "gpaste.h", cprefix = "G_PASTE_UPDATE_TARGET_", type_id = "g_paste_update_target_get_type ()")]
	public enum UpdateTarget {
		ALL,
		POSITION
	}
	[CCode (cheader_filename = "gpaste.h", instance_pos = 1.9)]
	public delegate void BooleanCallback (bool data);
	[CCode (cheader_filename = "gpaste.h", instance_pos = 1.9)]
	public delegate void BusAcquiredCallback (GPaste.Bus bus);
	[CCode (cheader_filename = "gpaste.h", instance_pos = 2.9)]
	public delegate void ClipboardImageCallback (GPaste.Clipboard self, Gdk.Pixbuf image);
	[CCode (cheader_filename = "gpaste.h", instance_pos = 2.9)]
	public delegate void ClipboardTextCallback (GPaste.Clipboard self, string text);
	[CCode (cheader_filename = "gpaste.h", has_target = false)]
	public delegate void KeybindingFunc (GPaste.Keybinding self, void* data);
	[CCode (cheader_filename = "gpaste.h", has_target = false)]
	public delegate unowned string KeybindingGetter (GPaste.Settings settings);
	[CCode (cheader_filename = "gpaste.h", instance_pos = 1.9)]
	public delegate void RangeCallback (double data);
	[CCode (cheader_filename = "gpaste.h", instance_pos = 0.9)]
	public delegate void ResetCallback ();
	[CCode (cheader_filename = "gpaste.h", instance_pos = 1.9)]
	public delegate void TextCallback (string data);
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_BUS_NAME")]
	public const string BUS_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_CLOSE_ON_SELECT_SETTING")]
	public const string CLOSE_ON_SELECT_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_ABOUT")]
	public const string DAEMON_ABOUT;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_ADD")]
	public const string DAEMON_ADD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_ADD_FILE")]
	public const string DAEMON_ADD_FILE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_ADD_PASSWORD")]
	public const string DAEMON_ADD_PASSWORD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_BACKUP_HISTORY")]
	public const string DAEMON_BACKUP_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_DELETE")]
	public const string DAEMON_DELETE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_DELETE_HISTORY")]
	public const string DAEMON_DELETE_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_DELETE_PASSWORD")]
	public const string DAEMON_DELETE_PASSWORD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_EMPTY_HISTORY")]
	public const string DAEMON_EMPTY_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_ELEMENT")]
	public const string DAEMON_GET_ELEMENT;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_ELEMENTS")]
	public const string DAEMON_GET_ELEMENTS;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_ELEMENT_KIND")]
	public const string DAEMON_GET_ELEMENT_KIND;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_HISTORY")]
	public const string DAEMON_GET_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_HISTORY_NAME")]
	public const string DAEMON_GET_HISTORY_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_HISTORY_SIZE")]
	public const string DAEMON_GET_HISTORY_SIZE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_RAW_ELEMENT")]
	public const string DAEMON_GET_RAW_ELEMENT;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_GET_RAW_HISTORY")]
	public const string DAEMON_GET_RAW_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_INTERFACE")]
	public const string DAEMON_INTERFACE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_INTERFACE_NAME")]
	public const string DAEMON_INTERFACE_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_LIST_HISTORIES")]
	public const string DAEMON_LIST_HISTORIES;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_MERGE")]
	public const string DAEMON_MERGE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_OBJECT_PATH")]
	public const string DAEMON_OBJECT_PATH;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_ON_EXTENSION_STATE_CHANGED")]
	public const string DAEMON_ON_EXTENSION_STATE_CHANGED;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_PROP_ACTIVE")]
	public const string DAEMON_PROP_ACTIVE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_PROP_VERSION")]
	public const string DAEMON_PROP_VERSION;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_REEXECUTE")]
	public const string DAEMON_REEXECUTE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_RENAME_PASSWORD")]
	public const string DAEMON_RENAME_PASSWORD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_REPLACE")]
	public const string DAEMON_REPLACE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SEARCH")]
	public const string DAEMON_SEARCH;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SELECT")]
	public const string DAEMON_SELECT;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SET_PASSWORD")]
	public const string DAEMON_SET_PASSWORD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SHOW_HISTORY")]
	public const string DAEMON_SHOW_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_DELETE_HISTORY")]
	public const string DAEMON_SIG_DELETE_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_EMPTY_HISTORY")]
	public const string DAEMON_SIG_EMPTY_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_ITEM_SELECTED")]
	public const string DAEMON_SIG_ITEM_SELECTED;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_SHOW_HISTORY")]
	public const string DAEMON_SIG_SHOW_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_SWITCH_HISTORY")]
	public const string DAEMON_SIG_SWITCH_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_TRACKING")]
	public const string DAEMON_SIG_TRACKING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SIG_UPDATE")]
	public const string DAEMON_SIG_UPDATE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_SWITCH_HISTORY")]
	public const string DAEMON_SWITCH_HISTORY;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_TRACK")]
	public const string DAEMON_TRACK;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_DAEMON_UPLOAD")]
	public const string DAEMON_UPLOAD;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_ELEMENT_SIZE_SETTING")]
	public const string ELEMENT_SIZE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_EMPTY_HISTORY_CONFIRMATION_SETTING")]
	public const string EMPTY_HISTORY_CONFIRMATION_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_EXTENSION_ENABLED_SETTING")]
	public const string EXTENSION_ENABLED_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_GNOME_SHELL_BUS_NAME")]
	public const string GNOME_SHELL_BUS_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_GROWING_LINES_SETTING")]
	public const string GROWING_LINES_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_HISTORY_NAME_SETTING")]
	public const string HISTORY_NAME_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_IMAGES_SUPPORT_SETTING")]
	public const string IMAGES_SUPPORT_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_LAUNCH_UI_SETTING")]
	public const string LAUNCH_UI_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MAKE_PASSWORD_SETTING")]
	public const string MAKE_PASSWORD_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MAX_DISPLAYED_HISTORY_SIZE_SETTING")]
	public const string MAX_DISPLAYED_HISTORY_SIZE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MAX_HISTORY_SIZE_SETTING")]
	public const string MAX_HISTORY_SIZE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MAX_MEMORY_USAGE_SETTING")]
	public const string MAX_MEMORY_USAGE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MAX_TEXT_ITEM_SIZE_SETTING")]
	public const string MAX_TEXT_ITEM_SIZE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_MIN_TEXT_ITEM_SIZE_SETTING")]
	public const string MIN_TEXT_ITEM_SIZE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_POP_SETTING")]
	public const string POP_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_PRIMARY_TO_HISTORY_SETTING")]
	public const string PRIMARY_TO_HISTORY_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_RICH_TEXT_SUPPORT_SETTING")]
	public const string RICH_TEXT_SUPPORT_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SAVE_HISTORY_SETTING")]
	public const string SAVE_HISTORY_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SCREENSAVER_BUS_NAME")]
	public const string SCREENSAVER_BUS_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_ACTIVATE_RESULT")]
	public const string SEARCH_PROVIDER_ACTIVATE_RESULT;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_GET_INITIAL_RESULT_SET")]
	public const string SEARCH_PROVIDER_GET_INITIAL_RESULT_SET;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_GET_RESULT_METAS")]
	public const string SEARCH_PROVIDER_GET_RESULT_METAS;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_GET_SUBSEARCH_RESULT_SET")]
	public const string SEARCH_PROVIDER_GET_SUBSEARCH_RESULT_SET;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_INTERFACE")]
	public const string SEARCH_PROVIDER_INTERFACE;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_INTERFACE_NAME")]
	public const string SEARCH_PROVIDER_INTERFACE_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_LAUNCH_SEARCH")]
	public const string SEARCH_PROVIDER_LAUNCH_SEARCH;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SEARCH_PROVIDER_OBJECT_PATH")]
	public const string SEARCH_PROVIDER_OBJECT_PATH;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SETTINGS_NAME")]
	public const string SETTINGS_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SHELL_ENABLED_EXTENSIONS_SETTING")]
	public const string SHELL_ENABLED_EXTENSIONS_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SHELL_SETTINGS_NAME")]
	public const string SHELL_SETTINGS_NAME;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SHOW_HISTORY_SETTING")]
	public const string SHOW_HISTORY_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SYNCHRONIZE_CLIPBOARDS_SETTING")]
	public const string SYNCHRONIZE_CLIPBOARDS_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SYNC_CLIPBOARD_TO_PRIMARY_SETTING")]
	public const string SYNC_CLIPBOARD_TO_PRIMARY_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_SYNC_PRIMARY_TO_CLIPBOARD_SETTING")]
	public const string SYNC_PRIMARY_TO_CLIPBOARD_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_TRACK_CHANGES_SETTING")]
	public const string TRACK_CHANGES_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_TRACK_EXTENSION_STATE_SETTING")]
	public const string TRACK_EXTENSION_STATE_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_TRIM_ITEMS_SETTING")]
	public const string TRIM_ITEMS_SETTING;
	[CCode (cheader_filename = "gpaste.h", cname = "G_PASTE_UPLOAD_SETTING")]
	public const string UPLOAD_SETTING;
	[CCode (cheader_filename = "gpaste.h")]
	public static void util_activate_ui (string action, GLib.Variant? arg);
	[CCode (cheader_filename = "gpaste.h")]
	public static bool util_activate_ui_sync (string action, GLib.Variant? arg) throws GLib.Error;
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_compute_checksum (Gdk.Pixbuf image);
	[CCode (cheader_filename = "gpaste.h")]
	public static bool util_confirm_dialog (Gtk.Window? parent, string action, string msg);
	[CCode (cheader_filename = "gpaste.h")]
	public static void util_empty_history (Gtk.Window? parent_window, GPaste.Client client, GPaste.Settings settings, string history);
	[CCode (cheader_filename = "gpaste.h")]
	public static bool util_ensure_history_dir_exists (GPaste.Settings settings);
	[CCode (cheader_filename = "gpaste.h")]
	public static uint64 util_get_dbus_at_result (GLib.Variant variant, uint64 len);
	[CCode (cheader_filename = "gpaste.h")]
	public static uint32 util_get_dbus_au_result (GLib.Variant variant, uint64 len);
	[CCode (cheader_filename = "gpaste.h")]
	public static GLib.File util_get_history_dir ();
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_get_history_dir_path ();
	[CCode (cheader_filename = "gpaste.h")]
	public static GLib.File util_get_history_file (string name, string extension);
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_get_history_file_path (string name, string extension);
	[CCode (cheader_filename = "gpaste.h")]
	public static bool util_has_gnome_shell ();
	[CCode (cheader_filename = "gpaste.h")]
	public static GLib.Pid util_read_pid_file (string component);
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_replace (string text, string pattern, string substitution);
	[CCode (cheader_filename = "gpaste.h")]
	public static void util_show_win (GLib.Application application);
	[CCode (cheader_filename = "gpaste.h")]
	public static void util_spawn (string app);
	[CCode (cheader_filename = "gpaste.h")]
	public static bool util_spawn_sync (string app) throws GLib.Error;
	[CCode (cheader_filename = "gpaste.h")]
	public static void util_write_pid_file (string component);
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_xml_decode (string text);
	[CCode (cheader_filename = "gpaste.h")]
	public static string util_xml_encode (string text);
}
