/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0430\u0440\u0430\u0431";
        final String metaValue_bn = "\u0431\u0435\u043d\u0433\u0430\u043b";
        final String metaValue_bo = "\u0442\u04e9\u0432\u0434";
        final String metaValue_el = "\u0433\u0440\u0435\u043a";
        final String metaValue_he = "\u0435\u0432\u0440\u0435\u0439";
        final String metaValue_hy = "\u0430\u0440\u043c\u0435\u043d";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d";
        final String metaValue_ka = "\u0433\u04af\u0440\u0436";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u0441\u043e\u043b\u043e\u043d\u0433\u043e\u0441";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441";
        final String metaValue_or = "\u043e\u0440\u0438\u044f";
        final String metaValue_si = "\u0441\u0438\u043d\u0445\u0430\u043b\u0430";
        final String metaValue_ta = "\u0442\u0430\u043c\u0438\u043b";
        final String metaValue_te = "\u0442\u044d\u043b\u04af\u0433\u04af";
        final String metaValue_th = "\u0442\u0430\u0439";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0441\u0430\u043d\u0433\u04af" },
            { "nyn", "\u043d\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "luo", "\u043b\u0443\u043e" },
            { "Zsym", "\u0442\u044d\u043c\u0434\u044d\u0433" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "luy", "\u043b\u0443\u044f\u0430" },
            { "es_ES", "\u0435\u0432\u0440\u043e\u043f\u044b\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "teo", "\u0442\u044d\u0441\u043e" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437" },
            { "AC", "\u0410\u0441\u043a\u0435\u043d\u0441\u0438\u043e\u043d \u0410\u0440\u0430\u043b" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0410\u0440\u0430\u0431\u044b\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u042d\u043c\u0438\u0440\u0430\u0442" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "af", "\u0430\u0444\u0440\u0438\u043a" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0431\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u044d\u0442\u0438\u043e\u043f \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u0430" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440" },
            { "Arab", metaValue_ar },
            { "AO", "\u0410\u043d\u0433\u043e\u043b" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a" },
            { "ar", metaValue_ar },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0421\u0430\u043c\u043e\u0430" },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0430\u043d\u0433\u043b\u0438" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u0433\u0438" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0444\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d\u0442 \u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", metaValue_bn },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "bo", metaValue_bo },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "BQ", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435\u0442\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441 \u0442\u043e\u043e" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441 \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "type.nu.hebr", "\u0435\u0432\u0440\u0435\u0439 \u0442\u043e\u043e" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u0439\u043b\u0438\u043d\u0433) \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "ses", "\u043a\u0451\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0423\u043b\u0441" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438" },
            { "CI", "\u041a\u043e\u0442 \u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u04af\u04af\u043a\u0438\u0439\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u044f\u0442\u0430\u0434" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u0410\u0440\u0430\u043b" },
            { "Orya", metaValue_or },
            { "CR", "\u041a\u043e\u0441\u0442\u0430 \u0420\u0438\u043a\u0430" },
            { "cs", "\u0447\u0435\u0445" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u043f\u0435 \u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u0443\u0440\u0430\u043a\u0430\u043e" },
            { "CX", "\u0417\u0443\u043b \u0421\u0430\u0440\u044b\u043d \u0410\u0440\u0430\u043b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "cy", "\u0443\u044d\u043b\u0441" },
            { "CZ", "\u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0427\u0435\u0445 \u0423\u043b\u0441" },
            { "type.nu.ethi", "\u044d\u0442\u0438\u043e\u043f \u0442\u043e\u043e" },
            { "da", "\u0434\u0430\u043d\u0438" },
            { "pt_PT", "\u0435\u0432\u0440\u043e\u043f\u044b\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d" },
            { "de", "\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0430" },
            { "type.nu.deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438 \u0442\u043e\u043e" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0439\u043b" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a" },
            { "type.nu.armnlow", "\u0436\u0438\u0436\u0438\u0433 \u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "DO", "\u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "type.nu.mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0442\u043e\u043e" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d \u0430\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "dz", "\u0436\u043e\u043d\u0445\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u0445\u044f\u0442\u0430\u0434 \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0431\u0430 \u041c\u0435\u043b\u0438\u043b\u044c\u044f" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "type.nu.grek", "\u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d" },
            { "ee", "\u044d\u0432\u044d" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0411\u0430\u0440\u0443\u0443\u043d \u0421\u0430\u0445\u0430\u0440" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432" },
            { "el", metaValue_el },
            { "en", "\u0430\u043d\u0433\u043b\u0438" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "chr", "\u0447\u0438\u0440\u043e\u043a\u0438" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0438" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0438" },
            { "ET", "\u042d\u0442\u0438\u043e\u043f" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0438" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u044b\u043d \u0425\u043e\u043b\u0431\u043e\u043e" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "Hang", "\u0445\u0430\u043d\u0433\u0443\u043b" },
            { "type.ca.gregorian", "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0439\u043d \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0445\u0438\u0442" },
            { "type.nu.gujr", "\u0433\u04af\u0436\u0430\u0440\u0430\u0442\u0438 \u0442\u043e\u043e" },
            { "hsb", "\u0434\u044d\u044d\u0434 \u0441\u043e\u0440\u0431\u0438" },
            { "Hani", "\u0445\u0430\u043d" },
            { "fa", "\u043f\u0435\u0440\u0441" },
            { "Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d" },
            { "type.nu.latn", "\u0430\u0440\u0430\u0431 \u0442\u043e\u043e" },
            { "Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442" },
            { "FI", "\u0424\u0438\u043d\u043b\u0430\u043d\u0434" },
            { "fi", "\u0444\u0438\u043d\u043b\u044f\u043d\u0434" },
            { "FJ", "\u0424\u0438\u0436\u0438" },
            { "fj", "\u0444\u0438\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u044c\u043a\u043b\u0430\u043d\u0434\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "FO", "\u0424\u0430\u0440\u043e\u044d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "Taml", metaValue_ta },
            { "FR", "\u0424\u0440\u0430\u043d\u0446" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446" },
            { "fy", "\u0431\u0430\u0440\u0443\u0443\u043d \u0444\u0440\u0438\u0437\u044b\u043d" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "GB", "\u0418\u0445 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434 \u043a\u0435\u043b\u0442" },
            { "GE", "\u0413\u04af\u0440\u0436" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u0413\u0430\u0439\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434" },
            { "gl", "\u0433\u0430\u043b\u0438\u043a" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u044b\u043d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "und", "\u0442\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0445\u044d\u043b" },
            { "GR", "\u0413\u0440\u0435\u043a" },
            { "GS", "\u04e8\u043c\u043d\u04e9\u0434 \u0416\u043e\u0440\u0436\u0438\u0430 \u0431\u0430 \u04e8\u043c\u043d\u04e9\u0434 \u0421\u044d\u043d\u0434\u0432\u0438\u0447\u0438\u0439\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "gu", "\u0433\u0443\u0436\u0430\u0440\u0430\u0442\u0438" },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "ckb", "\u0441\u043e\u0440\u0430\u043d\u0438 \u043a\u04af\u0440\u0434" },
            { "zxx", "\u0445\u044d\u043b \u0437\u04af\u0439\u043d \u0430\u0433\u0443\u0443\u043b\u0433\u0430 \u0431\u0430\u0439\u0445\u0433\u04af\u0439" },
            { "he", metaValue_he },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438 \u0433\u0435\u0440\u043c\u0430\u043d" },
            { "HK", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433" },
            { "HM", "\u0425\u044d\u0440\u0434 \u0431\u043e\u043b\u043e\u043d \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434 \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438 \u0433\u0435\u0440\u043c\u0430\u043d" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438" },
            { "HU", "\u0423\u043d\u0433\u0430\u0440" },
            { "hu", "\u0443\u043d\u0433\u0430\u0440" },
            { "hy", metaValue_hy },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u043e" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "type.nu.tibt", "\u0442\u0438\u0431\u0435\u0442 \u0442\u043e\u043e" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434" },
            { "ie", "\u043d\u044d\u0433\u0434\u043c\u044d\u043b \u0445\u044d\u043b" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "ii", "\u0448\u0438\u0447\u0443\u0430\u043d \u0435\u0438" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0410\u0440\u0430\u043b" },
            { "IN", "\u042d\u043d\u044d\u0442\u0445\u044d\u0433" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0445\u0430\u0440\u044c\u044f\u0430 \u042d\u043d\u044d\u0442\u0445\u044d\u0433\u0438\u0439\u043d \u0434\u0430\u043b\u0430\u0439 \u0434\u0430\u0445\u044c \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440\u04af\u04af\u0434" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "it", "\u0438\u0442\u0430\u043b\u0438" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "type.nu.thai", "\u0442\u0430\u0439 \u0442\u043e\u043e" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0433\u0430\u043b \u0442\u043e\u043e" },
            { "ja", metaValue_ja },
            { "Mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "JE", "\u0416\u0435\u0440\u0441\u0438" },
            { "type.ca.islamic", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "Beng", metaValue_bn },
            { "JM", "\u042f\u043c\u0430\u0439\u043a" },
            { "JO", "\u0419\u043e\u0440\u0434\u0430\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d" },
            { "sma", "\u04e9\u043c\u043d\u04e9\u0434 \u0441\u0430\u043c\u0438" },
            { "jv", "\u044f\u0432\u0430" },
            { "guz", "\u0433\u0443\u0437\u044b" },
            { "type.nu.knda", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430 \u0442\u043e\u043e" },
            { "smj", "\u043b\u044e\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438 \u0434\u044d\u044d\u0440 \u0433\u0435\u0440\u043c\u0430\u043d" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u0438" },
            { "ka", metaValue_ka },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u0434\u044b\u043d \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "419", "\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0436" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "ki", "\u043a\u0438\u043a\u0443\u044e\u04af" },
            { "mas", "\u043c\u0430\u0441\u0430\u0439" },
            { "kk", "\u0445\u0430\u0441\u0430\u0433" },
            { "kl", "\u043a\u0430\u043b\u0430\u043b\u0438\u0441\u0443\u0442" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u043e\u0441" },
            { "km", "\u043a\u0430\u043c\u0431\u043e\u0436" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0442\u0441 \u0431\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434 \u0444\u0440\u0430\u043d\u0446" },
            { "ko", metaValue_ko },
            { "KP", "\u0425\u043e\u0439\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "KR", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440" },
            { "ku", "\u043a\u04af\u0440\u0434" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438 \u0444\u0440\u0430\u043d\u0446" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "kw", "\u043a\u043e\u0440\u043d\u044b" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u044b \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0437" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b" },
            { "la", metaValue_la },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LC", "\u0421\u0435\u043d\u0442 \u041b\u044e\u0441\u0438\u0430" },
            { "type.nu.mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c \u0442\u043e\u043e" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430" },
            { "Tibt", metaValue_bo },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "lo", metaValue_lo },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "lv", "\u043b\u0430\u0442\u0432\u0438" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "vun", "\u0432\u0443\u043d\u0436\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432" },
            { "ME", "\u041c\u043e\u043d\u0442\u0435\u043d\u0435\u0433\u0440\u043e" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "Thai", metaValue_th },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "type.co.ducet", "\u044e\u043d\u0438\u043a\u043e\u0434\u044b\u043d \u04af\u043d\u0434\u0441\u044d\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "ml", "\u043c\u0430\u043b\u0430\u0439\u043b\u0430\u043c" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430\u0440 (\u0411\u0443\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "MO", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u041c\u0430\u043a\u0430\u043e" },
            { "MP", "\u0425\u043e\u0439\u0434 \u041c\u0430\u0440\u0438\u0430\u043d\u044b \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "mt", "\u043c\u0430\u043b\u0442\u0438" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u0442\u0443\u0441" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a" },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437" },
            { "my", "\u0431\u0438\u0440\u043c" },
            { "Armn", metaValue_hy },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "dsb", "\u043b\u043e\u0432\u0435\u0440-\u0441\u043e\u0440\u0431\u0438" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "type.co.search", "\u0435\u0440\u04e9\u043d\u0445\u0438\u0439 \u0437\u043e\u0440\u0438\u043b\u0433\u043e\u0442\u043e\u0439 \u0445\u0430\u0439\u043b\u0442" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "type.ca.hebrew", "\u0435\u0432\u0440\u0435\u0439 \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "NC", "\u0428\u0438\u043d\u044d \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "nd", "\u0445\u043e\u0439\u0434 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "ne", "\u0431\u0430\u043b\u0431\u0430" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u0411\u0430\u043b\u0431\u0430" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "NZ", "\u0428\u0438\u043d\u044d \u0417\u0435\u043b\u0430\u043d\u0434" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0435" },
            { "oc", "\u0444\u0440\u0430\u043d\u0446\u044b\u043d \u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", metaValue_or },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0435\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c" },
            { "pa", "\u043f\u0430\u043d\u0436\u0430\u0431" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0430\u043d\u0433\u043b\u0438" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u0428\u0438\u043d\u044d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448" },
            { "pl", "\u043f\u043e\u043b\u044c\u0448" },
            { "PM", "\u0421\u044d\u043d\u0442 \u041f\u044c\u0435\u0440 \u0431\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "type.ca.dangi", "\u0434\u0430\u043d\u0433\u0438 \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e \u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u044b \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440\u04af\u04af\u0434" },
            { "ps", "\u043f\u0430\u0448\u0442\u043e" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "key.co", "\u0417\u0430\u0445\u0438\u0430\u043b\u0433\u0430 \u044f\u043b\u0433\u0430\u0445" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "type.nu.greklow", "\u0436\u0438\u0436\u0438\u0433 \u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "pt_BR", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b (\u0431\u0440\u0430\u0437\u0438\u043b)" },
            { "Hebr", metaValue_he },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0438\u0442\u043e" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "key.ca", "\u0445\u0443\u0430\u043d\u043b\u0438" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.nu.mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440 \u0442\u043e\u043e" },
            { "QO", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u0433 \u0442\u043e\u0439\u0440\u0441\u043e\u043d \u0443\u043b\u0441 \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "001", "\u0414\u044d\u043b\u0445\u0438\u0439" },
            { "Ethi", "\u044d\u0442\u0438\u043e\u043f" },
            { "002", "\u0410\u0444\u0440\u0438\u043a" },
            { "003", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "005", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "009", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u043d \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "key.cu", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "type.nu.orya", "\u043e\u0440\u0438\u044f \u0442\u043e\u043e" },
            { "type.nu.hanidec", "\u0445\u044f\u0442\u0430\u0434 \u0430\u0440\u0430\u0432\u0442\u044b\u043d \u0442\u043e\u043e" },
            { "RU", "\u041e\u0440\u043e\u0441" },
            { "ru", "\u043e\u0440\u043e\u0441" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "rw", "\u043a\u0438\u043d\u044f\u0440\u0432\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u04af\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438 \u0430\u043d\u0433\u043b\u0438" },
            { "SA", "\u0421\u0430\u0443\u0434\u044b\u043d \u0410\u0440\u0430\u0431" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u044b \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "013", "\u0422\u04e9\u0432 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "SE", "\u0428\u0432\u0435\u0434" },
            { "se", "\u0445\u043e\u0439\u0434 \u0441\u0430\u043c\u0438" },
            { "014", "\u0417\u04af\u04af\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "015", "\u0425\u043e\u0439\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "SH", "\u0421\u0435\u043d\u0442 \u0425\u0435\u043b\u0435\u043d\u0430" },
            { "si", metaValue_si },
            { "017", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "018", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0431\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "arn", "\u043c\u0430\u043f\u04af\u0447\u0438" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0438" },
            { "type.nu.taml", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "SS", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0431\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d" },
            { "SV", "\u042d\u043b\u044c \u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "sv", "\u0448\u0432\u0435\u0434" },
            { "sw", "\u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "SX", "\u0421\u0438\u043d\u0442 \u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438" },
            { "type.nu.hantfin", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0430\u043d\u0434" },
            { "ta", metaValue_ta },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u043d\u044c\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "021", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "142", "\u0410\u0437\u0438" },
            { "TC", "\u0422\u0443\u0440\u043a \u0431\u0430 \u041a\u0430\u0439\u043a\u043e\u0441\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "143", "\u0422\u04e9\u0432 \u0410\u0437\u0438" },
            { "TD", "\u0427\u0430\u0434" },
            { "te", metaValue_te },
            { "145", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0437\u0438" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u04e9\u043c\u043d\u04e9\u0434 \u0433\u0430\u0437\u0430\u0440 \u043d\u0443\u0442\u0430\u0433" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "tg", "\u0442\u0430\u0436\u0438\u043a" },
            { "th", metaValue_th },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u0430" },
            { "TJ", "\u0422\u0430\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434 \u0430\u043d\u0433\u043b\u0438" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430" },
            { "dyo", "\u0436\u043e\u043b\u0430-\u0444\u043e\u043d\u0438" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d \u0442\u043e\u043e" },
            { "TR", "\u0422\u0443\u0440\u043a" },
            { "tr", "\u0442\u0443\u0440\u043a" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0431\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d" },
            { "tw", "\u0442\u0432\u0438" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0438\u043e" },
            { "Zzzz", "\u0442\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0431\u0438\u0447\u0438\u0433" },
            { "150", "\u0415\u0432\u0440\u043e\u043f" },
            { "UA", "\u0423\u043a\u0440\u0430\u0439\u043d" },
            { "030", "\u0417\u04af\u04af\u043d \u0410\u0437\u0438" },
            { "151", "\u0417\u04af\u04af\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "154", "\u0425\u043e\u0439\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e \u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "034", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "155", "\u0411\u0430\u0440\u0443\u0443\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "035", "\u0417\u04af\u04af\u043d \u04e8\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "ug", "\u0443\u0439\u0433\u0430\u0440" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u043d\u0438\u0439\u0442\u043b\u044d\u0433" },
            { "039", "\u04e8\u043c\u043d\u04e9\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "uk", "\u0443\u043a\u0440\u0430\u0439\u043d" },
            { "Sinh", metaValue_si },
            { "UM", "\u0410\u041d\u0423-\u044b\u043d \u0442\u043e\u0439\u0440\u0441\u043e\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u0423\u043b\u0441" },
            { "haw", "\u0445\u0430\u0432\u0430\u0439" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a" },
            { "tzm", "\u0442\u04e9\u0432 \u0430\u0442\u043b\u0430\u0441\u044b\u043d \u0442\u0430\u043c\u0430\u0437\u0430\u0439\u0442" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d \u0445\u043e\u0442 \u0443\u043b\u0441" },
            { "VC", "\u0421\u044d\u043d\u0442 \u0412\u0438\u043d\u0441\u044d\u043d\u0442 \u0431\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b" },
            { "type.ca.roc", "\u043c\u0438\u043d\u0433\u043e \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "VI", "\u0410\u041d\u0423-\u044b\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u043d\u0438" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "rwk", "\u0440\u0432\u0430" },
            { "gag", "\u0433\u0430\u0433\u0443\u0437" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0430\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0431\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "Grek", metaValue_el },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0439\u043d \u0431\u04af\u0441" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "zgh", "\u0442\u0430\u043c\u0430\u0437\u0438\u0442" },
            { "ar_001", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0430\u0440\u0430\u0431" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0431\u0438\u0447\u0438\u0433" },
            { "Latn", metaValue_la },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437" },
            { "type.nu.hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "type.nu.hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "xh", "\u0445\u043e\u0441\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "type.nu.romanlow", "\u0436\u0438\u0436\u0438\u0433 \u0440\u043e\u043c \u0442\u043e\u043e" },
            { "Gujr", "\u0433\u04af\u0436\u0430\u0440\u0430\u0442\u0438" },
            { "Zxxx", "\u0431\u0438\u0447\u0438\u0433\u0434\u044d\u044d\u0433\u04af\u0439" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "yi", "\u0438\u0434\u0434\u0438\u0448" },
            { "yo", "\u0451\u0440\u0443\u0431\u0430" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0438\u0439\u043d \u0438\u0441\u043f\u0430\u043d\u0438" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0435" },
            { "vai", "\u0432\u0430\u0439" },
            { "ZA", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0436\u0438\u043d" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "zh", "\u0445\u044f\u0442\u0430\u0434" },
            { "type.nu.geor", "\u0433\u04af\u0440\u0436 \u0442\u043e\u043e" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "Bopo", "\u0432\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u0422\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439" },
            { "type.ca.iso8601", "ISO-8601 \u0445\u0443\u0430\u043d\u043b\u0438" },
            { "type.nu.telu", "\u0442\u0435\u043b\u04af\u0433\u04af \u0442\u043e\u043e" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u044d" },
            { "zh_Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u043a" },
            { "type.nu.hansfin", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "type.nu.arabext", "\u04e9\u0440\u0433\u04e9\u0442\u0433\u04e9\u0441\u04e9\u043d \u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "type.nu.fullwide", "\u0431\u04af\u0440\u044d\u043d \u0445\u044d\u043c\u0436\u044d\u044d\u0442\u044d\u0439 \u0442\u043e\u043e" },
            { "dav", "\u0442\u0430\u0439\u0442\u0430" },
            { "zh_Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434" },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440 \u0442\u043e\u043e" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u0433\u04af\u0440\u043c\u04af\u043a\u0445\u0438 \u0442\u043e\u043e" },
            { "Khmr", "\u043a\u0445\u043c\u0435\u0440" },
            { "type.nu.roman", "\u0440\u043e\u043c \u0442\u043e\u043e" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "saq", "\u0441\u0430\u043c\u0431\u04af\u0440\u04af" },
            { "key.nu", "\u0422\u043e\u043e" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0438" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
        };
        return data;
    }
}
