/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofGCRoots;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;

class ThreadObjectHprofGCRoot
extends HprofGCRoot
implements ThreadObjectGCRoot {
    ThreadObjectHprofGCRoot(HprofGCRoots hprofGCRoots, long l) {
        super(hprofGCRoots, l);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTrace stackTrace;
        int n = this.getStackTraceSerialNumber();
        if (n != 0 && (stackTrace = this.roots.heap.getStackTraceSegment().getStackTraceBySerialNumber(n)) != null) {
            StackFrame[] stackFrameArray = stackTrace.getStackFrames();
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[stackFrameArray.length];
            for (int i = 0; i < stackFrameArray.length; ++i) {
                StackFrame stackFrame = stackFrameArray[i];
                String string = stackFrame.getClassName();
                String string2 = stackFrame.getMethodName();
                String string3 = stackFrame.getSourceFile();
                int n2 = stackFrame.getLineNumber();
                if (n2 == -3) {
                    n2 = -2;
                } else if (n2 == 0 || n2 == -1) {
                    n2 = -1;
                }
                stackTraceElementArray[i] = new StackTraceElement(string, string2, string3, n2);
            }
            return stackTraceElementArray;
        }
        return null;
    }

    int getThreadSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + 1L + (long)this.getHprofBuffer().getIDSize());
    }

    private int getStackTraceSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + 1L + (long)this.getHprofBuffer().getIDSize() + 4L);
    }
}

