/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class CPUJavaNameRenderer
extends JavaNameRenderer {
    private static final Icon THREAD_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon THREAD_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, THREAD_ICON);
    private static final Icon LEAF_ICON = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private static final Icon LEAF_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, LEAF_ICON);
    private final Icon icon;
    private final Icon iconDisabled;

    public CPUJavaNameRenderer() {
        this("ProfilerIcons.NodeForward");
    }

    public CPUJavaNameRenderer(String string) {
        this.icon = Icons.getIcon((String)string);
        this.iconDisabled = UIManager.getLookAndFeel().getDisabledIcon(null, this.icon);
    }

    @Override
    public void setValue(Object object, int n) {
        if (object instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
            if (prestimeCPUCCTNode.isSelfTimeNode()) {
                this.setNormalValue(prestimeCPUCCTNode.getNodeName());
                this.setBoldValue("");
                this.setGrayValue("");
            } else if (prestimeCPUCCTNode.isThreadNode()) {
                this.setNormalValueEx("");
                this.setBoldValue(prestimeCPUCCTNode.getNodeName());
                this.setGrayValue("");
            } else if (prestimeCPUCCTNode.isFiltered()) {
                this.setNormalValue("");
                this.setBoldValue("");
                this.setGrayValue(prestimeCPUCCTNode.getNodeName());
            } else {
                super.setValue(prestimeCPUCCTNode.getNodeName(), n);
            }
            if (prestimeCPUCCTNode.isThreadNode()) {
                this.setIcon(prestimeCPUCCTNode.isFiltered() ? THREAD_ICON_DISABLED : THREAD_ICON);
            } else if (prestimeCPUCCTNode.isLeaf()) {
                this.setIcon(prestimeCPUCCTNode.isFiltered() ? LEAF_ICON_DISABLED : LEAF_ICON);
            } else {
                this.setIcon(prestimeCPUCCTNode.isFiltered() ? this.iconDisabled : this.icon);
            }
        } else {
            super.setValue(object, n);
        }
    }

    private void setNormalValueEx(String string) {
        super.setNormalValue(string);
        this.setCustomForeground(null);
    }
}

