/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class ComboBoxAutoCompleteSupport {
    ComboBoxAutoCompleteSupport() {
    }

    public static boolean install(JComboBox jComboBox) {
        boolean bl = false;
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        if (comboBoxEditor.getEditorComponent() instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            Document document = jTextComponent.getDocument();
            document.addDocumentListener(new AutoCompleteListener(jComboBox));
            ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(jComboBox, false);
            jComboBox.setEditable(true);
            bl = true;
        }
        jComboBox.putClientProperty("nb.combo.autocomplete", bl);
        return bl;
    }

    static boolean isIgnoreSelectionEvents(JComboBox jComboBox) {
        Object object = jComboBox.getClientProperty("nb.combo.autocomplete.ignoreselection");
        return object instanceof Boolean && (Boolean)object != false;
    }

    static void setIgnoreSelectionEvents(JComboBox jComboBox, boolean bl) {
        jComboBox.putClientProperty("nb.combo.autocomplete.ignoreselection", bl);
    }

    static boolean isAutoCompleteInstalled(JComboBox jComboBox) {
        Object object = jComboBox.getClientProperty("nb.combo.autocomplete");
        return object instanceof Boolean && (Boolean)object != false;
    }

    static int findMatch(JComboBox jComboBox, String string) {
        String string2;
        int n;
        if (null == string || string.isEmpty()) {
            return -1;
        }
        for (n = 0; n < jComboBox.getItemCount(); ++n) {
            string2 = jComboBox.getItemAt(n).toString();
            if (string2.toLowerCase().compareTo(string) != 0) continue;
            return n;
        }
        for (n = 0; n < jComboBox.getItemCount(); ++n) {
            string2 = jComboBox.getItemAt(n).toString();
            if (!string2.toLowerCase().startsWith(string)) continue;
            return n;
        }
        return -1;
    }

    private static JList getPopupList(JComboBox jComboBox) {
        Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
        if (accessible instanceof ComboPopup) {
            return ((ComboPopup)((Object)accessible)).getList();
        }
        return null;
    }

    private static class AutoCompleteListener
    implements DocumentListener {
        private final JComboBox combo;

        public AutoCompleteListener(JComboBox jComboBox) {
            this.combo = jComboBox;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.matchSelection(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.matchSelection(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.matchSelection(documentEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void matchSelection(DocumentEvent documentEvent) {
            if (ComboBoxAutoCompleteSupport.isIgnoreSelectionEvents(this.combo)) {
                return;
            }
            try {
                JList jList;
                String string;
                ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(this.combo, true);
                if (!this.combo.isDisplayable()) {
                    return;
                }
                try {
                    string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                }
                catch (BadLocationException badLocationException) {
                    ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(this.combo, false);
                    return;
                }
                if (null != this.combo.getSelectedItem() && this.combo.getSelectedItem().toString().equals(string)) {
                    return;
                }
                if (!this.combo.isPopupVisible()) {
                    this.combo.showPopup();
                }
                if (null == (jList = ComboBoxAutoCompleteSupport.getPopupList(this.combo))) {
                    return;
                }
                int n = ComboBoxAutoCompleteSupport.findMatch(this.combo, string);
                if (n >= 0) {
                    jList.setSelectedIndex(n);
                    Rectangle rectangle = jList.getCellBounds(n, n);
                    if (null != rectangle) {
                        jList.scrollRectToVisible(rectangle);
                    }
                } else {
                    jList.clearSelection();
                    jList.scrollRectToVisible(new Rectangle(1, 1));
                }
            }
            finally {
                ComboBoxAutoCompleteSupport.setIgnoreSelectionEvents(this.combo, false);
            }
        }
    }
}

