/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.filters;

import java.util.Objects;
import java.util.Properties;

public class GenericFilter {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_INCLUSIVE = 10;
    public static final int TYPE_EXCLUSIVE = 20;
    protected static final int MODE_EQUALS = 1000;
    protected static final int MODE_CONTAINS = 1010;
    protected static final int MODE_STARTS_WITH = 1020;
    protected static final int MODE_ENDS_WITH = 1030;
    private static final String PROP_NAME = "NAME";
    private static final String PROP_VALUE = "VALUE";
    private static final String PROP_TYPE = "TYPE";
    private String name;
    private String value;
    private transient String[] values;
    private int type;
    private transient int[] modes;
    private Boolean isEmpty;
    private Boolean isAll;

    public GenericFilter() {
        this(null, "", 0);
    }

    public GenericFilter(GenericFilter genericFilter) {
        this(genericFilter.name, genericFilter.value, genericFilter.values, genericFilter.type, genericFilter.modes);
    }

    public GenericFilter(String string, String string2, int n) {
        this(string, string2, null, n, null);
    }

    public GenericFilter(Properties properties, String string) {
        this(GenericFilter.loadName(properties, string), GenericFilter.loadValue(properties, string), GenericFilter.loadType(properties, string));
    }

    private GenericFilter(String string, String string2, String[] stringArray, int n, int[] nArray) {
        this.name = string;
        this.value = string2;
        this.values = stringArray;
        this.type = n;
        this.modes = nArray;
    }

    public void copyFrom(GenericFilter genericFilter) {
        this.name = genericFilter.name;
        this.value = genericFilter.value;
        this.values = genericFilter.values;
        this.type = genericFilter.type;
        this.modes = genericFilter.modes;
        this.isEmpty = genericFilter.isEmpty;
        this.isAll = genericFilter.isAll;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setValue(String string) {
        this.value = string;
        this.valueChanged();
    }

    protected void valueChanged() {
        this.values = null;
        this.modes = null;
        this.isEmpty = null;
        this.isAll = null;
    }

    public final String getValue() {
        return this.value;
    }

    public final String[] getValues() {
        if (this.values == null) {
            this.values = this.computeValues(this.value);
        }
        return this.values;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final int getType() {
        return this.type;
    }

    public final int[] getModes() {
        if (this.modes == null) {
            this.modes = this.computeModes(this.getValues());
        }
        return this.modes;
    }

    public final boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = this.value.isEmpty();
        }
        return this.isEmpty;
    }

    public boolean isAll() {
        if (this.isAll == null) {
            this.isAll = this.isEmpty() || "*".equals(this.value) || "**".equals(this.value);
        }
        return this.isAll;
    }

    protected String[] computeValues(String string) {
        return GenericFilter.values(string);
    }

    public static String[] values(String string) {
        return string.replace(',', ' ').split(" +");
    }

    protected int[] computeModes(String[] stringArray) {
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2;
            String string = stringArray[i];
            int n3 = n2 = string == null ? 0 : string.length();
            if (n2 == 0) {
                nArray[i] = 1010;
                continue;
            }
            boolean bl2 = string.charAt(0) == '*';
            boolean bl3 = bl = string.charAt(n2 - 1) == '*';
            if (bl2) {
                string = string.substring(1);
            }
            if (bl) {
                string = string.substring(0, n2 - (bl2 ? 2 : 1));
            }
            stringArray[i] = string;
            if (string.isEmpty()) {
                nArray[i] = 1010;
                continue;
            }
            if (bl2) {
                if (bl) {
                    nArray[i] = 1010;
                    continue;
                }
                nArray[i] = 1030;
                continue;
            }
            nArray[i] = bl ? 1020 : 1000;
        }
        return nArray;
    }

    public boolean passes(String string) {
        if (this.simplePasses(string)) {
            return true;
        }
        boolean bl = this.type == 10;
        String[] stringArray = this.getValues();
        int[] nArray = this.getModes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.matches(string, stringArray[i], nArray[i])) continue;
            return bl;
        }
        return !bl;
    }

    protected boolean simplePasses(String string) {
        boolean bl;
        if (this.type == 0) {
            return true;
        }
        boolean bl2 = bl = this.type == 10;
        if (this.isAll()) {
            return bl;
        }
        if (this.getValues().length == 0) {
            return bl;
        }
        return false;
    }

    protected boolean matches(String string, String string2, int n) {
        if (string2.isEmpty()) {
            return true;
        }
        switch (n) {
            case 1020: {
                return string.startsWith(string2);
            }
            case 1000: {
                return string.equals(string2);
            }
            case 1030: {
                return string.endsWith(string2);
            }
            case 1010: {
                return string.contains(string2);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().isAssignableFrom(this.getClass()) && !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        return this.valuesEquals(object);
    }

    protected boolean valuesEquals(Object object) {
        GenericFilter genericFilter = (GenericFilter)object;
        if (!Objects.equals(this.name, genericFilter.name)) {
            return false;
        }
        if (!this.value.equals(genericFilter.value)) {
            return false;
        }
        return this.type == genericFilter.type;
    }

    public int hashCode() {
        return this.valuesHashCode(3);
    }

    protected int valuesHashCode(int n) {
        if (this.name != null) {
            n = 67 * n + this.name.hashCode();
        }
        n = 67 * n + this.value.hashCode();
        n = 67 * n + this.type;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[");
        stringBuilder.append("name: ").append(this.getName());
        stringBuilder.append(", value: ").append(this.getValue());
        stringBuilder.append(", type: ").append(GenericFilter.typeString(this.getType()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String typeString(int n) {
        switch (n) {
            case 0: {
                return "TYPE_NONE";
            }
            case 10: {
                return "TYPE_INCLUSIVE";
            }
            case 20: {
                return "TYPE_EXCLUSIVE";
            }
        }
        return "unknown";
    }

    public void store(Properties properties, String string) {
        if (this.name == null) {
            properties.remove(string + PROP_NAME);
        } else {
            properties.put(string + PROP_NAME, this.name);
        }
        properties.put(string + PROP_VALUE, this.value);
        properties.put(string + PROP_TYPE, Integer.toString(this.type));
    }

    private static String loadName(Properties properties, String string) {
        return properties.getProperty(string + PROP_NAME);
    }

    private static String loadValue(Properties properties, String string) {
        String string2 = properties.getProperty(string + PROP_VALUE);
        if (string2 == null) {
            throw new InvalidFilterIdException("No filter value found", string);
        }
        return string2;
    }

    private static int loadType(Properties properties, String string) {
        String string2 = properties.getProperty(string + PROP_TYPE);
        if (string2 == null) {
            throw new InvalidFilterIdException("No filter type found", string);
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFilterIdException("Bad filter type specified", string);
        }
    }

    public static final class InvalidFilterIdException
    extends IllegalArgumentException {
        public InvalidFilterIdException(String string, String string2) {
            super(string + " for filter id " + string2);
        }
    }
}

