/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.results;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.lib.profiler.filters.GenericFilter;

public class ColoredFilter
extends GenericFilter {
    private static final String PROP_COLOR = "COLOR";
    private Color color;
    private transient Icon icon;

    public ColoredFilter(ColoredFilter coloredFilter) {
        super((GenericFilter)coloredFilter);
        this.color = coloredFilter.color;
    }

    public ColoredFilter(String string, String string2, Color color) {
        super(string, string2, 10);
        this.color = color;
    }

    public ColoredFilter(Properties properties, String string) {
        super(properties, string);
        this.color = ColoredFilter.loadColor(properties, string);
    }

    public void copyFrom(ColoredFilter coloredFilter) {
        super.copyFrom((GenericFilter)coloredFilter);
        this.color = coloredFilter.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final Icon getIcon(int n, int n2) {
        if (this.icon == null || this.icon.getIconWidth() != n || this.icon.getIconHeight() != n2) {
            final int n3 = Math.max(16, n);
            final int n4 = Math.max(16, n2);
            final int n5 = n;
            final int n6 = n2;
            final int n7 = n5 >= 16 ? 0 : (16 - n5) / 2;
            final int n8 = n6 >= 16 ? 0 : (16 - n6) / 2;
            this.icon = new Icon(){

                @Override
                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    if (ColoredFilter.this.color == null) {
                        graphics.setColor(Color.BLACK);
                        graphics.drawLine(n + n7, n2 + n8, n + n7 + n5, n2 + n8 + n6);
                        graphics.drawLine(n + n7 + n5, n2 + n8, n + n7, n2 + n8 + n6);
                        graphics.drawRect(n + n7, n2 + n8, n5, n6);
                    } else {
                        graphics.setColor(ColoredFilter.this.color);
                        graphics.fillRect(n + n7, n2 + n8, n5, n6);
                        graphics.setColor(Color.BLACK);
                        graphics.drawRect(n + n7, n2 + n8, n5, n6);
                    }
                }

                @Override
                public int getIconWidth() {
                    return n3;
                }

                @Override
                public int getIconHeight() {
                    return n4;
                }
            };
        }
        return this.icon;
    }

    protected String[] computeValues(String string) {
        return super.computeValues(string.replace('*', ' '));
    }

    public boolean passes(String string) {
        if (this.simplePasses(string)) {
            return true;
        }
        String[] stringArray = this.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean valuesEquals(Object object) {
        if (!super.valuesEquals(object)) {
            return false;
        }
        ColoredFilter coloredFilter = (ColoredFilter)((Object)object);
        return Objects.equals(this.color, coloredFilter.color);
    }

    protected int valuesHashCode(int n) {
        n = super.valuesHashCode(n);
        if (this.color != null) {
            n = 67 * n + this.color.hashCode();
        }
        return n;
    }

    public void store(Properties properties, String string) {
        super.store(properties, string);
        if (this.color != null) {
            properties.put(string + PROP_COLOR, Integer.toString(this.color.getRGB()));
        }
    }

    private static Color loadColor(Properties properties, String string) {
        String string2 = properties.getProperty(string + PROP_COLOR);
        if (string2 == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2);
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GenericFilter.InvalidFilterIdException("Bad color code specified", string);
        }
    }
}

